/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.servlets;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.ServiceStrategy;

public class FileStrategy
implements ServiceStrategy {
    private static int BUFF_SIZE = 4096;
    static int sequence = 0;
    protected static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.servlets");
    private OutputStream safe;
    private File temp;

    public String getId() {
        return "FILE";
    }

    public OutputStream getDestination(HttpServletResponse response) throws IOException {
        ++sequence;
        try {
            this.temp = File.createTempFile("wfs" + sequence, "tmp");
            if (!this.temp.canRead() || !this.temp.canWrite()) {
                String errorMsg = "Temporary-file permission problem for location: " + this.temp.getPath();
                throw new IOException(errorMsg);
            }
        }
        catch (IOException e) {
            String errorMsg = "Possible file permission problem. Root cause: \n" + e.toString();
            IOException newE = new IOException(errorMsg);
            throw newE;
        }
        this.temp.deleteOnExit();
        this.safe = new BufferedOutputStream(new FileOutputStream(this.temp));
        return this.safe;
    }

    /*
     * Loose catch block
     */
    public void flush(HttpServletResponse response) throws IOException {
        block13: {
            InputStream copy;
            block12: {
                int b;
                if (this.temp == null || response == null || this.safe == null || !this.temp.exists()) {
                    LOGGER.fine("temp is " + this.temp + ", response is " + response + " safe is " + this.safe + ", temp exists " + this.temp.exists());
                    throw new IllegalStateException("flush should only be called after getDestination");
                }
                copy = null;
                this.safe.flush();
                this.safe.close();
                this.safe = null;
                copy = new BufferedInputStream(new FileInputStream(this.temp));
                Object out = response.getOutputStream();
                out = new BufferedOutputStream((OutputStream)out, 0x100000);
                byte[] buffer = new byte[BUFF_SIZE];
                while ((b = copy.read(buffer, 0, BUFF_SIZE)) > 0) {
                    ((OutputStream)out).write(buffer, 0, b);
                }
                ((OutputStream)out).flush();
                Object var7_7 = null;
                if (copy == null) break block12;
                try {
                    copy.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            copy = null;
            if (this.temp != null && this.temp.exists()) {
                this.temp.delete();
            }
            break block13;
            {
                catch (IOException ioe) {
                    throw ioe;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (copy != null) {
                    try {
                        copy.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                copy = null;
                if (this.temp != null && this.temp.exists()) {
                    this.temp.delete();
                }
                this.temp = null;
                response = null;
                this.safe = null;
                throw throwable;
            }
        }
        this.temp = null;
        response = null;
        this.safe = null;
    }

    public void abort() {
        if (this.safe != null) {
            try {
                this.safe.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.safe = null;
        }
        if (this.temp != null && this.temp.exists()) {
            this.temp.delete();
        }
        this.temp = null;
    }

    public Object clone() throws CloneNotSupportedException {
        return new FileStrategy();
    }
}

