/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterNotFoundException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.CoverageStoreInfoDTO;
import org.vfny.geoserver.util.CoverageStoreUtils;

public final class CoverageStoreInfo
extends GlobalLayerSupertype {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$global$CoverageStoreInfo == null ? (class$org$vfny$geoserver$global$CoverageStoreInfo = CoverageStoreInfo.class$("org.vfny.geoserver.global.CoverageStoreInfo")) : class$org$vfny$geoserver$global$CoverageStoreInfo).toString());
    private Format format = null;
    private Data data;
    private String id;
    private SoftReference reader = null;
    private SoftReference hintReader = null;
    private String nameSpaceId;
    private String type;
    private String url;
    private boolean enabled;
    private String title;
    private String _abstract;
    private Map meta;
    static /* synthetic */ Class class$org$vfny$geoserver$global$CoverageStoreInfo;

    public CoverageStoreInfo(CoverageStoreInfoDTO config, Data data) {
        this.data = data;
        this.meta = new HashMap(10);
        this.enabled = config.isEnabled();
        this.id = config.getId();
        this.nameSpaceId = config.getNameSpaceId();
        this.type = config.getType();
        this.url = config.getUrl();
        this.title = config.getTitle();
        this._abstract = config.getAbstract();
        this.format = this.lookupFormat();
    }

    private Format lookupFormat() {
        int length = CoverageStoreUtils.formats.length;
        for (int i = 0; i < length; ++i) {
            if (!CoverageStoreUtils.formats[i].getName().equals(this.type)) continue;
            return CoverageStoreUtils.formats[i];
        }
        return null;
    }

    Object toDTO() {
        CoverageStoreInfoDTO dto = new CoverageStoreInfoDTO();
        dto.setAbstract(this._abstract);
        dto.setEnabled(this.enabled);
        dto.setId(this.id);
        dto.setNameSpaceId(this.nameSpaceId);
        dto.setType(this.type);
        dto.setUrl(this.url);
        dto.setTitle(this.title);
        return dto;
    }

    public String getId() {
        return this.id;
    }

    public Format getFormat() throws IllegalStateException, NoSuchElementException {
        if (!this.isEnabled()) {
            throw new IllegalStateException("this format is not enabled, check your configuration");
        }
        if (this.format == null) {
            LOGGER.warning("failed to establish connection with " + this.toString());
            throw new NoSuchElementException("No format found capable of managing " + this.toString());
        }
        return this.format;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return "FormatConfig[type=" + this.getType() + ", enabled=" + this.isEnabled() + ", abstract=" + this.getAbstract() + "]";
    }

    public boolean containsMetaData(String key) {
        return this.meta.containsKey(key);
    }

    public void putMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    public Object getMetaData(String key) {
        return this.meta.get(key);
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public NameSpaceInfo getNameSpace() {
        return this.data.getNameSpace(this.getNamesSpacePrefix());
    }

    public String getNamesSpacePrefix() {
        return this.nameSpaceId;
    }

    public synchronized GridCoverageReader getReader() {
        if (this.reader != null && this.reader.get() != null) {
            return (GridCoverageReader)this.reader.get();
        }
        try {
            CoverageStoreInfo gcInfo = this.data.getFormatInfo(this.id);
            if (gcInfo == null) {
                return null;
            }
            File obj = GeoserverDataDirectory.findDataFile(gcInfo.getUrl());
            this.reader = new SoftReference<GridCoverageReader>(((AbstractGridFormat)gcInfo.getFormat()).getReader((Object)obj));
            return (GridCoverageReader)this.reader.get();
        }
        catch (InvalidParameterValueException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ParameterNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (SecurityException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    public synchronized GridCoverageReader createReader(Hints hints) {
        if (this.hintReader != null && this.hintReader.get() != null) {
            return (GridCoverageReader)this.hintReader.get();
        }
        if (hints == null && this.reader != null && this.reader.get() != null) {
            return (GridCoverageReader)this.reader.get();
        }
        try {
            CoverageStoreInfo gcInfo = this.data.getFormatInfo(this.id);
            if (gcInfo == null) {
                return null;
            }
            File obj = GeoserverDataDirectory.findDataFile(gcInfo.getUrl());
            this.hintReader = new SoftReference<GridCoverageReader>(((AbstractGridFormat)gcInfo.getFormat()).getReader((Object)obj, hints));
            return (GridCoverageReader)this.hintReader.get();
        }
        catch (InvalidParameterValueException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ParameterNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (SecurityException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

