/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.opengis.coverage.grid.Format;
import org.vfny.geoserver.global.dto.CoverageStoreInfoDTO;
import org.vfny.geoserver.util.CoverageStoreUtils;

public class CoverageStoreConfig {
    private String id;
    private String nameSpaceId;
    private String type;
    private String url;
    private boolean enabled = true;
    private String title;
    private String _abstract;
    private Format factory;

    public CoverageStoreConfig(String dataFormatId, String factoryDescription) {
        this(dataFormatId, CoverageStoreUtils.aquireFactory(factoryDescription));
    }

    public CoverageStoreConfig(String dataFormatId, Format factory) {
        this.factory = factory;
        this.id = dataFormatId;
        this.nameSpaceId = "";
        this.type = factory.getName();
        this.url = "file:coverages/";
        this.enabled = true;
        this.title = "";
        this._abstract = "";
    }

    public CoverageStoreConfig(CoverageStoreInfoDTO dto) {
        this.reset(dto);
    }

    public void reset(CoverageStoreInfoDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Non null CoverageStoreInfoDTO required");
        }
        this.factory = CoverageStoreUtils.aquireFactoryByType(dto.getType());
        this.id = dto.getId();
        this.nameSpaceId = dto.getNameSpaceId();
        this.type = dto.getType();
        this.url = dto.getUrl();
        this.enabled = dto.isEnabled();
        this._abstract = dto.getAbstract();
    }

    public void update(CoverageStoreInfoDTO df) {
        if (df == null) {
            throw new NullPointerException("CoverageStoreInfo Data Transfer Object required");
        }
        this.id = df.getId();
        this.nameSpaceId = df.getNameSpaceId();
        this.type = df.getType();
        this.url = df.getUrl();
        this.enabled = df.isEnabled();
        this._abstract = df.getAbstract();
    }

    public CoverageStoreInfoDTO toDTO() {
        CoverageStoreInfoDTO ds = new CoverageStoreInfoDTO();
        ds.setId(this.id);
        ds.setNameSpaceId(this.nameSpaceId);
        ds.setType(this.type);
        ds.setUrl(this.url);
        ds.setEnabled(this.enabled);
        ds.setAbstract(this._abstract);
        return ds;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAbstract(String string) {
        if (string != null) {
            this._abstract = string;
        }
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setTitle(String string) {
        if (string != null) {
            this.title = string;
        }
    }

    public Format findDataFormat(ServletContext sc) throws IOException {
        return CoverageStoreUtils.acquireFormat(this.type, sc);
    }

    public Format getFactory() {
        return this.factory;
    }

    public void setFactory(Format factory) {
        this.factory = factory;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getNameSpaceId() {
        return this.nameSpaceId;
    }

    public void setNameSpaceId(String nameSpaceId) {
        this.nameSpaceId = nameSpaceId;
    }
}

