/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.units.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridRange;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.CoverageStoreConfig;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.CoverageDimension;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.CoverageInfoDTO;
import org.vfny.geoserver.util.CoverageStoreUtils;
import org.vfny.geoserver.util.CoverageUtils;

public class CoverageConfig {
    private String formatId;
    private String name;
    private String wmsPath;
    private String label;
    private String description;
    private MetaDataLink metadataLink;
    private String dirName;
    private List keywords;
    private GeneralEnvelope envelope;
    private GeneralEnvelope lonLatWGS84Envelope;
    private GridGeometry grid;
    private CoverageDimension[] dimensions;
    private InternationalString[] dimentionNames;
    private List requestCRSs;
    private List responseCRSs;
    private String nativeFormat;
    private List supportedFormats;
    private String defaultInterpolationMethod;
    private List interpolationMethods;
    private String srsName;
    private String srsWKT;
    private CoordinateReferenceSystem crs;
    private String defaultStyle;
    private ArrayList styles;
    private Map parameters;

    CoverageConfig() {
    }

    public CoverageConfig(String formatId, Format format, AbstractGridCoverage2DReader reader, HttpServletRequest request) throws ConfigurationException {
        StringBuffer key;
        GridCoverage2D gc;
        if (formatId == null || formatId.length() == 0) {
            throw new IllegalArgumentException("formatId is required for CoverageConfig");
        }
        if (format == null) {
            throw new ConfigurationException("Cannot handle format: " + formatId);
        }
        this.formatId = formatId;
        DataConfig dataConfig = this.getDataConfig(request);
        CoverageStoreConfig cvConfig = dataConfig.getDataFormat(formatId);
        if (cvConfig == null) {
            throw new RuntimeException("selectedCoverageSetId required in Session");
        }
        this.crs = reader.getCrs();
        this.srsName = this.crs != null && !this.crs.getIdentifiers().isEmpty() ? this.crs.getIdentifiers().toArray()[0].toString() : "UNKNOWN";
        this.srsWKT = this.crs != null ? this.crs.toWKT() : "UNKNOWN";
        this.envelope = reader.getOriginalEnvelope();
        try {
            this.lonLatWGS84Envelope = CoverageStoreUtils.getWGS84LonLatEnvelope(this.envelope);
        }
        catch (IndexOutOfBoundsException e) {
            ConfigurationException newEx = new ConfigurationException("Converting Envelope to Lat-Lon WGS84: " + e.toString());
            newEx.initCause(e);
            throw newEx;
        }
        catch (FactoryException e) {
            ConfigurationException newEx = new ConfigurationException("Converting Envelope to Lat-Lon WGS84: " + e.toString());
            newEx.initCause(e);
            throw newEx;
        }
        catch (TransformException e) {
            ConfigurationException newEx = new ConfigurationException("Converting Envelope to Lat-Lon WGS84: " + e.toString());
            newEx.initCause(e);
            throw newEx;
        }
        this.grid = new GridGeometry2D((GridRange)reader.getOriginalGridRange(), (Envelope)reader.getOriginalEnvelope());
        try {
            ParameterValueGroup readParams = format.getReadParameters();
            Map parameters = CoverageUtils.getParametersKVP(readParams);
            double[] minCP = this.envelope.getLowerCorner().getCoordinates();
            double[] maxCP = new double[]{minCP[0] + this.envelope.getLength(0) / 20.0, minCP[1] + this.envelope.getLength(1) / 20.0};
            GeneralEnvelope subEnvelope = new GeneralEnvelope(minCP, maxCP);
            subEnvelope.setCoordinateReferenceSystem(reader.getCrs());
            parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), new GridGeometry2D((GridRange)reader.getOriginalGridRange(), (Envelope)subEnvelope));
            gc = (GridCoverage2D)reader.read(CoverageUtils.getParameters(readParams, parameters, true));
            this.dimensions = this.parseCoverageDimesions(gc.getSampleDimensions());
        }
        catch (UnsupportedEncodingException e) {
            ConfigurationException newEx = new ConfigurationException("Coverage dimensions: " + e.toString());
            newEx.initCause(e);
            throw newEx;
        }
        catch (IllegalArgumentException e) {
            ConfigurationException newEx = new ConfigurationException("Coverage dimensions: " + e.toString());
            newEx.initCause(e);
            throw newEx;
        }
        catch (IOException e) {
            ConfigurationException newEx = new ConfigurationException("Coverage dimensions: " + e.toString());
            newEx.initCause(e);
            throw newEx;
        }
        this.dimentionNames = gc.getDimensionNames();
        DataConfig config = ConfigRequests.getDataConfig(request);
        StringBuffer cvName = new StringBuffer(gc.getName().toString());
        int count = 0;
        while (true) {
            key = new StringBuffer(gc.getName().toString());
            if (count > 0) {
                key.append("_").append(count);
            }
            Map coverages = config.getCoverages();
            Set cvKeySet = coverages.keySet();
            boolean key_exists = false;
            Iterator it = cvKeySet.iterator();
            while (it.hasNext()) {
                String cvKey = ((String)it.next()).toLowerCase();
                if (!cvKey.endsWith(key.toString().toLowerCase())) continue;
                key_exists = true;
            }
            if (!key_exists) break;
            ++count;
        }
        cvName = key;
        this.name = cvName.toString();
        this.wmsPath = "/";
        this.label = this.name + " is a " + format.getDescription();
        this.description = "Generated from " + formatId;
        this.metadataLink = new MetaDataLink();
        this.metadataLink.setAbout(format.getDocURL());
        this.metadataLink.setMetadataType("other");
        this.keywords = new ArrayList(10);
        this.keywords.add("WCS");
        this.keywords.add(formatId);
        this.keywords.add(this.name);
        this.nativeFormat = format.getName();
        this.dirName = formatId + "_" + this.name;
        this.requestCRSs = new ArrayList(10);
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            this.requestCRSs.add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        this.responseCRSs = new ArrayList(10);
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            this.responseCRSs.add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        this.supportedFormats = new ArrayList(10);
        List formats = CoverageStoreUtils.listDataFormats();
        Iterator i = formats.iterator();
        while (i.hasNext()) {
            Format fTmp = (Format)i.next();
            String fName = fTmp.getName();
            if (fName.equalsIgnoreCase("WorldImage")) {
                this.supportedFormats.add("GIF");
                this.supportedFormats.add("PNG");
                this.supportedFormats.add("JPEG");
                this.supportedFormats.add("TIFF");
                continue;
            }
            if (fName.toLowerCase().startsWith("geotiff")) {
                this.supportedFormats.add("GeoTIFF");
                continue;
            }
            this.supportedFormats.add(fName);
        }
        this.defaultInterpolationMethod = "nearest neighbor";
        this.interpolationMethods = new ArrayList(10);
        this.interpolationMethods.add("nearest neighbor");
        this.interpolationMethods.add("bilinear");
        this.interpolationMethods.add("bicubic");
        this.defaultStyle = "raster";
        this.styles = new ArrayList();
        this.parameters = CoverageUtils.getParametersKVP(format.getReadParameters());
    }

    private CoverageDimension[] parseCoverageDimesions(GridSampleDimension[] sampleDimensions) throws UnsupportedEncodingException {
        int length = sampleDimensions.length;
        CoverageDimension[] dims = new CoverageDimension[length];
        for (int i = 0; i < length; ++i) {
            dims[i] = new CoverageDimension();
            dims[i].setName(sampleDimensions[i].getDescription().toString(Locale.getDefault()));
            StringBuffer label = new StringBuffer("GridSampleDimension".intern());
            Unit uom = sampleDimensions[i].getUnits();
            if (uom != null) {
                label.append("(".intern());
                this.parseUom(label, uom);
                label.append(")".intern());
            }
            label.append("[".intern());
            label.append(sampleDimensions[i].getMinimumValue());
            label.append(",".intern());
            label.append(sampleDimensions[i].getMaximumValue());
            label.append("]".intern());
            dims[i].setDescription(label.toString());
            dims[i].setRange(sampleDimensions[i].getRange());
            List categories = sampleDimensions[i].getCategories();
            Category cat = null;
            Iterator c_iT = categories.iterator();
            while (c_iT.hasNext()) {
                Double[] doubleArray;
                cat = (Category)c_iT.next();
                if (cat == null || !cat.getName().toString().equalsIgnoreCase("no data")) continue;
                double min = cat.getRange().getMinimum();
                double max = cat.getRange().getMaximum();
                CoverageDimension coverageDimension = dims[i];
                if (min == max) {
                    Double[] doubleArray2 = new Double[1];
                    doubleArray = doubleArray2;
                    doubleArray2[0] = new Double(min);
                } else {
                    Double[] doubleArray3 = new Double[2];
                    doubleArray3[0] = new Double(min);
                    doubleArray = doubleArray3;
                    doubleArray3[1] = new Double(max);
                }
                coverageDimension.setNullValues(doubleArray);
            }
        }
        return dims;
    }

    private void parseUom(StringBuffer label2, Unit uom) {
        String uomString = uom.toString();
        uomString = uomString.replaceAll("\u00ef\u00bf\u00bd", "^2");
        uomString = uomString.replaceAll("\u00ef\u00bf\u00bd", "^3");
        uomString = uomString.replaceAll("\u00ef\u00bf\u00bd", "A");
        uomString = uomString.replaceAll("\u00ef\u00bf\u00bd", "");
        label2.append(uomString);
    }

    public CoverageConfig(CoverageInfoDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Non null CoverageInfoDTO required");
        }
        this.formatId = dto.getFormatId();
        this.name = dto.getName();
        this.wmsPath = dto.getWmsPath();
        this.label = dto.getLabel();
        this.description = dto.getDescription();
        this.metadataLink = dto.getMetadataLink();
        this.keywords = dto.getKeywords();
        this.crs = dto.getCrs();
        this.srsName = dto.getSrsName();
        this.srsWKT = dto.getSrsWKT();
        this.envelope = dto.getEnvelope();
        this.lonLatWGS84Envelope = dto.getLonLatWGS84Envelope();
        this.grid = dto.getGrid();
        this.dimensions = dto.getDimensions();
        this.dimentionNames = dto.getDimensionNames();
        this.nativeFormat = dto.getNativeFormat();
        this.dirName = dto.getDirName();
        this.requestCRSs = dto.getRequestCRSs();
        this.responseCRSs = dto.getResponseCRSs();
        this.supportedFormats = dto.getSupportedFormats();
        this.defaultInterpolationMethod = dto.getDefaultInterpolationMethod();
        this.interpolationMethods = dto.getInterpolationMethods();
        this.defaultStyle = dto.getDefaultStyle();
        this.styles = dto.getStyles();
        this.parameters = dto.getParameters();
    }

    public CoverageInfoDTO toDTO() {
        CoverageInfoDTO c = new CoverageInfoDTO();
        c.setFormatId(this.formatId);
        c.setName(this.name);
        c.setWmsPath(this.wmsPath);
        c.setLabel(this.label);
        c.setDescription(this.description);
        c.setMetadataLink(this.metadataLink);
        c.setKeywords(this.keywords);
        c.setCrs(this.crs);
        c.setSrsName(this.srsName);
        c.setSrsWKT(this.srsWKT);
        c.setEnvelope(this.envelope);
        c.setLonLatWGS84Envelope(this.lonLatWGS84Envelope);
        c.setGrid(this.grid);
        c.setDimensions(this.dimensions);
        c.setDimensionNames(this.dimentionNames);
        c.setNativeFormat(this.nativeFormat);
        c.setDirName(this.dirName);
        c.setRequestCRSs(this.requestCRSs);
        c.setResponseCRSs(this.responseCRSs);
        c.setSupportedFormats(this.supportedFormats);
        c.setDefaultInterpolationMethod(this.defaultInterpolationMethod);
        c.setInterpolationMethods(this.interpolationMethods);
        c.setDefaultStyle(this.defaultStyle);
        c.setStyles(this.styles);
        c.setParameters(this.parameters);
        return c;
    }

    protected DataConfig getDataConfig(HttpServletRequest request) {
        return (DataConfig)request.getSession().getServletContext().getAttribute("Config.Data");
    }

    public String getKey() {
        return this.getFormatId() + ":::" + this.getName();
    }

    public String toString() {
        return "CoverageConfig[name: " + this.name + " dewcription: " + this.description + " srsName: " + this.srsName + "]";
    }

    public String getDefaultInterpolationMethod() {
        return this.defaultInterpolationMethod;
    }

    public void setDefaultInterpolationMethod(String defaultInterpolationMethod) {
        this.defaultInterpolationMethod = defaultInterpolationMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public GeneralEnvelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(GeneralEnvelope envelope) {
        this.envelope = envelope;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }

    public List getInterpolationMethods() {
        return this.interpolationMethods;
    }

    public void setInterpolationMethods(List interpolationMethods) {
        this.interpolationMethods = interpolationMethods;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List keywords) {
        this.keywords = keywords;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public MetaDataLink getMetadataLink() {
        return this.metadataLink;
    }

    public void setMetadataLink(MetaDataLink metadataLink) {
        this.metadataLink = metadataLink;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNativeFormat() {
        return this.nativeFormat;
    }

    public void setNativeFormat(String nativeFormat) {
        this.nativeFormat = nativeFormat;
    }

    public List getRequestCRSs() {
        return this.requestCRSs;
    }

    public void setRequestCRSs(List requestCRSs) {
        this.requestCRSs = requestCRSs;
    }

    public List getResponseCRSs() {
        return this.responseCRSs;
    }

    public void setResponseCRSs(List responseCRSs) {
        this.responseCRSs = responseCRSs;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    public List getSupportedFormats() {
        return this.supportedFormats;
    }

    public void setSupportedFormats(List supportedFormats) {
        this.supportedFormats = supportedFormats;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public GridGeometry getGrid() {
        return this.grid;
    }

    public void setGrid(GridGeometry grid) {
        this.grid = grid;
    }

    public InternationalString[] getDimentionNames() {
        return this.dimentionNames;
    }

    public void setDimentionNames(InternationalString[] dimentionNames) {
        this.dimentionNames = dimentionNames;
    }

    public CoverageDimension[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(CoverageDimension[] dimensions) {
        this.dimensions = dimensions;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(String defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public ArrayList getStyles() {
        return this.styles;
    }

    public void setStyles(ArrayList styles) {
        this.styles = styles;
    }

    public void addStyle(String style) {
        if (!this.styles.contains(style)) {
            this.styles.add(style);
        }
    }

    public String getSrsWKT() {
        return this.srsWKT;
    }

    public void setSrsWKT(String srsWKT) {
        this.srsWKT = srsWKT;
    }

    public GeneralEnvelope getLonLatWGS84Envelope() {
        return this.lonLatWGS84Envelope;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public synchronized void setParameters(Map parameters) {
        this.parameters = parameters;
    }
}

