/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.OWS;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.vfny.geoserver.global.GeoServer;

public class LegacyServiceExceptionHandler
extends ServiceExceptionHandler {
    OWS ows;
    String version = "1.2.0";
    String dtdLocation = null;
    String schemaLocation = null;
    String contentType = "text/xml";
    GeoServer geoServer;

    public LegacyServiceExceptionHandler(List services, OWS ows, GeoServer geoServer) {
        super(services);
        this.ows = ows;
        this.geoServer = geoServer;
    }

    public LegacyServiceExceptionHandler(Service service, OWS ows, GeoServer geoServer) {
        super(service);
        this.ows = ows;
        this.geoServer = geoServer;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDTDLocation(String dtd) {
        this.dtdLocation = dtd;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void handleServiceException(ServiceException exception, Service service, HttpServletRequest request, HttpServletResponse response) {
        String tab = "   ";
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"");
        sb.append(" encoding=\"UTF-8\"");
        if (this.dtdLocation != null) {
            sb.append(" standalone=\"no\"");
        }
        sb.append("?>");
        if (this.dtdLocation != null) {
            String fullDtdLocation = ResponseUtils.appendPath((String)this.ows.getSchemaBaseURL(), (String)this.dtdLocation);
            sb.append("<!DOCTYPE ServiceExceptionReport SYSTEM \"" + fullDtdLocation + "\"> ");
        }
        sb.append("<ServiceExceptionReport version=\"" + this.version + "\" ");
        if (this.schemaLocation != null && this.dtdLocation == null) {
            String fullSchemaLocation = ResponseUtils.appendPath((String)this.ows.getSchemaBaseURL(), (String)this.schemaLocation);
            sb.append("xmlns=\"http://www.opengis.net/ogc\" ");
            sb.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            sb.append("xsi:schemaLocation=\"http://www.opengis.net/ogc " + fullSchemaLocation + "\"");
        }
        sb.append(">");
        sb.append(tab + "<ServiceException");
        if (exception.getCode() != null && !exception.getCode().equals("")) {
            sb.append(" code=\"" + exception.getCode() + "\"");
        }
        if (exception.getLocator() != null && !exception.getLocator().equals("")) {
            sb.append(" locator=\"" + exception.getLocator() + "\"");
        }
        sb.append(">");
        if (exception.getMessage() != null) {
            sb.append("\n" + tab + tab);
            this.dumpExceptionMessages(exception, sb);
            if (this.geoServer.isVerboseExceptions()) {
                ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                exception.printStackTrace(new PrintStream(stackTrace));
                sb.append("\nDetails:\n");
                sb.append(ResponseUtils.encodeXML((String)new String(stackTrace.toByteArray())));
            }
        }
        sb.append("\n</ServiceException>");
        sb.append("</ServiceExceptionReport>");
        response.setContentType(this.contentType);
        response.setCharacterEncoding("UTF-8");
        try {
            response.getOutputStream().write(sb.toString().getBytes());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            ServiceExceptionHandler.LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", e);
        }
    }
}

