/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.vfny.geoserver.servlets.ServiceStrategy;
import org.vfny.geoserver.util.PartialBufferedOutputStream2;

public class PartialBufferStrategy2
implements ServiceStrategy {
    protected static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.servlets");
    public static final int DEFAULT_BUFFER_SIZE = 50;
    private PartialBufferedOutputStream2 out = null;
    private int bufferSize;

    public String getId() {
        return "PARTIAL-BUFFER2";
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    private int bufferedSize() {
        if (this.bufferSize > 0) {
            return this.bufferSize;
        }
        return 50;
    }

    public OutputStream getDestination(HttpServletResponse response) throws IOException {
        this.out = new PartialBufferedOutputStream2(response, this.bufferedSize());
        return this.out;
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out = null;
        }
    }

    public void abort() {
        if (this.out != null) {
            try {
                if (this.out.abort()) {
                    LOGGER.info("OutputStream was successfully aborted.");
                } else {
                    LOGGER.warning("OutputStream could not be aborted in time. An error has occurred and could not be sent to the user.");
                }
            }
            catch (IOException e) {
                LOGGER.warning("Error aborting OutputStream");
                e.printStackTrace();
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PartialBufferStrategy2 clone = new PartialBufferStrategy2();
        clone.bufferSize = this.bufferSize;
        return clone;
    }
}

