/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import java.nio.charset.Charset;
import java.util.logging.Level;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.DataTransferObject;

public final class GeoServerDTO
implements DataTransferObject {
    private int maxFeatures = 10000;
    private boolean verbose = true;
    private int numDecimals = 4;
    private Charset charSet = Defaults.Encoding;
    private String proxyBaseUrl;
    private String schemaBaseUrl;
    private Level loggingLevel = Defaults.LoggingLevel;
    private ContactDTO contact = null;
    private String adminUserName = "admin";
    private String adminPassword = "geoserver";
    private boolean verboseExceptions = false;
    private boolean loggingToFile = false;
    private String logLocation = Defaults.LogLocation;
    private double jaiMemoryCapacity = 2.097152E8;
    private double jaiMemoryThreshold = 0.75;
    private int jaiTileThreads = 7;
    private int jaiTilePriority = 5;
    private Boolean jaiRecycling = Defaults.JaiRecycling;
    private Boolean imageIOCache = Defaults.ImageIOCache;
    private Boolean jaiJPEGNative = Defaults.JaiJPEGNative;
    private Boolean jaiPNGNative = Defaults.JaiPNGNative;
    private String tileCache;

    public GeoServerDTO() {
    }

    public GeoServerDTO(GeoServerDTO g) {
        if (g == null) {
            throw new NullPointerException();
        }
        this.maxFeatures = g.getMaxFeatures();
        this.verbose = g.isVerbose();
        this.numDecimals = g.getNumDecimals();
        this.charSet = g.getCharSet();
        this.schemaBaseUrl = g.getSchemaBaseUrl();
        this.proxyBaseUrl = g.getProxyBaseUrl();
        this.loggingLevel = g.getLoggingLevel();
        this.verboseExceptions = g.isVerboseExceptions();
        this.loggingToFile = g.getLoggingToFile();
        this.logLocation = g.getLogLocation();
        this.jaiMemoryCapacity = g.getJaiMemoryCapacity();
        this.jaiMemoryThreshold = g.getJaiMemoryThreshold();
        this.jaiTileThreads = g.getJaiTileThreads();
        this.jaiTilePriority = g.getJaiTilePriority();
        this.jaiRecycling = g.getJaiRecycling();
        this.imageIOCache = g.getImageIOCache();
        this.jaiJPEGNative = g.getJaiJPEGNative();
        this.jaiPNGNative = g.getJaiPNGNative();
        this.tileCache = g.getTileCache();
        this.contact = g.getContact() != null ? (ContactDTO)g.getContact().clone() : new ContactDTO();
    }

    public Object clone() {
        return new GeoServerDTO(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GeoServerDTO)) {
            return false;
        }
        GeoServerDTO g = (GeoServerDTO)obj;
        boolean r = true;
        r = r && this.maxFeatures == g.getMaxFeatures();
        r = r && this.verbose == g.isVerbose();
        boolean bl = r = r && this.numDecimals == g.getNumDecimals();
        if (this.charSet != null) {
            r = r && this.charSet.equals(g.getCharSet());
        } else if (g.getCharSet() != null) {
            return false;
        }
        r = r && this.schemaBaseUrl == g.getSchemaBaseUrl();
        boolean bl2 = r = r && this.proxyBaseUrl == g.getProxyBaseUrl();
        if (this.contact != null) {
            r = r && this.contact.equals(g.getContact());
        } else if (g.getContact() != null) {
            return false;
        }
        boolean bl3 = r = r && this.loggingToFile == g.getLoggingToFile();
        if (this.logLocation != null) {
            r = r && this.logLocation.equals(g.getLogLocation());
        } else if (g.getLogLocation() != null) {
            return false;
        }
        r = r && this.jaiMemoryCapacity == g.getJaiMemoryCapacity();
        r = r && this.jaiMemoryThreshold == g.getJaiMemoryThreshold();
        r = r && this.jaiTileThreads == g.getJaiTileThreads();
        r = r && this.jaiTilePriority == g.getJaiTilePriority();
        r = r && this.jaiRecycling == g.getJaiRecycling();
        r = r && this.imageIOCache == g.getImageIOCache();
        r = r && this.jaiJPEGNative == g.getJaiJPEGNative();
        boolean bl4 = r = r && this.jaiPNGNative == g.getJaiPNGNative();
        if (this.tileCache != null) {
            r = r && this.tileCache.equals(g.getTileCache());
        } else if (g.getTileCache() != null) {
            return false;
        }
        return r;
    }

    public int hashCode() {
        int i = 1;
        if (this.maxFeatures != 0) {
            i *= this.maxFeatures;
        }
        if (this.numDecimals != 0) {
            i *= this.numDecimals;
        }
        if (this.schemaBaseUrl != null) {
            i *= this.schemaBaseUrl.hashCode();
        }
        if (this.tileCache != null) {
            i *= this.tileCache.hashCode();
        }
        return i;
    }

    public Charset getCharSet() {
        return this.charSet;
    }

    public ContactDTO getContact() {
        return this.contact;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    public String getSchemaBaseUrl() {
        return this.schemaBaseUrl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setCharSet(Charset charset) {
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        this.charSet = charset;
    }

    public void setContact(ContactDTO contact) {
        if (contact == null) {
            contact = new ContactDTO();
        }
        this.contact = contact;
    }

    public void setMaxFeatures(int i) {
        this.maxFeatures = i;
    }

    public void setNumDecimals(int i) {
        this.numDecimals = i;
    }

    public void setSchemaBaseUrl(String url) {
        this.schemaBaseUrl = url;
    }

    public void setProxyBaseUrl(String url) {
        this.proxyBaseUrl = url;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(Level level) {
        this.loggingLevel = level;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public void setAdminUserName(String username) {
        this.adminUserName = username;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String password) {
        this.adminPassword = password;
    }

    public boolean isVerboseExceptions() {
        return this.verboseExceptions;
    }

    public void setVerboseExceptions(boolean showStackTraces) {
        this.verboseExceptions = showStackTraces;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    public boolean getLoggingToFile() {
        return this.loggingToFile;
    }

    public void setLoggingToFile(boolean loggingToFile) {
        this.loggingToFile = loggingToFile;
    }

    public String toString() {
        StringBuffer dto = new StringBuffer("[GeoServerDTO: \n");
        dto.append("   maxFeatures - " + this.maxFeatures);
        dto.append("\n   verbose - " + this.verbose);
        dto.append("\n   numDecimals - " + this.numDecimals);
        dto.append("\n   charSet - " + this.charSet);
        dto.append("\n   loggingLevel - " + this.loggingLevel);
        dto.append("\n   adminUserName - " + this.adminUserName);
        dto.append("\n   adminPassword - " + this.adminPassword);
        dto.append("\n   contact - " + this.contact);
        return dto.toString();
    }

    public double getJaiMemoryCapacity() {
        return this.jaiMemoryCapacity;
    }

    public void setJaiMemoryCapacity(double jaiMemoryCapacity) {
        this.jaiMemoryCapacity = jaiMemoryCapacity;
    }

    public Boolean getJaiRecycling() {
        return this.jaiRecycling;
    }

    public void setJaiRecycling(Boolean jaiRecycling) {
        this.jaiRecycling = jaiRecycling;
    }

    public Boolean getJaiJPEGNative() {
        return this.jaiJPEGNative;
    }

    public void setJaiJPEGNative(Boolean jaiJPEGNative) {
        this.jaiJPEGNative = jaiJPEGNative;
    }

    public Boolean getJaiPNGNative() {
        return this.jaiPNGNative;
    }

    public void setJaiPNGNative(Boolean jaiPNGNative) {
        this.jaiPNGNative = jaiPNGNative;
    }

    public double getJaiMemoryThreshold() {
        return this.jaiMemoryThreshold;
    }

    public void setJaiMemoryThreshold(double jaiMemoryThreshold) {
        this.jaiMemoryThreshold = jaiMemoryThreshold;
    }

    public Boolean getImageIOCache() {
        return this.imageIOCache;
    }

    public void setImageIOCache(Boolean imageIOCache) {
        this.imageIOCache = imageIOCache;
    }

    public int getJaiTilePriority() {
        return this.jaiTilePriority;
    }

    public void setJaiTilePriority(int jaiTilePriority) {
        this.jaiTilePriority = jaiTilePriority;
    }

    public int getJaiTileThreads() {
        return this.jaiTileThreads;
    }

    public void setJaiTileThreads(int jaiTileThreads) {
        this.jaiTileThreads = jaiTileThreads;
    }

    public String getTileCache() {
        return this.tileCache;
    }

    public void setTileCache(String tileCache) {
        this.tileCache = tileCache;
    }

    public static class Defaults {
        public static final int MaxFeatures = 10000;
        public static final Charset Encoding = Charset.forName("UTF-8");
        public static final boolean Verbose = true;
        public static final int NumDecimals = 4;
        public static final Level LoggingLevel = Level.INFO;
        public static final String AdminUserName = "admin";
        public static final String AdminPassword = "geoserver";
        public static final boolean VerboseExceptions = false;
        public static final boolean LoggingToFile = false;
        public static final String LogLocation = null;
        public static final long JaiMemoryCapacity = 0xC800000L;
        public static final double JaiMemoryThreshold = 0.75;
        public static final int JaiTileThreads = 7;
        public static final int JaiTilePriority = 5;
        public static final Boolean JaiRecycling = Boolean.TRUE;
        public static final Boolean ImageIOCache = Boolean.FALSE;
        public static final Boolean JaiJPEGNative = Boolean.TRUE;
        public static final Boolean JaiPNGNative = Boolean.TRUE;
        public static final String BaseURL = null;
    }
}

