/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveChangeListener;
import org.geotools.catalog.Service;
import org.geotools.catalog.ServiceInfo;
import org.geotools.catalog.defaults.DefaultServiceInfo;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.util.ProgressListener;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;

public class DataStoreInfo
extends GlobalLayerSupertype
implements Service {
    private DataStore dataStore = null;
    private Data data;
    private String id;
    private String nameSpaceId;
    private boolean enabled;
    private String title;
    private String _abstract;
    private Map connectionParams;
    private Map meta;
    private Catalog catalog;
    File baseDir;
    URL baseURL;
    List members = new ArrayList();
    ServiceInfo info;
    static /* synthetic */ Class class$org$geotools$data$DataStore;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$geotools$catalog$ServiceInfo;

    public DataStoreInfo(DataStoreInfoDTO config, Data data) {
        this.data = data;
        this.meta = new HashMap();
        this.connectionParams = config.getConnectionParams();
        this.enabled = config.isEnabled();
        this.id = config.getId();
        this.nameSpaceId = config.getNameSpaceId();
        this.title = config.getTitle();
        this._abstract = config.getAbstract();
        this.catalog = data.getCatalog();
    }

    Object toDTO() {
        DataStoreInfoDTO dto = new DataStoreInfoDTO();
        dto.setAbstract(this._abstract);
        dto.setConnectionParams(this.connectionParams);
        dto.setEnabled(this.enabled);
        dto.setId(this.id);
        dto.setNameSpaceId(this.nameSpaceId);
        dto.setTitle(this.title);
        return dto;
    }

    public String getId() {
        return this.id;
    }

    protected Map getParams() {
        HashMap<String, String> params = new HashMap<String, String>(this.connectionParams);
        params.put("namespace", this.getNameSpace().getURI());
        return DataStoreInfo.getParams(params, this.data.getBaseDir().toString());
    }

    public static Map getParams(Map m, String baseDir) {
        Map params = Collections.synchronizedMap(new HashMap(m));
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                if (key != null && key.matches(".* *url") && value instanceof String) {
                    String path = (String)value;
                    GlobalLayerSupertype.LOGGER.finer("in string url");
                    if (!path.startsWith("file:")) continue;
                    File fixedPath = GeoserverDataDirectory.findDataFile(path);
                    entry.setValue(fixedPath.toURL().toExternalForm());
                    continue;
                }
                if (!(value instanceof URL) || !((URL)value).getProtocol().equals("file")) continue;
                File fixedPath = GeoserverDataDirectory.findDataFile((URL)value);
                entry.setValue(fixedPath.toURL());
            }
            catch (MalformedURLException ignore) {}
        }
        return params;
    }

    public synchronized DataStore getDataStore() throws IllegalStateException, NoSuchElementException {
        if (!this.isEnabled()) {
            throw new IllegalStateException("this datastore is not enabled, check your configuration");
        }
        Map m = this.getParams();
        if (this.dataStore == null) {
            try {
                this.dataStore = DataStoreFinder.getDataStore((Map)m);
                GlobalLayerSupertype.LOGGER.fine("connection established by " + this.toString());
            }
            catch (Throwable ex) {
                throw new IllegalStateException("can't create the datastore " + this.getId() + ": " + ex.getClass().getName() + ": " + ex.getMessage() + "\n" + ex.toString());
            }
            if (this.dataStore == null) {
                this.enabled = false;
                GlobalLayerSupertype.LOGGER.fine("failed to establish connection with " + this.toString());
                throw new NoSuchElementException("No datastore found capable of managing " + this.toString());
            }
        }
        return this.dataStore;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NameSpaceInfo getNameSpace() {
        return this.data.getNameSpace(this.getNamesSpacePrefix());
    }

    public String getNamesSpacePrefix() {
        return this.nameSpaceId;
    }

    public String toString() {
        return "DataStoreConfig[namespace=" + this.getNameSpace().getPrefix() + ", enabled=" + this.isEnabled() + ", abstract=" + this.getAbstract() + ", connection parameters=" + this.getParams() + "]";
    }

    public boolean containsMetaData(String key) {
        return this.meta.containsKey(key);
    }

    public void putMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    public Object getMetaData(String key) {
        return this.meta.get(key);
    }

    public void addMember(FeatureTypeInfo ftInfo) {
        this.members.add(ftInfo);
    }

    public List members(ProgressListener monitor) throws IOException {
        return this.members;
    }

    public boolean canResolve(Class adaptee) {
        return (class$org$geotools$data$DataStore == null ? (class$org$geotools$data$DataStore = DataStoreInfo.class$("org.geotools.data.DataStore")) : class$org$geotools$data$DataStore).isAssignableFrom(adaptee) || (class$java$util$List == null ? (class$java$util$List = DataStoreInfo.class$("java.util.List")) : class$java$util$List).isAssignableFrom(adaptee) || (class$org$geotools$catalog$ServiceInfo == null ? (class$org$geotools$catalog$ServiceInfo = DataStoreInfo.class$("org.geotools.catalog.ServiceInfo")) : class$org$geotools$catalog$ServiceInfo).isAssignableFrom(adaptee);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if ((class$org$geotools$data$DataStore == null ? (class$org$geotools$data$DataStore = DataStoreInfo.class$("org.geotools.data.DataStore")) : class$org$geotools$data$DataStore).isAssignableFrom(adaptee)) {
            return this.getDataStore();
        }
        if ((class$java$util$List == null ? (class$java$util$List = DataStoreInfo.class$("java.util.List")) : class$java$util$List).isAssignableFrom(adaptee)) {
            return this.members(monitor);
        }
        if ((class$org$geotools$catalog$ServiceInfo == null ? (class$org$geotools$catalog$ServiceInfo = DataStoreInfo.class$("org.geotools.catalog.ServiceInfo")) : class$org$geotools$catalog$ServiceInfo).isAssignableFrom(adaptee)) {
            return this.getInfo(monitor);
        }
        return null;
    }

    public Map getConnectionParams() {
        return this.getParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getInfo(ProgressListener monitor) throws IOException {
        if (this.info == null) {
            DataStoreInfo dataStoreInfo = this;
            synchronized (dataStoreInfo) {
                if (this.info == null) {
                    this.info = new DefaultServiceInfo(this.getTitle(), null, this.getAbstract(), null, null, null, null, null);
                }
            }
        }
        return this.info;
    }

    public Resolve parent(ProgressListener monitor) throws IOException {
        return this.catalog;
    }

    public Resolve.Status getStatus() {
        if (this.isEnabled()) {
            return Resolve.Status.CONNECTED;
        }
        return Resolve.Status.NOTCONNECTED;
    }

    public Throwable getMessage() {
        return null;
    }

    public URI getIdentifier() {
        try {
            URI uri = new URI(this.getNameSpace().getURI());
            String path = uri.getPath();
            if (path == null) {
                path = this.getId();
            } else {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                path = path + this.getId();
            }
            return new URI(uri.getScheme(), uri.getHost(), path);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void addListener(ResolveChangeListener listener) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeListener(ResolveChangeListener listener) {
    }

    public void fire(ResolveChangeEvent event) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

