/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.util.HashMap;
import java.util.Map;
import org.geotools.feature.AttributeType;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;

public class AttributeTypeInfo {
    private String name;
    private int minOccurs;
    private int maxOccurs;
    private boolean nillable;
    private String typeName;
    private boolean isComplex;
    private AttributeType type;
    private Map meta;

    public AttributeTypeInfo(AttributeTypeInfoDTO dto) {
        this.type = null;
        this.meta = new HashMap();
        this.name = dto.getName();
        this.minOccurs = dto.getMinOccurs();
        this.maxOccurs = dto.getMaxOccurs();
        this.nillable = dto.isNillable();
        this.isComplex = dto.isComplex();
        this.typeName = dto.getType();
    }

    public AttributeTypeInfo(AttributeType type) {
        this.type = type;
        this.meta = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public AttributeType getAttributeType() {
        return this.type;
    }

    public void sync(AttributeType type) {
        this.type = type;
    }

    public String getAttributeName() {
        String r = this.typeName;
        if (r == null && this.type != null) {
            r = this.type.getName();
        }
        return r;
    }

    public String getType() {
        if (this.isComplex) {
            return "(xml fragment)";
        }
        return this.typeName;
    }

    public String getFragment() {
        if (this.isComplex) {
            return this.typeName;
        }
        return null;
    }

    public boolean containsMetaData(String key) {
        return this.meta.containsKey(key);
    }

    public void putMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    public Object getMetaData(String key) {
        return this.meta.get(key);
    }

    Object toDTO() {
        AttributeTypeInfoDTO dto = new AttributeTypeInfoDTO();
        dto.setComplex(this.isComplex);
        dto.setMaxOccurs(this.maxOccurs);
        dto.setMinOccurs(this.minOccurs);
        dto.setName(this.name);
        dto.setNillable(this.nillable);
        dto.setType(this.typeName);
        return dto;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public String toString() {
        return "[AttributeTypeInfo backed by " + this.toDTO() + " with type " + this.type + " and meta " + this.meta;
    }
}

