/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.awt.RenderingHints;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.geotools.factory.Hints;
import org.geotools.io.TableWriter;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.PropertyAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class FactoryUsingWKT
extends DeferredAuthorityFactory
implements CRSAuthorityFactory {
    public static final String SYSTEM_DEFAULT_USER_PROJ_FILE = "user.projections.file";
    public static final String FILENAME = "epsg.properties";
    private final FactoryGroup factories;
    static /* synthetic */ Class class$org$vfny$geoserver$crs$FactoryUsingWKT;
    static /* synthetic */ Class class$org$opengis$referencing$crs$CoordinateReferenceSystem;

    public FactoryUsingWKT() {
        this(null);
    }

    public FactoryUsingWKT(Hints hints) {
        this(hints, 90);
    }

    FactoryUsingWKT(Hints hints, int priority) {
        super(hints, priority);
        this.factories = FactoryGroup.createInstance((Hints)hints);
        this.setTimeout(900000L);
    }

    public Citation getAuthority() {
        return Citations.EPSG;
    }

    Citation[] getAuthorities() {
        return new Citation[]{this.getAuthority()};
    }

    protected URL getDefinitionsURL() {
        String cust_proj_file = System.getProperty(SYSTEM_DEFAULT_USER_PROJ_FILE);
        try {
            File proj_file;
            if (cust_proj_file == null) {
                cust_proj_file = new File(GeoserverDataDirectory.getGeoserverDataDirectory(), "user_projections/epsg.properties").getAbsolutePath();
            }
            if ((proj_file = new File(cust_proj_file)).exists()) {
                try {
                    return proj_file.toURL();
                }
                catch (MalformedURLException e) {
                    ReferencingFactory.LOGGER.log(Level.SEVERE, "Had troubles converting file name to URL", e);
                }
            }
        }
        catch (Exception e) {
            ReferencingFactory.LOGGER.log(Level.SEVERE, "An exception occurred while gathering the user projection files, falling back on the standard in-classpath one", e);
        }
        cust_proj_file = "user_epsg.properties";
        return (class$org$vfny$geoserver$crs$FactoryUsingWKT == null ? (class$org$vfny$geoserver$crs$FactoryUsingWKT = FactoryUsingWKT.class$("org.vfny.geoserver.crs.FactoryUsingWKT")) : class$org$vfny$geoserver$crs$FactoryUsingWKT).getResource(cust_proj_file);
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        try {
            URL url = this.getDefinitionsURL();
            if (url == null) {
                throw new FileNotFoundException(FILENAME);
            }
            Collection ids = this.getAuthority().getIdentifiers();
            String authority = ids.isEmpty() ? "EPSG" : (String)ids.iterator().next();
            ReferencingFactory.LOGGER.log(Logging.format((Level)Level.CONFIG, (int)27, (Object)url.getPath(), (Object)authority));
            return new PropertyAuthorityFactory(this.factories, this.getAuthority(), url);
        }
        catch (IOException exception) {
            throw new FactoryException(Errors.format((int)163, (Object)FILENAME), (Throwable)exception);
        }
    }

    private static final AbstractAuthorityFactory getFactory(Class type) {
        return (AbstractAuthorityFactory)FactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, (Object)type));
    }

    protected Set reportInstantiationFailures(PrintWriter out) throws FactoryException {
        Set codes = this.getAuthorityCodes(class$org$opengis$referencing$crs$CoordinateReferenceSystem == null ? (class$org$opengis$referencing$crs$CoordinateReferenceSystem = FactoryUsingWKT.class$("org.opengis.referencing.crs.CoordinateReferenceSystem")) : class$org$opengis$referencing$crs$CoordinateReferenceSystem);
        TreeMap<String, String> failures = new TreeMap<String, String>();
        Iterator it = codes.iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            try {
                this.createCoordinateReferenceSystem(code);
            }
            catch (FactoryException exception) {
                failures.put(code, exception.getLocalizedMessage());
            }
        }
        if (!failures.isEmpty()) {
            TableWriter writer = new TableWriter((Writer)out, " ");
            Iterator it2 = failures.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                writer.write((String)entry.getKey());
                writer.write(58);
                writer.nextColumn();
                writer.write((String)entry.getValue());
                writer.nextLine();
            }
            try {
                writer.flush();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return failures.keySet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

