/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.Filter;
import org.vfny.geoserver.config.AttributeTypeInfoConfig;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.CloneLibrary;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;

public class FeatureTypeConfig {
    protected static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.config");
    private String dataStoreId;
    private Envelope latLongBBox;
    private Envelope nativeBBox;
    private int SRS;
    private int SRSHandling;
    private List schemaAttributes;
    private String name;
    private String wmsPath;
    private String schemaName;
    private String schemaBase;
    private String dirName;
    private String title;
    private String _abstract;
    private Set keywords;
    private Set metadataLinks;
    private int numDecimals;
    private Filter definitionQuery = null;
    private String defaultStyle;
    private ArrayList styles;
    private String cacheMaxAge;
    private boolean cachingEnabled;

    FeatureTypeConfig() {
    }

    public FeatureTypeConfig(String dataStoreId, FeatureType schema, boolean generate) {
        if (dataStoreId == null || dataStoreId.length() == 0) {
            throw new IllegalArgumentException("dataStoreId is required for FeatureTypeConfig");
        }
        if (schema == null) {
            throw new IllegalArgumentException("FeatureType is required for FeatureTypeConfig");
        }
        this.dataStoreId = dataStoreId;
        this.latLongBBox = new Envelope();
        this.nativeBBox = new Envelope();
        this.SRS = this.lookupSRS(schema.getDefaultGeometry());
        if (generate) {
            this.schemaAttributes = new ArrayList();
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeType attrib = schema.getAttributeType(i);
                this.schemaAttributes.add(new AttributeTypeInfoConfig(attrib));
            }
        } else {
            this.schemaAttributes = null;
        }
        this.defaultStyle = "";
        this.styles = new ArrayList();
        this.name = schema.getTypeName();
        this.wmsPath = "/";
        this.title = schema.getTypeName() + "_Type";
        this._abstract = "Generated from " + dataStoreId;
        this.keywords = new HashSet();
        this.keywords.add(dataStoreId);
        this.keywords.add(this.name);
        this.metadataLinks = new HashSet();
        this.numDecimals = 8;
        this.definitionQuery = null;
        this.dirName = dataStoreId + "_" + this.name;
        this.schemaName = this.name + "_Type";
        this.schemaBase = "gml:AbstractFeatureType";
        this.cachingEnabled = false;
        this.cacheMaxAge = null;
    }

    public FeatureTypeConfig(FeatureTypeInfoDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Non null FeatureTypeInfoDTO required");
        }
        this.dataStoreId = dto.getDataStoreId();
        this.latLongBBox = new Envelope(dto.getLatLongBBox());
        this.nativeBBox = new Envelope(dto.getNativeBBox());
        this.SRS = dto.getSRS();
        this.SRSHandling = dto.getSRSHandling();
        if (dto.getSchemaAttributes() == null) {
            this.schemaAttributes = null;
        } else {
            this.schemaAttributes = new LinkedList();
            Iterator i = dto.getSchemaAttributes().iterator();
            while (i.hasNext()) {
                this.schemaAttributes.add(new AttributeTypeInfoConfig((AttributeTypeInfoDTO)i.next()));
            }
        }
        this.name = dto.getName();
        this.wmsPath = dto.getWmsPath();
        this.title = dto.getTitle();
        this._abstract = dto.getAbstract();
        this.numDecimals = dto.getNumDecimals();
        this.definitionQuery = dto.getDefinitionQuery();
        try {
            this.keywords = new HashSet(dto.getKeywords());
        }
        catch (Exception e) {
            this.keywords = new HashSet();
        }
        try {
            this.metadataLinks = new HashSet(dto.getMetadataLinks());
        }
        catch (Exception e) {
            this.metadataLinks = new HashSet();
        }
        this.defaultStyle = dto.getDefaultStyle();
        this.styles = dto.getStyles();
        this.dirName = dto.getDirName();
        this.schemaName = dto.getSchemaName();
        this.schemaBase = dto.getSchemaBase();
        this.cachingEnabled = dto.isCachingEnabled();
        this.cacheMaxAge = dto.getCacheMaxAge();
    }

    private int lookupSRS(GeometryAttributeType defaultGeometry) {
        if (defaultGeometry == null) {
            return -1;
        }
        GeometryFactory geometryFactory = defaultGeometry.getGeometryFactory();
        if (geometryFactory != null && geometryFactory.getSRID() != 0) {
            return geometryFactory.getSRID();
        }
        return 0;
    }

    public FeatureTypeInfoDTO toDTO() {
        FeatureTypeInfoDTO f = new FeatureTypeInfoDTO();
        f.setDataStoreId(this.dataStoreId);
        f.setLatLongBBox(CloneLibrary.clone(this.latLongBBox));
        f.setNativeBBox(CloneLibrary.clone(this.nativeBBox));
        f.setSRS(this.SRS);
        f.setSRSHandling(this.SRSHandling);
        if (this.schemaAttributes == null) {
            f.setSchemaAttributes(null);
        } else {
            ArrayList<AttributeTypeInfoDTO> s = new ArrayList<AttributeTypeInfoDTO>();
            for (int i = 0; i < this.schemaAttributes.size(); ++i) {
                s.add(((AttributeTypeInfoConfig)this.schemaAttributes.get(i)).toDTO());
            }
            f.setSchemaAttributes(s);
        }
        f.setName(this.name);
        f.setWmsPath(this.wmsPath);
        f.setTitle(this.title);
        f.setAbstract(this._abstract);
        f.setNumDecimals(this.numDecimals);
        f.setDefinitionQuery(this.definitionQuery);
        try {
            f.setKeywords(new ArrayList(this.keywords));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            f.setMetadataLinks(new ArrayList(this.metadataLinks));
        }
        catch (Exception exception) {
            // empty catch block
        }
        f.setDefaultStyle(this.defaultStyle);
        f.setStyles(this.styles);
        f.setDirName(this.dirName);
        f.setSchemaBase(this.schemaBase);
        f.setSchemaName(this.schemaName);
        f.setCachingEnabled(this.cachingEnabled);
        f.setCacheMaxAge(this.cacheMaxAge);
        return f;
    }

    public AttributeTypeInfoConfig getAttributeFromSchema(String attributeTypeName) {
        Iterator iter = this.schemaAttributes.iterator();
        while (iter.hasNext()) {
            AttributeTypeInfoConfig atiConfig = (AttributeTypeInfoConfig)iter.next();
            if (!atiConfig.getName().equals(attributeTypeName)) continue;
            return atiConfig;
        }
        return null;
    }

    public String getKey() {
        return this.getDataStoreId() + ":::" + this.getName();
    }

    public String getAbstract() {
        return this._abstract;
    }

    public void setAbstract(String _abstract) {
        this._abstract = _abstract;
    }

    public String getDataStoreId() {
        return this.dataStoreId;
    }

    public void setDataStoreId(String dataStoreId) {
        this.dataStoreId = dataStoreId;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(String defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public ArrayList getStyles() {
        return this.styles;
    }

    public void setStyles(ArrayList styles) {
        this.styles = styles;
    }

    public void addStyle(String style) {
        if (!this.styles.contains(style)) {
            this.styles.add(style);
        }
    }

    public Filter getDefinitionQuery() {
        return this.definitionQuery;
    }

    public void setDefinitionQuery(Filter definitionQuery) {
        this.definitionQuery = definitionQuery;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Set getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set keywords) {
        this.keywords = keywords;
    }

    public Set getMetadataLinks() {
        return this.metadataLinks;
    }

    public void setMetadataLinks(Set metadataURLs) {
        this.metadataLinks = metadataURLs;
    }

    public Envelope getLatLongBBox() {
        return this.latLongBBox;
    }

    public void setLatLongBBox(Envelope latLongBBox) {
        this.latLongBBox = latLongBBox;
    }

    public Envelope getNativeBBox() {
        return this.nativeBBox;
    }

    public void setNativeBBox(Envelope nativeBBox) {
        this.nativeBBox = nativeBBox;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public void setNumDecimals(int numDecimals) {
        this.numDecimals = numDecimals;
    }

    public List getSchemaAttributes() {
        return this.schemaAttributes;
    }

    public void setSchemaAttributes(List schemaAttributes) {
        this.schemaAttributes = schemaAttributes;
    }

    public String getSchemaBase() {
        return this.schemaBase;
    }

    public void setSchemaBase(String schemaBase) {
        this.schemaBase = schemaBase;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public int getSRS() {
        return this.SRS;
    }

    public void setSRS(int srs) {
        this.SRS = srs;
    }

    public int getSRSHandling() {
        return this.SRSHandling;
    }

    public void setSRSHandling(int srsHandling) {
        this.SRSHandling = srsHandling;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return "FeatureTypeConfig[name: " + this.name + " schemaName: " + this.schemaName + " SRS: " + this.SRS + " schemaAttributes: " + this.schemaAttributes + " schemaBase " + this.schemaBase + "]";
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public String getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public void setCacheMaxAge(String cacheMaxAge) {
        this.cacheMaxAge = cacheMaxAge;
    }
}

