/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.UserContainer;

public final class Requests {
    public static final String PROXY_PARAM = "PROXY_BASE_URL";

    public static String getBaseUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        String url;
        String string = url = geoserver != null ? geoserver.getProxyBaseUrl() : null;
        if (geoserver != null && url != null) {
            url = Requests.concatUrl(url, httpServletRequest.getContextPath());
        }
        if (url == null || url.trim().length() == 0) {
            if (httpServletRequest != null) {
                url = httpServletRequest.getSession().getServletContext().getInitParameter(PROXY_PARAM);
            }
            url = url == null || url.trim().length() == 0 ? httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getContextPath() + "/" : Requests.concatUrl(url, httpServletRequest.getContextPath());
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public static String getBaseJspUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        String url = geoserver.getProxyBaseUrl();
        if (geoserver != null && url != null) {
            url = Requests.concatUrl(url, httpServletRequest.getRequestURI());
        }
        if (url == null || url.trim().length() == 0) {
            if (httpServletRequest != null) {
                url = httpServletRequest.getSession().getServletContext().getInitParameter(PROXY_PARAM);
            }
            url = url == null || url.trim().length() == 0 ? httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getRequestURI() + "/" : Requests.concatUrl(url, httpServletRequest.getRequestURI());
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getTileCacheBaseUrl(HttpServletRequest request, GeoServer geoServer) {
        String tileCacheBaseUrl = geoServer.getTileCache();
        if (tileCacheBaseUrl != null) {
            try {
                new URL(tileCacheBaseUrl);
                return tileCacheBaseUrl;
            }
            catch (MalformedURLException e1) {
                try {
                    String url = Requests.concatUrl(request.getScheme() + "://" + request.getServerName(), tileCacheBaseUrl);
                    new URL(url);
                    return url;
                }
                catch (MalformedURLException e2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String concatUrl(String url, String contextPath) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return url + "/" + contextPath;
    }

    public static String getSchemaBaseUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        return Requests.getBaseUrl(httpServletRequest, geoserver) + "schemas/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserContainer getUserContainer(HttpServletRequest request) {
        HttpSession session;
        HttpSession httpSession = session = request.getSession();
        synchronized (httpSession) {
            UserContainer user = (UserContainer)session.getAttribute("GEOSERVER.USER");
            return user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoggedIn(HttpServletRequest request) {
        HttpSession session;
        HttpSession httpSession = session = request.getSession();
        synchronized (httpSession) {
            UserContainer user = (UserContainer)session.getAttribute("GEOSERVER.USER");
            return user != null;
        }
    }

    public static void logOut(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.removeAttribute("GEOSERVER.USER");
    }

    public static Map parseOptionParameter(String rawOptionString) throws IllegalArgumentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (rawOptionString == null) {
            return map;
        }
        StringTokenizer semiColonSplitter = new StringTokenizer(rawOptionString, ";");
        while (semiColonSplitter.hasMoreElements()) {
            String curKVP = semiColonSplitter.nextToken();
            int cloc = curKVP.indexOf(":");
            if (cloc <= 0) {
                throw new IllegalArgumentException("Key-value-pair: '" + curKVP + "' isn't properly formed.  It must be of the form 'Key:Value1,Value2...'");
            }
            String key = curKVP.substring(0, cloc);
            String values = curKVP.substring(cloc + 1, curKVP.length());
            if (values.indexOf(",") != -1) {
                ArrayList<String> valueList = new ArrayList<String>();
                StringTokenizer commaSplitter = new StringTokenizer(values, ",");
                while (commaSplitter.hasMoreElements()) {
                    valueList.add(commaSplitter.nextToken());
                }
                map.put(key, valueList);
                continue;
            }
            map.put(key, values);
        }
        return map;
    }

    public static String appendContextPath(String url, String contextPath) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return url + "/" + contextPath;
    }

    public static String appendQueryString(String url, String queryString) {
        if (url.endsWith("?") || url.endsWith("&")) {
            return url + queryString;
        }
        if (url.indexOf(63) != -1) {
            return url + "&" + queryString;
        }
        return url + "?" + queryString;
    }
}

