/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.sun.media.jai.util.SunTileCache;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RecyclingTileFactory;
import javax.servlet.ServletContext;
import org.geotools.data.jdbc.ConnectionPoolManager;
import org.springframework.beans.factory.DisposableBean;
import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.Log4JFormatter;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;

public class GeoServer
extends GlobalLayerSupertype
implements DisposableBean {
    public static final String WEB_CONTAINER_KEY = "GeoServer";
    private String title;
    private int maxFeatures = Integer.MAX_VALUE;
    private boolean verbose = true;
    private int numDecimals = 4;
    private Charset charSet = Charset.forName("UTF-8");
    private final JAI jaiDef = JAI.getDefaultInstance();
    private SunTileCache jaiCache;
    private String adminUserName = "admin";
    private String adminPassword;
    private String schemaBaseUrl;
    private String proxyBaseUrl;
    private String contactPerson;
    private String contactOrganization;
    private String contactPosition;
    private String addressType;
    private String address;
    private String addressCity;
    private String addressState;
    private String addressPostalCode;
    private String addressCountry;
    private String contactVoice;
    private String contactFacsimile;
    private String contactEmail;
    private String onlineResource;
    private double memoryCapacity;
    private double memoryThreshold;
    private int tileThreads;
    private int tilePriority;
    private String tileCache;
    private Boolean recycling;
    private Boolean imageIOCache;
    private Boolean JPEGnativeAcc;
    private Boolean PNGnativeAcc;
    private boolean verboseExceptions = false;
    private Level loggingLevel = Logger.getLogger("org.vfny.geoserver").getLevel();
    private boolean logToFile = false;
    private boolean loggingToFile = false;
    private String logLocation = null;

    public GeoServer() {
    }

    public GeoServer(Config config) throws ConfigurationException {
        GlobalLayerSupertype.LOGGER.fine("Creating GeoServer");
        this.load(config.getXMLReader().getGeoServer());
    }

    public String getAddress() {
        return this.notNull(this.address);
    }

    public String getAddressCity() {
        return this.notNull(this.addressCity);
    }

    public String getAddressCountry() {
        return this.notNull(this.addressCountry);
    }

    public String getAddressPostalCode() {
        return this.notNull(this.addressPostalCode);
    }

    public String getAddressState() {
        return this.notNull(this.addressState);
    }

    public String getAddressType() {
        return this.notNull(this.addressType);
    }

    public Charset getCharSet() {
        if (this.charSet != null) {
            return this.charSet;
        }
        return Charset.forName("UTF-8");
    }

    public String getContactEmail() {
        return this.notNull(this.contactEmail);
    }

    public String getContactFacsimile() {
        return this.notNull(this.contactFacsimile);
    }

    public String getContactOrganization() {
        return this.notNull(this.contactOrganization);
    }

    public String getContactPerson() {
        return this.notNull(this.contactPerson);
    }

    public String getContactPosition() {
        return this.notNull(this.contactPosition);
    }

    public String getContactVoice() {
        return this.notNull(this.contactVoice);
    }

    public String getOnlineResource() {
        return this.notNull(this.onlineResource);
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public String getMimeType() {
        return "text/xml; charset=" + this.getCharSet().name();
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public String getSchemaBaseUrl() {
        return this.schemaBaseUrl;
    }

    public String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void load(GeoServerDTO dto) throws ConfigurationException {
        if (dto != null) {
            this.address = dto.getContact().getAddress();
            this.addressCity = dto.getContact().getAddressCity();
            this.addressCountry = dto.getContact().getAddressCountry();
            this.addressPostalCode = dto.getContact().getAddressPostalCode();
            this.addressState = dto.getContact().getAddressState();
            this.addressType = dto.getContact().getAddressType();
            this.charSet = dto.getCharSet();
            this.contactEmail = dto.getContact().getContactEmail();
            this.contactFacsimile = dto.getContact().getContactFacsimile();
            this.contactOrganization = dto.getContact().getContactOrganization();
            this.contactPerson = dto.getContact().getContactPerson();
            this.contactPosition = dto.getContact().getContactPosition();
            this.contactVoice = dto.getContact().getContactVoice();
            this.loggingLevel = dto.getLoggingLevel();
            this.loggingToFile = dto.getLoggingToFile();
            this.logLocation = dto.getLogLocation();
            try {
                GeoServer.initLogging(this.loggingLevel, this.loggingToFile, this.logLocation);
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
        } else {
            throw new ConfigurationException("load(GeoServerDTO) expected a non-null value");
        }
        this.memoryCapacity = dto.getJaiMemoryCapacity();
        this.memoryThreshold = dto.getJaiMemoryThreshold();
        this.tileThreads = dto.getJaiTileThreads();
        this.tilePriority = dto.getJaiTilePriority();
        this.recycling = dto.getJaiRecycling();
        this.imageIOCache = dto.getImageIOCache();
        this.JPEGnativeAcc = dto.getJaiJPEGNative();
        this.PNGnativeAcc = dto.getJaiPNGNative();
        this.initJAI(this.memoryCapacity, this.memoryThreshold, this.recycling, this.imageIOCache);
        this.maxFeatures = dto.getMaxFeatures();
        this.numDecimals = dto.getNumDecimals();
        this.onlineResource = dto.getContact().getOnlineResource();
        this.schemaBaseUrl = dto.getSchemaBaseUrl();
        this.proxyBaseUrl = dto.getProxyBaseUrl();
        this.verbose = dto.isVerbose();
        this.adminUserName = dto.getAdminUserName();
        this.adminPassword = dto.getAdminPassword();
        this.verboseExceptions = dto.isVerboseExceptions();
        this.tileCache = dto.getTileCache();
    }

    public final void load(GeoServerDTO dto, ServletContext context) throws ConfigurationException {
        this.load(dto);
    }

    public static File getLogLocation(String logLocation) throws IOException {
        File f = new File(logLocation);
        if (f.exists()) {
            if (f.isDirectory()) {
                if (!logLocation.endsWith(File.separator)) {
                    logLocation = logLocation + File.separator;
                }
                logLocation = logLocation + "geoserver.log";
            }
        } else {
            if (!f.isAbsolute()) {
                File data = GeoserverDataDirectory.getGeoserverDataDirectory();
                f = new File(data, f.getPath());
            }
            if (f.getParentFile() != null && !f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
        }
        return f;
    }

    public static void initLogging(Level level, boolean logToFile, String location) throws IOException {
        Level gtLevel = level == Level.ALL ? Level.ALL : (level == Level.OFF ? Level.OFF : (level == Level.SEVERE ? Level.SEVERE : (level == Level.WARNING ? Level.SEVERE : (level == Level.INFO ? Level.WARNING : (level == Level.CONFIG ? Level.INFO : (level == Level.FINE ? Level.CONFIG : (level == Level.FINER ? Level.FINE : (level == Level.FINEST ? Level.FINER : Level.FINEST))))))));
        Log4JFormatter.init("org.geotools", gtLevel);
        Log4JFormatter.init("org.vfny.geoserver", level);
        Logger logger = Logger.getLogger("org.vfny.geoserver");
        if (logToFile && location != null) {
            File logFile = GeoServer.getLogLocation(location);
            StreamHandler handler = new StreamHandler(new BufferedOutputStream(new FileOutputStream(logFile, true)), new SimpleFormatter());
            handler.setLevel(level);
            logger.addHandler(handler);
            if (Logger.getLogger("org.geotools") != null) {
                Logger.getLogger("org.geotools").addHandler(handler);
            }
        }
    }

    public void initJAI(double memCapacity, double memoryThreshold, Boolean recycling, Boolean ImageIOCache) {
        this.jaiDef.setRenderingHint(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)recycling);
        RecyclingTileFactory recyclingFactory = new RecyclingTileFactory();
        this.jaiDef.setRenderingHint(JAI.KEY_TILE_FACTORY, (Object)recyclingFactory);
        this.jaiDef.setRenderingHint(JAI.KEY_TILE_RECYCLER, (Object)recyclingFactory);
        this.jaiCache = (SunTileCache)this.jaiDef.getTileCache();
        long jaiMemory = (long)(memCapacity * (double)Runtime.getRuntime().maxMemory());
        this.jaiCache.setMemoryCapacity(jaiMemory);
        this.jaiCache.setMemoryThreshold((float)memoryThreshold);
        this.jaiDef.getTileScheduler().setParallelism(this.tileThreads);
        this.jaiDef.getTileScheduler().setPrefetchParallelism(this.tileThreads);
        this.jaiDef.getTileScheduler().setPriority(this.tilePriority);
        this.jaiDef.getTileScheduler().setPrefetchPriority(this.tilePriority);
        ImageIO.setUseCache(ImageIOCache);
    }

    public Object toDTO() {
        GeoServerDTO dto = new GeoServerDTO();
        dto.setCharSet(this.charSet);
        dto.setLoggingLevel(this.loggingLevel);
        dto.setMaxFeatures(this.maxFeatures);
        dto.setNumDecimals(this.numDecimals);
        dto.setSchemaBaseUrl(this.schemaBaseUrl);
        dto.setProxyBaseUrl(this.proxyBaseUrl);
        dto.setVerbose(this.verbose);
        dto.setAdminUserName(this.adminUserName);
        dto.setAdminPassword(this.adminPassword);
        dto.setVerboseExceptions(this.verboseExceptions);
        dto.setLoggingToFile(this.loggingToFile);
        dto.setLogLocation(this.logLocation);
        dto.setJaiMemoryCapacity(this.memoryCapacity);
        dto.setJaiMemoryThreshold(this.memoryThreshold);
        dto.setJaiTileThreads(this.tileThreads);
        dto.setJaiTilePriority(this.tilePriority);
        dto.setJaiRecycling(this.recycling);
        dto.setImageIOCache(this.imageIOCache);
        dto.setJaiJPEGNative(this.JPEGnativeAcc);
        dto.setJaiPNGNative(this.PNGnativeAcc);
        dto.setTileCache(this.tileCache);
        ContactDTO cdto = new ContactDTO();
        dto.setContact(cdto);
        cdto.setAddress(this.address);
        cdto.setAddressCity(this.addressCity);
        cdto.setAddressCountry(this.addressCountry);
        cdto.setAddressPostalCode(this.addressPostalCode);
        cdto.setAddressState(this.addressState);
        cdto.setAddressType(this.addressType);
        cdto.setContactEmail(this.contactEmail);
        cdto.setContactFacsimile(this.contactFacsimile);
        cdto.setContactOrganization(this.contactOrganization);
        cdto.setContactPerson(this.contactPerson);
        cdto.setContactPosition(this.contactPosition);
        cdto.setContactVoice(this.contactVoice);
        cdto.setOnlineResource(this.onlineResource);
        return dto;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContactParty() {
        if (this.getContactPerson() != null && this.getContactPerson().length() != 0) {
            return this.getContactPerson();
        }
        if (this.getContactPosition() != null && this.getContactPosition().length() != 0) {
            return this.getContactPosition();
        }
        if (this.getContactOrganization() != null && this.getContactOrganization().length() != 0) {
            return this.getContactOrganization();
        }
        return null;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String toString() {
        StringBuffer geoserver = new StringBuffer("[GeoServer: \n");
        geoserver.append("   maxFeatures - " + this.maxFeatures);
        geoserver.append("\n   verbose - " + this.verbose);
        geoserver.append("\n   numDecimals - " + this.numDecimals);
        geoserver.append("\n   charSet - " + this.charSet);
        geoserver.append("\n   loggingLevel - " + this.loggingLevel);
        geoserver.append("\n   adminUserName - " + this.adminUserName);
        geoserver.append("\n   adminPassword - " + this.adminPassword);
        return geoserver.toString();
    }

    public boolean isVerboseExceptions() {
        return this.verboseExceptions;
    }

    public void setVerboseExceptions(boolean showStackTraces) {
        this.verboseExceptions = showStackTraces;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    public boolean getLoggingToFile() {
        return this.loggingToFile;
    }

    public void setLoggingToFile(boolean loggingToFile) {
        this.loggingToFile = loggingToFile;
    }

    public JAI getJAIDefault() {
        return this.jaiDef;
    }

    public SunTileCache getJaiCache() {
        return this.jaiCache;
    }

    public double getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public Boolean getRecycling() {
        return this.recycling;
    }

    public Boolean getJPEGNativeAcceleration() {
        return this.JPEGnativeAcc;
    }

    public Boolean getPNGNativeAcceleration() {
        return this.PNGnativeAcc;
    }

    public double getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public Boolean getImageIOCache() {
        return this.imageIOCache;
    }

    public int getTilePriority() {
        return this.tilePriority;
    }

    public int getTileThreads() {
        return this.tileThreads;
    }

    public String getTileCache() {
        return this.tileCache;
    }

    public void setTileCache(String tileCache) {
        this.tileCache = tileCache;
    }

    public void destroy() throws Exception {
        ConnectionPoolManager.getInstance().closeAll();
        try {
            Class<?> sdepfClass = Class.forName("org.geotools.arcsde.pool.ArcSDEConnectionPoolFactory");
            GlobalLayerSupertype.LOGGER.fine("SDE datasource found, releasing resources");
            Method m = sdepfClass.getMethod("getInstance", new Class[0]);
            Object pfInstance = m.invoke(sdepfClass, new Object[0]);
            GlobalLayerSupertype.LOGGER.fine("got sde connection pool factory instance: " + pfInstance);
            Method closeMethod = pfInstance.getClass().getMethod("closeAll", new Class[0]);
            closeMethod.invoke(pfInstance, new Object[0]);
            GlobalLayerSupertype.LOGGER.info("just asked SDE datasource to release connections");
        }
        catch (ClassNotFoundException cnfe) {
            GlobalLayerSupertype.LOGGER.fine("No SDE datasource found");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

