/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.xml.XMLConfigReader;

public class Config
implements ApplicationContextAware {
    protected static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");
    WebApplicationContext context;
    XMLConfigReader reader;

    public XMLConfigReader getXMLReader() throws ConfigurationException {
        return this.reader;
    }

    public File dataDirectory() {
        ServletContext sc = this.context.getServletContext();
        return GeoserverDataDirectory.getGeoserverDataDirectory();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = (WebApplicationContext)context;
        if (System.getProperty("org.geotools.referencing.forceXY") == null) {
            System.setProperty("org.geotools.referencing.forceXY", "true");
        }
        System.setProperty("java.util.prefs.syncInterval", "5000000");
        if (System.getProperty("java.version").startsWith("1.4") && System.getProperty("com.sun.media.imageio.disableCodecLib") == null) {
            LOGGER.warning("Disabling mediaLib acceleration since this is a java 1.4 VM.\nIf you want to force its enabling, set -Dcom.sun.media.imageio.disableCodecLib=true in your virtual machine");
            System.setProperty("com.sun.media.imageio.disableCodecLib", "true");
        }
        ServletContext sc = this.context.getServletContext();
        try {
            GeoserverDataDirectory.init((WebApplicationContext)context);
            this.reader = new XMLConfigReader(this.dataDirectory(), sc);
        }
        catch (ConfigurationException e) {
            String msg = "Error creating xml config reader";
            throw new BeanInitializationException(msg, (Throwable)e);
        }
    }

    public WebApplicationContext getApplictionContext() {
        return this.context;
    }
}

