/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util.requests.readers;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.servlets.AbstractService;

public abstract class KvpRequestReader {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers");
    private static final String KEYWORD_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    protected static final String OUTER_DELIMETER = "()";
    protected static final String INNER_DELIMETER = ",";
    protected static FilterFactory factory = FilterFactoryFinder.createFilterFactory();
    protected Map kvpPairs = new HashMap();
    protected AbstractService service;

    public KvpRequestReader(Map kvpPairs, AbstractService service) {
        this.kvpPairs = kvpPairs;
        this.service = service;
    }

    protected String getValue(String key) {
        return (String)this.kvpPairs.get(key);
    }

    protected boolean keyExists(String key) {
        return this.kvpPairs.containsKey(key);
    }

    public abstract Request getRequest(HttpServletRequest var1) throws ServiceException;

    protected static List getTypesFromFids(String rawFidList) {
        ArrayList<String> typeList = new ArrayList<String>();
        List unparsed = KvpRequestReader.readNested(rawFidList);
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            List ids = (List)i.next();
            ListIterator innerIterator = ids.listIterator();
            while (innerIterator.hasNext()) {
                String fid = innerIterator.next().toString();
                LOGGER.finer("looking at featureId" + fid);
                int pos = fid.indexOf(".");
                String typeName = fid.substring(0, fid.lastIndexOf("."));
                LOGGER.finer("adding typename: " + typeName + " from fid");
                typeList.add(typeName);
            }
        }
        return typeList;
    }

    protected static List readFlat(String rawList, String delimiter) {
        if (rawList == null) {
            return Collections.EMPTY_LIST;
        }
        if (rawList.equals("*")) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> kvpList = null;
        if (delimiter.length() == 1) {
            int index = -1;
            kvpList = new ArrayList<String>();
            rawList = rawList + delimiter;
            while ((index = rawList.indexOf(delimiter)) > -1) {
                String token = rawList.substring(0, index);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("adding simple element " + token);
                }
                kvpList.add(token);
                rawList = rawList.substring(++index);
            }
        } else {
            StringTokenizer kvps = new StringTokenizer(rawList, delimiter);
            kvpList = new ArrayList(kvps.countTokens());
            while (kvps.hasMoreTokens()) {
                LOGGER.finest("adding simple element");
                kvpList.add(kvps.nextToken());
            }
        }
        return kvpList;
    }

    protected static List readNested(String rawList) {
        LOGGER.finest("reading nested: " + rawList);
        ArrayList<List> kvpList = new ArrayList<List>();
        if (rawList == null) {
            LOGGER.finest("found implicit all requested");
            return kvpList;
        }
        if (rawList.equals("*")) {
            LOGGER.finest("found explicit all requested");
            return kvpList;
        }
        LOGGER.finest("found explicit requested");
        if (rawList.startsWith("(")) {
            LOGGER.finest("reading complex list");
            List outerList = KvpRequestReader.readFlat(rawList, OUTER_DELIMETER);
            ListIterator i = outerList.listIterator();
            while (i.hasNext()) {
                kvpList.add(KvpRequestReader.readFlat((String)i.next(), INNER_DELIMETER));
            }
        } else {
            LOGGER.finest("reading simple list");
            kvpList.add(KvpRequestReader.readFlat(rawList, INNER_DELIMETER));
        }
        return kvpList;
    }

    public static Map parseKvpSet(String qString) {
        String cleanRequest = KvpRequestReader.clean(qString);
        LOGGER.fine("clean request is " + cleanRequest);
        HashMap<String, String> kvps = new HashMap<String, String>();
        StringTokenizer requestKeywords = new StringTokenizer(cleanRequest.trim(), KEYWORD_DELIMITER);
        while (requestKeywords.hasMoreTokens()) {
            String kvpPair = requestKeywords.nextToken();
            if (kvpPair.toUpperCase().startsWith("FILTER")) {
                String filterVal = kvpPair.substring(7);
                LOGGER.finest("putting filter value " + filterVal);
                kvps.put("FILTER", filterVal);
                continue;
            }
            StringTokenizer requestValues = new StringTokenizer(kvpPair, VALUE_DELIMITER);
            if (!requestValues.hasMoreTokens()) continue;
            String key = requestValues.nextToken().toUpperCase();
            if (!requestValues.hasMoreTokens()) continue;
            String value = requestValues.nextToken();
            LOGGER.finest("putting kvp pair: " + key + ": " + value);
            kvps.put(key, value);
        }
        LOGGER.fine("returning parsed " + kvps);
        return kvps;
    }

    private static String clean(String raw) {
        LOGGER.finest("raw request: " + raw);
        String clean = null;
        if (raw != null) {
            try {
                clean = URLDecoder.decode(raw, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.finer("Bad encoding for decoder " + e);
            }
        } else {
            return "";
        }
        LOGGER.finest("cleaned request: " + raw);
        return clean;
    }

    public AbstractService getServiceRef() {
        return this.service;
    }

    public void setServiceRef(AbstractService service) {
        this.service = service;
    }
}

