/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public abstract class DataStoreUtils {
    public static DataStore acquireDataStore(Map params, ServletContext sc) throws IOException {
        File baseDir = GeoserverDataDirectory.getGeoserverDataDirectory(sc);
        DataStore store = DataStoreFinder.getDataStore((Map)DataStoreUtils.getParams(params, baseDir.getAbsolutePath()));
        if (store == null) {
            return null;
        }
        return store;
    }

    public static Map getParams(Map m, ServletContext sc) {
        String baseDir = sc.getRealPath("/");
        return DataStoreUtils.getParams(m, baseDir);
    }

    protected static Map getParams(Map m, String baseDir) {
        return DataStoreInfo.getParams(m, baseDir);
    }

    public static DataStoreFactorySpi aquireFactory(Map params) {
        Iterator i = DataStoreFinder.getAvailableDataStores();
        while (i.hasNext()) {
            DataStoreFactorySpi factory = (DataStoreFactorySpi)i.next();
            if (!factory.canProcess(params)) continue;
            return factory;
        }
        return null;
    }

    public static DataStoreFactorySpi aquireFactory(String displayName) {
        Iterator i = DataStoreFinder.getAvailableDataStores();
        while (i.hasNext()) {
            DataStoreFactorySpi factory = (DataStoreFactorySpi)i.next();
            if (factory.getDisplayName().equals(displayName)) {
                return factory;
            }
            if (!factory.getClass().toString().equals(displayName)) continue;
            return factory;
        }
        return null;
    }

    public static DataStoreFactorySpi.Param find(DataStoreFactorySpi factory, String key) {
        return DataStoreUtils.find(factory.getParametersInfo(), key);
    }

    public static DataStoreFactorySpi.Param find(DataStoreFactorySpi.Param[] params, String key) {
        for (int i = 0; i < params.length; ++i) {
            if (!key.equalsIgnoreCase(params[i].key)) continue;
            return params[i];
        }
        return null;
    }

    public static List listDataStoresDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = DataStoreFinder.getAvailableDataStores();
        while (i.hasNext()) {
            DataStoreFactorySpi factory = (DataStoreFactorySpi)i.next();
            list.add(factory.getDisplayName());
        }
        return list;
    }

    public static Map defaultParams(String description) {
        return DataStoreUtils.defaultParams(DataStoreUtils.aquireFactory(description));
    }

    public static Map defaultParams(DataStoreFactorySpi factory) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        DataStoreFactorySpi.Param[] params = factory.getParametersInfo();
        for (int i = 0; i < params.length; ++i) {
            DataStoreFactorySpi.Param param = params[i];
            String key = param.key;
            String value = null;
            if (param.sample != null) {
                value = param.text(param.sample);
            }
            if (value == null) {
                value = "";
            }
            if (value == null) continue;
            defaults.put(key, value);
        }
        return defaults;
    }

    public static Map toConnectionParams(DataStoreFactorySpi factory, Map params) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        DataStoreFactorySpi.Param[] info = factory.getParametersInfo();
        Iterator i = params.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = DataStoreUtils.find(info, key).lookUp(params);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Envelope getBoundingBoxEnvelope(FeatureSource fs) throws IOException {
        Envelope ev = fs.getBounds();
        if (ev == null || ev.isNull()) {
            try {
                ev = fs.getFeatures().getBounds();
            }
            catch (Throwable t) {
                ev = new Envelope();
            }
        }
        return ev;
    }
}

