/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.Requests;

public class JSPCompiler
extends HttpServlet {
    String[] pages;
    int spot = 0;

    public void init(ServletConfig config) throws ServletException {
        ResourceBundle rb = ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName());
        int n = Integer.parseInt(rb.getString("numURLs"));
        this.pages = new String[n];
        for (int i = 0; i < n; ++i) {
            this.pages[i] = rb.getString("url." + (i + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.spot < this.pages.length) {
            try {
                ServletContext session;
                String base = Requests.getBaseUrl(request);
                ServletContext servletContext = session = request.getSession().getServletContext();
                synchronized (servletContext) {
                    UserContainer u2 = new UserContainer();
                    u2.setUsername("compiler");
                    session.setAttribute("GEOSERVER.USER", (Object)u2);
                }
                this.doLoad(base + this.pages[this.spot], response);
                servletContext = session;
                synchronized (servletContext) {
                    session.setAttribute("GEOSERVER.USER", null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++this.spot;
        } else {
            this.doForward(response);
        }
    }

    private void doForward(HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        ServletOutputStream os = response.getOutputStream();
        os.print("<html>\n");
        os.print("<head><title>GeoServer - Loading</title>\n");
        os.print("  <meta content=\"text/css\" http-equiv=\"content-style-type\">\n");
        os.print("  <style type=\"text/css\">\n");
        os.print("    <!-- @import url(\"/geoserver/style.css\"); -->\n");
        os.print("  </style>\n");
        os.print("  <link type=\"image/gif\" href=\"gs.gif\" rel=\"icon\"><!-- mozilla --> \n");
        os.print("  <link href=\"gs.ico\" rel=\"SHORTCUT ICON\"><!-- ie -->\n");
        os.print("</head>\n");
        os.print("<body onload=\"javascript:window.location.replace('welcome.do')\"><br><center>\n");
        os.print("<table width=\"60%\" height=\"60%\"><tr><td>\n");
        os.print("<center>\n");
        os.print("  <span class=\"project\">\n");
        os.print("    <a href=\"http://geoserver.sourceforge.net/\">GeoServer</a>\n");
        os.print("  </span>\n");
        os.print("  <span class=\"license\">\n");
        os.print("    <a href=\"http://geoserver.sourceforge.net/documentation/developer/license.htm\">&copy;</a>\n");
        os.print("  </span>\n");
        os.print("  <h1>LOADING ...</h1>\n");
        os.print("<center><br>\n");
        os.print("<center><h2>Please Wait</h2><center>\n");
        os.print("</table></td></tr>\n");
        os.print("</center></body>\n");
        os.print("</html>");
    }

    private void doLoad(String url, HttpServletResponse response) throws ServletException, IOException {
        URL u = new URL(url);
        try {
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            con.connect();
            String s = con.getResponseMessage();
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while (br.ready()) {
                br.readLine();
            }
            con.disconnect();
        }
        catch (Exception e) {
            System.err.println("ERROR compiling " + url);
        }
        response.setContentType("text/html");
        ServletOutputStream os = response.getOutputStream();
        os.print("<html>\n");
        os.print("<head><title>GeoServer - Loading</title>\n");
        os.print("  <meta content=\"text/css\" http-equiv=\"content-style-type\">\n");
        os.print("  <style type=\"text/css\">\n");
        os.print("    <!-- @import url(\"/geoserver/style.css\"); -->\n");
        os.print("  </style>\n");
        os.print("  <link type=\"image/gif\" href=\"gs.gif\" rel=\"icon\"><!-- mozilla --> \n");
        os.print("  <link href=\"gs.ico\" rel=\"SHORTCUT ICON\"><!-- ie -->\n");
        os.print("</head>\n");
        os.print("<body onload=\"javascript:window.location.replace('JSPCompiler')\"><br><center>\n");
        os.print("<table width=\"60%\" height=\"60%\"><tr><td>\n");
        os.print("<center>\n");
        os.print("  <span class=\"project\">\n");
        os.print("    <a href=\"http://geoserver.sourceforge.net/\">GeoServer</a>\n");
        os.print("  </span>\n");
        os.print("  <span class=\"license\">\n");
        os.print("    <a href=\"http://geoserver.sourceforge.net/documentation/developer/license.htm\">&copy;</a>\n");
        os.print("  </span>\n");
        os.print("  <h1>LOADING ...</h1>\n");
        os.print("<center><br>\n");
        os.print("<center><h2>Please Wait</h2><center>\n");
        os.print("<center><h2>" + (int)(100.0 * ((double)this.spot * 1.0) / ((double)this.pages.length * 1.0)) + "% Completed</h2><center>\n");
        os.print("</table></td></tr>\n");
        os.print("</center></body>\n");
        os.print("</html>");
    }
}

