/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterDOMParser;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.LegendURLDTO;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.StyleDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;
import org.vfny.geoserver.global.xml.NameSpaceElement;
import org.vfny.geoserver.global.xml.NameSpaceTranslator;
import org.vfny.geoserver.global.xml.NameSpaceTranslatorFactory;
import org.vfny.geoserver.global.xml.ReaderUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigReader {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");
    private File root;
    private boolean initialized = false;
    private WMSDTO wms;
    private WFSDTO wfs;
    private GeoServerDTO geoServer;
    private DataDTO data;
    ServletContext context;

    protected XMLConfigReader(ServletContext context) {
        this.context = context;
        this.wms = new WMSDTO();
        this.wfs = new WFSDTO();
        this.geoServer = new GeoServerDTO();
        this.data = new DataDTO();
        this.root = new File(".");
    }

    public XMLConfigReader(File root, ServletContext context) throws ConfigurationException {
        this.root = root;
        this.context = context;
        this.wms = new WMSDTO();
        this.wfs = new WFSDTO();
        this.geoServer = new GeoServerDTO();
        this.data = new DataDTO();
        this.load();
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void load() throws ConfigurationException {
        File configDir;
        this.root = ReaderUtils.checkFile(this.root, true);
        try {
            configDir = ReaderUtils.checkFile(new File(this.root, "WEB-INF/"), true);
        }
        catch (ConfigurationException confE) {
            configDir = this.root;
        }
        File configFile = ReaderUtils.checkFile(new File(configDir, "services.xml"), false);
        this.loadServices(configFile);
        File catalogFile = ReaderUtils.checkFile(new File(configDir, "catalog.xml"), false);
        File featureTypeDir = GeoserverDataDirectory.findConfigDir(this.root, "featureTypes/");
        File styleDir = GeoserverDataDirectory.findConfigDir(this.root, "styles/");
        this.loadCatalog(catalogFile, featureTypeDir, styleDir);
    }

    protected void loadServices(File configFile) throws ConfigurationException {
        LOGGER.config("Loading configuration file: " + configFile);
        Element configElem = null;
        try {
            FileReader fr = new FileReader(configFile);
            configElem = ReaderUtils.loadConfig(fr);
            fr.close();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        LOGGER.config("parsing configuration documents");
        Element elem = (Element)configElem.getElementsByTagName("global").item(0);
        this.loadGlobal(elem);
        NodeList configuredServices = configElem.getElementsByTagName("service");
        int nServices = configuredServices.getLength();
        for (int i = 0; i < nServices; ++i) {
            elem = (Element)configuredServices.item(i);
            String serviceType = elem.getAttribute("type");
            if ("WFS".equalsIgnoreCase(serviceType)) {
                this.loadWFS(elem);
                continue;
            }
            if ("WMS".equalsIgnoreCase(serviceType)) {
                this.loadWMS(elem);
                continue;
            }
            if ("Z39.50".equalsIgnoreCase(serviceType)) continue;
            throw new ConfigurationException("Unknown service type: " + serviceType);
        }
    }

    protected void loadCatalog(File catalogFile, File featureTypeDir, File styleDir) throws ConfigurationException {
        Element catalogElem = null;
        try {
            LOGGER.config("Loading configuration file: " + catalogFile);
            FileReader fr = new FileReader(catalogFile);
            catalogElem = ReaderUtils.loadConfig(fr);
            fr.close();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        this.data.setNameSpaces(this.loadNameSpaces(ReaderUtils.getChildElement(catalogElem, "namespaces", true)));
        this.setDefaultNS();
        this.data.setDataStores(this.loadDataStores(ReaderUtils.getChildElement(catalogElem, "datastores", true)));
        this.data.setStyles(this.loadStyles(ReaderUtils.getChildElement(catalogElem, "styles", false), styleDir));
        this.data.setFeaturesTypes(this.loadFeatureTypes(featureTypeDir));
    }

    protected void setDefaultNS() {
        Iterator i = this.data.getNameSpaces().values().iterator();
        while (i.hasNext()) {
            NameSpaceInfoDTO ns = (NameSpaceInfoDTO)i.next();
            if (!ns.isDefault()) continue;
            this.data.setDefaultNameSpacePrefix(ns.getPrefix());
            LOGGER.finer("set default namespace pre to " + ns.getPrefix());
            return;
        }
    }

    protected Level getLoggingLevel(Element globalConfigElem) throws ConfigurationException {
        Level level = Logger.getLogger("org.vfny.geoserver").getLevel();
        Element levelElem = ReaderUtils.getChildElement(globalConfigElem, "loggingLevel");
        if (levelElem != null) {
            String levelName = levelElem.getFirstChild().getNodeValue();
            try {
                level = Level.parse(levelName);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning("illegal loggingLevel name: " + levelName);
            }
        } else {
            LOGGER.config("No loggingLevel found, using default logging.properties setting");
        }
        return level;
    }

    protected void loadGlobal(Element globalElem) throws ConfigurationException {
        String adminPassword;
        String logLocation;
        this.geoServer = new GeoServerDTO();
        LOGGER.finer("parsing global configuration parameters");
        Level loggingLevel = this.getLoggingLevel(globalElem);
        this.geoServer.setLoggingLevel(loggingLevel);
        boolean loggingToFile = false;
        Element elem = null;
        elem = ReaderUtils.getChildElement(globalElem, "loggingToFile", false);
        if (elem != null) {
            loggingToFile = ReaderUtils.getBooleanAttribute(elem, "value", false, false);
        }
        if ((logLocation = ReaderUtils.getChildText(globalElem, "logLocation")) != null && "".equals(logLocation.trim())) {
            logLocation = null;
        }
        this.geoServer.setLoggingToFile(loggingToFile);
        this.geoServer.setLogLocation(logLocation);
        try {
            GeoServer.initLogging(loggingLevel, loggingToFile, logLocation, this.context);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        LOGGER.config("logging level is " + loggingLevel);
        if (logLocation != null) {
            LOGGER.config("logging to " + logLocation);
        }
        elem = ReaderUtils.getChildElement(globalElem, "ContactInformation");
        this.geoServer.setContact(this.loadContact(elem));
        elem = ReaderUtils.getChildElement(globalElem, "verbose", false);
        if (elem != null) {
            this.geoServer.setVerbose(ReaderUtils.getBooleanAttribute(elem, "value", false, true));
        }
        if ((elem = ReaderUtils.getChildElement(globalElem, "maxFeatures")) != null) {
            this.geoServer.setMaxFeatures(ReaderUtils.getIntAttribute(elem, "value", true, this.geoServer.getMaxFeatures()));
        }
        LOGGER.config("maxFeatures is " + this.geoServer.getMaxFeatures());
        elem = ReaderUtils.getChildElement(globalElem, "numDecimals");
        if (elem != null) {
            this.geoServer.setNumDecimals(ReaderUtils.getIntAttribute(elem, "value", true, this.geoServer.getNumDecimals()));
        }
        LOGGER.config("numDecimals returning is " + this.geoServer.getNumDecimals());
        elem = ReaderUtils.getChildElement(globalElem, "charSet");
        if (elem != null) {
            String chSet = ReaderUtils.getAttribute(elem, "value", true);
            try {
                Charset cs = Charset.forName(chSet);
                this.geoServer.setCharSet(cs);
                LOGGER.finer("charSet: " + cs.displayName());
            }
            catch (Exception ex) {
                LOGGER.info(ex.getMessage());
            }
        }
        LOGGER.config("charSet is " + this.geoServer.getCharSet());
        String schemaBaseUrl = ReaderUtils.getChildText(globalElem, "SchemaBaseUrl");
        if (schemaBaseUrl != null) {
            this.geoServer.setSchemaBaseUrl(schemaBaseUrl);
        } else {
            this.geoServer.setSchemaBaseUrl(this.root.toString() + "/data/capabilities/");
        }
        String adminUserName = ReaderUtils.getChildText(globalElem, "adminUserName");
        if (adminUserName != null) {
            this.geoServer.setAdminUserName(adminUserName);
        }
        if ((adminPassword = ReaderUtils.getChildText(globalElem, "adminPassword")) != null) {
            this.geoServer.setAdminPassword(adminPassword);
        }
        if ((elem = ReaderUtils.getChildElement(globalElem, "verboseExceptions", false)) != null) {
            this.geoServer.setVerboseExceptions(ReaderUtils.getBooleanAttribute(elem, "value", false, true));
        }
    }

    protected ContactDTO loadContact(Element contactInfoElement) throws ConfigurationException {
        ContactDTO c = new ContactDTO();
        if (contactInfoElement == null) {
            return c;
        }
        Element elem = ReaderUtils.getChildElement(contactInfoElement, "ContactPersonPrimary");
        if (elem != null) {
            c.setContactPerson(ReaderUtils.getChildText(elem, "ContactPerson"));
            c.setContactOrganization(ReaderUtils.getChildText(elem, "ContactOrganization"));
        }
        c.setContactPosition(ReaderUtils.getChildText(contactInfoElement, "ContactPosition"));
        elem = ReaderUtils.getChildElement(contactInfoElement, "ContactAddress");
        if (elem != null) {
            c.setAddressType(ReaderUtils.getChildText(elem, "AddressType"));
            c.setAddress(ReaderUtils.getChildText(elem, "Address"));
            c.setAddressCity(ReaderUtils.getChildText(elem, "City"));
            c.setAddressState(ReaderUtils.getChildText(elem, "StateOrProvince"));
            c.setAddressPostalCode(ReaderUtils.getChildText(elem, "PostCode"));
            c.setAddressCountry(ReaderUtils.getChildText(elem, "Country"));
        }
        c.setContactVoice(ReaderUtils.getChildText(contactInfoElement, "ContactVoiceTelephone"));
        c.setContactFacsimile(ReaderUtils.getChildText(contactInfoElement, "ContactFacsimileTelephone"));
        c.setContactEmail(ReaderUtils.getChildText(contactInfoElement, "ContactElectronicMailAddress"));
        return c;
    }

    protected void loadWFS(Element wfsElement) throws ConfigurationException {
        this.wfs = new WFSDTO();
        this.wfs.setFeatureBounding(ReaderUtils.getBooleanAttribute(ReaderUtils.getChildElement(wfsElement, "featureBounding"), "value", false, false));
        Element elem = ReaderUtils.getChildElement(wfsElement, "srsXmlStyle", false);
        LOGGER.config("reading srsXmlStyle: " + elem);
        if (elem != null) {
            this.wfs.setSrsXmlStyle(ReaderUtils.getBooleanAttribute(elem, "value", false, true));
            LOGGER.fine("set srsXmlStyle to " + ReaderUtils.getBooleanAttribute(elem, "value", false, true));
        }
        String serviceLevelValue = ReaderUtils.getChildText(wfsElement, "serviceLevel");
        int serviceLevel = 31;
        if (serviceLevelValue != null && !serviceLevelValue.equals("")) {
            LOGGER.finer("reading serviceLevel: " + serviceLevelValue);
            if (serviceLevelValue.equalsIgnoreCase("basic")) {
                serviceLevel = 1;
            } else if (serviceLevelValue.equalsIgnoreCase("complete")) {
                serviceLevel = 31;
            } else if (serviceLevelValue.equalsIgnoreCase("transactional")) {
                serviceLevel = 15;
            } else {
                try {
                    serviceLevel = Integer.parseInt(serviceLevelValue);
                }
                catch (NumberFormatException nfe) {
                    String mesg = "Could not parse serviceLevel.  It should be one of Basic, Complete, or Transactional or else an integer value";
                    throw new ConfigurationException(mesg, nfe);
                }
            }
        } else {
            serviceLevel = ReaderUtils.getIntAttribute(ReaderUtils.getChildElement(wfsElement, "serviceLevel"), "value", false, 31);
        }
        LOGGER.finer("setting service level to " + serviceLevel);
        this.wfs.setServiceLevel(serviceLevel);
        Element e = ReaderUtils.getChildElement(wfsElement, "citeConformanceHacks");
        if (e != null) {
            String text = ReaderUtils.getChildText(wfsElement, "citeConformanceHacks");
            boolean citeConformanceHacks = Boolean.valueOf(text);
            this.wfs.setCiteConformanceHacks(citeConformanceHacks);
            LOGGER.finer("setting citeConformanceHacks to " + citeConformanceHacks);
        }
        ServiceDTO s = this.loadService(wfsElement);
        this.wfs.setService(s);
    }

    protected void loadWMS(Element wmsElement) throws ConfigurationException {
        this.wms = new WMSDTO();
        this.wms.setService(this.loadService(wmsElement));
        this.wms.setSvgRenderer(ReaderUtils.getChildText(wmsElement, "svgRenderer"));
        this.wms.setSvgAntiAlias(!"false".equals(ReaderUtils.getChildText(wmsElement, "svgAntiAlias")));
    }

    protected ServiceDTO loadService(Element serviceRoot) throws ConfigurationException {
        ServiceDTO s = new ServiceDTO();
        s.setName(ReaderUtils.getChildText(serviceRoot, "name", true));
        s.setTitle(ReaderUtils.getChildText(serviceRoot, "title", false));
        s.setAbstract(ReaderUtils.getChildText(serviceRoot, "abstract"));
        s.setKeywords(ReaderUtils.getKeyWords(ReaderUtils.getChildElement(serviceRoot, "keywords")));
        s.setFees(ReaderUtils.getChildText(serviceRoot, "fees"));
        s.setAccessConstraints(ReaderUtils.getChildText(serviceRoot, "accessConstraints"));
        s.setMaintainer(ReaderUtils.getChildText(serviceRoot, "maintainer"));
        s.setEnabled(ReaderUtils.getBooleanAttribute(serviceRoot, "enabled", false, true));
        s.setStrategy(ReaderUtils.getChildText(serviceRoot, "serviceStrategy"));
        s.setPartialBufferSize(ReaderUtils.getIntAttribute(serviceRoot, "partialBufferSize", false, 0));
        try {
            s.setOnlineResource(new URL(ReaderUtils.getChildText(serviceRoot, "onlineResource", true)));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(e);
        }
        return s;
    }

    protected Map loadNameSpaces(Element nsRoot) throws ConfigurationException {
        NodeList nsList = nsRoot.getElementsByTagName("namespace");
        int nsCount = nsList.getLength();
        HashMap<String, NameSpaceInfoDTO> nameSpaces = new HashMap<String, NameSpaceInfoDTO>(nsCount);
        for (int i = 0; i < nsCount; ++i) {
            Element elem = (Element)nsList.item(i);
            NameSpaceInfoDTO ns = new NameSpaceInfoDTO();
            ns.setUri(ReaderUtils.getAttribute(elem, "uri", true));
            ns.setPrefix(ReaderUtils.getAttribute(elem, "prefix", true));
            ns.setDefault(ReaderUtils.getBooleanAttribute(elem, "default", false, false) || nsCount == 1);
            LOGGER.config("added namespace " + ns);
            nameSpaces.put(ns.getPrefix(), ns);
        }
        return nameSpaces;
    }

    protected Map loadStyles(Element stylesElem, File baseDir) throws ConfigurationException {
        HashMap<String, StyleDTO> styles = new HashMap<String, StyleDTO>();
        NodeList stylesList = null;
        if (stylesElem != null) {
            stylesList = stylesElem.getElementsByTagName("style");
        }
        if (stylesList == null || stylesList.getLength() == 0) {
            StyleDTO s = new StyleDTO();
            s.setId("normal");
            s.setFilename(new File(baseDir, "normal.sld"));
            s.setDefault(true);
            styles.put("normal", s);
        }
        int styleCount = stylesList.getLength();
        for (int i = 0; i < styleCount; ++i) {
            Element styleElem = (Element)stylesList.item(i);
            StyleDTO s = new StyleDTO();
            s.setId(ReaderUtils.getAttribute(styleElem, "id", true));
            s.setFilename(new File(baseDir, ReaderUtils.getAttribute(styleElem, "filename", true)));
            s.setDefault(ReaderUtils.getBooleanAttribute(styleElem, "default", false, false));
            styles.put(s.getId(), s);
            LOGGER.config("Loaded style " + s.getId());
        }
        return styles;
    }

    protected Map loadDataStores(Element dsRoot) throws ConfigurationException {
        HashMap<String, DataStoreInfoDTO> dataStores = new HashMap<String, DataStoreInfoDTO>();
        NodeList dsElements = dsRoot.getElementsByTagName("datastore");
        int dsCnt = dsElements.getLength();
        for (int i = 0; i < dsCnt; ++i) {
            Element dsElem = (Element)dsElements.item(i);
            DataStoreInfoDTO dsConfig = this.loadDataStore(dsElem);
            if (dataStores.containsKey(dsConfig.getId())) {
                throw new ConfigurationException("duplicated datastore id: " + this.data.getNameSpaces().get(dsConfig.getNameSpaceId()));
            }
            dataStores.put(dsConfig.getId(), dsConfig);
        }
        return dataStores;
    }

    protected DataStoreInfoDTO loadDataStore(Element dsElem) throws ConfigurationException {
        DataStoreInfoDTO ds = new DataStoreInfoDTO();
        LOGGER.finer("creating a new DataStoreDTO configuration");
        ds.setId(ReaderUtils.getAttribute(dsElem, "id", true));
        String namespacePrefix = ReaderUtils.getAttribute(dsElem, "namespace", true);
        if (!this.data.getNameSpaces().containsKey(namespacePrefix)) {
            String msg = "there is no namespace defined for datatasore '" + namespacePrefix + "'";
            throw new ConfigurationException(msg);
        }
        ds.setNameSpaceId(namespacePrefix);
        ds.setEnabled(ReaderUtils.getBooleanAttribute(dsElem, "enabled", false, true));
        ds.setTitle(ReaderUtils.getChildText(dsElem, "title", false));
        ds.setAbstract(ReaderUtils.getChildText(dsElem, "description", false));
        LOGGER.finer("loading connection parameters for DataStoreDTO " + ds.getNameSpaceId());
        ds.setConnectionParams(this.loadConnectionParams(ReaderUtils.getChildElement(dsElem, "connectionParams", true)));
        LOGGER.config("Loaded datastore " + ds.getId());
        return ds;
    }

    protected Map loadConnectionParams(Element connElem) throws ConfigurationException {
        HashMap<String, String> connectionParams = new HashMap<String, String>();
        NodeList paramElems = connElem.getElementsByTagName("parameter");
        int pCount = paramElems.getLength();
        for (int i = 0; i < pCount; ++i) {
            Element param = (Element)paramElems.item(i);
            String paramKey = ReaderUtils.getAttribute(param, "name", true);
            String paramValue = ReaderUtils.getAttribute(param, "value", false);
            connectionParams.put(paramKey, paramValue);
            LOGGER.finer("added parameter " + paramKey + ": '" + paramValue + "'");
        }
        return connectionParams;
    }

    protected Map loadFeatureTypes(File featureTypeRoot) throws ConfigurationException {
        LOGGER.finest("examining: " + featureTypeRoot.getAbsolutePath());
        LOGGER.finest("is dir: " + featureTypeRoot.isDirectory());
        if (!featureTypeRoot.isDirectory()) {
            throw new IllegalArgumentException("featureTypeRoot must be a directoy");
        }
        File[] directories = featureTypeRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        HashMap<String, FeatureTypeInfoDTO> map = new HashMap<String, FeatureTypeInfoDTO>();
        int n = directories.length;
        for (int i = 0; i < n; ++i) {
            File info = new File(directories[i], "info.xml");
            if (!info.exists() || !info.isFile()) continue;
            LOGGER.finer("Info dir:" + info);
            FeatureTypeInfoDTO dto = this.loadFeature(info);
            String ftName = null;
            try {
                ftName = URLDecoder.decode(dto.getKey(), "UTF-8");
                LOGGER.info("Decoding file name: " + ftName);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException(e);
            }
            map.put(ftName, dto);
        }
        return map;
    }

    protected FeatureTypeInfoDTO loadFeature(File infoFile) throws ConfigurationException {
        if (!infoFile.exists()) {
            throw new IllegalArgumentException("Info File not found:" + infoFile);
        }
        if (!infoFile.isFile()) {
            throw new IllegalArgumentException("Info file is the wrong type:" + infoFile);
        }
        if (!XMLConfigReader.isInfoFile(infoFile)) {
            throw new IllegalArgumentException("Info File not valid:" + infoFile);
        }
        Element featureElem = null;
        try {
            LOGGER.config("Loading configuration file: " + infoFile);
            FileReader reader = null;
            reader = new FileReader(infoFile);
            featureElem = ReaderUtils.loadConfig(reader);
            ((Reader)reader).close();
        }
        catch (FileNotFoundException fileNotFound) {
            throw new ConfigurationException("Could not read info file:" + infoFile, fileNotFound);
        }
        catch (Exception erk) {
            throw new ConfigurationException("Could not parse info file:" + infoFile, erk);
        }
        FeatureTypeInfoDTO dto = this.loadFeaturePt2(featureElem);
        File parentDir = infoFile.getParentFile();
        dto.setDirName(parentDir.getName());
        File schemaFile = new File(parentDir, "schema.xml");
        if (schemaFile.exists() && schemaFile.isFile()) {
            LOGGER.finest("process schema file " + infoFile);
            try {
                this.loadSchema(schemaFile, dto);
            }
            catch (Exception badDog) {
                badDog.printStackTrace();
                List attributeList = Collections.EMPTY_LIST;
            }
        } else {
            dto.setSchemaAttributes(Collections.EMPTY_LIST);
        }
        LOGGER.config("added featureType " + dto.getName());
        return dto;
    }

    protected FeatureTypeInfoDTO loadFeaturePt2(Element fTypeRoot) throws ConfigurationException {
        Element legendURL;
        Element cacheInfo;
        FeatureTypeInfoDTO ft = new FeatureTypeInfoDTO();
        ft.setName(ReaderUtils.getChildText(fTypeRoot, "name", true));
        ft.setTitle(ReaderUtils.getChildText(fTypeRoot, "title", true));
        ft.setAbstract(ReaderUtils.getChildText(fTypeRoot, "abstract"));
        String keywords = ReaderUtils.getChildText(fTypeRoot, "keywords");
        if (keywords != null) {
            LinkedList<String> l = new LinkedList<String>();
            String[] ss = keywords.split(",");
            for (int i = 0; i < ss.length; ++i) {
                l.add(ss[i].trim());
            }
            ft.setKeywords(l);
        }
        ft.setDataStoreId(ReaderUtils.getAttribute(fTypeRoot, "datastore", true));
        ft.setSRS(Integer.parseInt(ReaderUtils.getChildText(fTypeRoot, "SRS", true)));
        Element tmp = ReaderUtils.getChildElement(fTypeRoot, "styles");
        if (tmp != null) {
            ft.setDefaultStyle(ReaderUtils.getAttribute(tmp, "default", false));
        }
        if ((cacheInfo = ReaderUtils.getChildElement(fTypeRoot, "cacheinfo")) != null) {
            ft.setCacheMaxAge(ReaderUtils.getAttribute(cacheInfo, "maxage", false));
            ft.setCachingEnabled(new Boolean(ReaderUtils.getAttribute(cacheInfo, "enabled", true)));
        }
        if ((legendURL = ReaderUtils.getChildElement(fTypeRoot, "LegendURL")) != null) {
            LegendURLDTO legend = new LegendURLDTO();
            legend.setWidth(Integer.parseInt(ReaderUtils.getAttribute(legendURL, "width", true)));
            legend.setHeight(Integer.parseInt(ReaderUtils.getAttribute(legendURL, "height", true)));
            legend.setFormat(ReaderUtils.getChildText(legendURL, "Format", true));
            legend.setOnlineResource(ReaderUtils.getAttribute(ReaderUtils.getChildElement(legendURL, "OnlineResource", true), "xlink:href", true));
            ft.setLegendURL(legend);
        }
        ft.setLatLongBBox(this.loadLatLongBBox(ReaderUtils.getChildElement(fTypeRoot, "latLonBoundingBox")));
        Element numDecimalsElem = ReaderUtils.getChildElement(fTypeRoot, "numDecimals", false);
        if (numDecimalsElem != null) {
            ft.setNumDecimals(ReaderUtils.getIntAttribute(numDecimalsElem, "value", false, 8));
        }
        ft.setDefinitionQuery(this.loadDefinitionQuery(fTypeRoot));
        return ft;
    }

    protected List getKeyWords(Element keywordsElem) {
        NodeList klist = keywordsElem.getElementsByTagName("keyword");
        int kCount = klist.getLength();
        LinkedList<String> keywords = new LinkedList<String>();
        for (int i = 0; i < kCount; ++i) {
            Element kelem = (Element)klist.item(i);
            String kword = ReaderUtils.getElementText(kelem);
            if (kword == null) continue;
            keywords.add(kword);
        }
        return keywords;
    }

    protected Envelope loadLatLongBBox(Element bboxElem) throws ConfigurationException {
        if (bboxElem == null) {
            return new Envelope();
        }
        boolean dynamic = ReaderUtils.getBooleanAttribute(bboxElem, "dynamic", false, true);
        if (!dynamic) {
            double minx = ReaderUtils.getDoubleAttribute(bboxElem, "minx", true);
            double miny = ReaderUtils.getDoubleAttribute(bboxElem, "miny", true);
            double maxx = ReaderUtils.getDoubleAttribute(bboxElem, "maxx", true);
            double maxy = ReaderUtils.getDoubleAttribute(bboxElem, "maxy", true);
            return new Envelope(minx, maxx, miny, maxy);
        }
        return new Envelope();
    }

    protected Filter loadDefinitionQuery(Element typeRoot) throws ConfigurationException {
        Element defQNode = ReaderUtils.getChildElement(typeRoot, "definitionQuery", false);
        Filter filter = null;
        if (defQNode != null) {
            LOGGER.finer("definitionQuery element found, looking for Filter");
            Element filterNode = ReaderUtils.getChildElement(defQNode, "Filter", false);
            if (filterNode != null && (filterNode = ReaderUtils.getFirstChildElement(filterNode)) != null) {
                filter = FilterDOMParser.parseFilter((Node)filterNode);
                return filter;
            }
            LOGGER.finer("No Filter definition query found");
        }
        return filter;
    }

    protected static boolean isInfoFile(File testFile) {
        String testName = testFile.getAbsolutePath();
        int start = testName.length() - "info.xml".length();
        int end = testName.length();
        return testName.substring(start, end).equals("info.xml");
    }

    protected void loadSchema(File schemaFile, FeatureTypeInfoDTO dto) throws ConfigurationException {
        schemaFile = ReaderUtils.checkFile(schemaFile, false);
        Element elem = null;
        dto.setSchemaFile(schemaFile);
        if (schemaFile == null || !schemaFile.exists() || !schemaFile.canRead()) {
            System.err.println("File does not exist for schema for " + dto.getName());
            return;
        }
        try {
            LOGGER.config("Loading configuration file: " + schemaFile);
            FileReader reader = new FileReader(schemaFile);
            elem = ReaderUtils.loadConfig(reader);
            ((Reader)reader).close();
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
            throw new ConfigurationException("Could not open schema file:" + schemaFile, e);
        }
        catch (Exception erk) {
            throw new ConfigurationException("Could not parse schema file:" + schemaFile, erk);
        }
        try {
            XMLConfigReader.processSchema(elem, dto);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error occured in " + schemaFile + "\n" + e.getMessage(), e);
        }
    }

    public static void processSchema(Element elem, FeatureTypeInfoDTO featureTypeInfoDTO) throws ConfigurationException {
        ArrayList<AttributeTypeInfoDTO> list = new ArrayList<AttributeTypeInfoDTO>();
        featureTypeInfoDTO.setSchemaName(ReaderUtils.getAttribute(elem, "name", true));
        elem = ReaderUtils.getChildElement(elem, "xs:complexContent");
        elem = ReaderUtils.getChildElement(elem, "xs:extension");
        NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
        NameSpaceElement nse = gml.getElement(ReaderUtils.getAttribute(elem, "base", true));
        featureTypeInfoDTO.setSchemaBase(nse.getTypeDefName());
        elem = ReaderUtils.getChildElement(elem, "xs:sequence");
        NodeList nl = elem.getElementsByTagName("xs:element");
        for (int i = 0; i < nl.getLength(); ++i) {
            Object tmp;
            elem = (Element)nl.item(i);
            AttributeTypeInfoDTO ati = new AttributeTypeInfoDTO();
            String name = ReaderUtils.getAttribute(elem, "name", false);
            String ref = ReaderUtils.getAttribute(elem, "ref", false);
            String type = ReaderUtils.getAttribute(elem, "type", false);
            NameSpaceTranslator nst1 = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
            NameSpaceTranslator nst2 = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
            if (ref != null && ref != "") {
                ati.setComplex(false);
                nse = nst1.getElement(ref);
                if (nse == null) {
                    nse = nst2.getElement(ref);
                }
                tmp = nse.getTypeRefName();
                ati.setType((String)tmp);
                ati.setName((String)tmp);
            } else {
                ati.setName(name);
                if (type != null && type != "") {
                    nse = nst1.getElement(type);
                    if (nse == null) {
                        nse = nst2.getElement(type);
                    }
                    tmp = nse.getTypeRefName();
                    ati.setType((String)tmp);
                    ati.setComplex(false);
                } else {
                    tmp = ReaderUtils.getFirstChildElement(elem);
                    OutputFormat format = new OutputFormat(tmp.getOwnerDocument());
                    format.setLineSeparator("\r\n");
                    format.setIndenting(true);
                    format.setLineWidth(0);
                    format.setPreserveSpace(true);
                    StringWriter sw = new StringWriter();
                    XMLSerializer serializer = new XMLSerializer((Writer)sw, format);
                    try {
                        serializer.asDOMSerializer();
                        serializer.serialize((Element)tmp);
                    }
                    catch (IOException e) {
                        throw new ConfigurationException(e);
                    }
                    ati.setType(elem.toString());
                    ati.setComplex(true);
                }
            }
            ati.setNillable(ReaderUtils.getBooleanAttribute(elem, "nillable", false, true));
            ati.setMaxOccurs(ReaderUtils.getIntAttribute(elem, "maxOccurs", false, 1));
            ati.setMinOccurs(ReaderUtils.getIntAttribute(elem, "minOccurs", false, 1));
            list.add(ati);
        }
        featureTypeInfoDTO.setSchemaAttributes(list);
    }

    public DataDTO getData() {
        return this.data;
    }

    public GeoServerDTO getGeoServer() {
        return this.geoServer;
    }

    public WFSDTO getWfs() {
        return this.wfs;
    }

    public WMSDTO getWms() {
        return this.wms;
    }
}

