/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.vfny.geoserver.global.ConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReaderUtils {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");

    private ReaderUtils() {
    }

    public static Element loadConfig(Reader configFile) throws ConfigurationException {
        try {
            InputSource in = new InputSource(configFile);
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(false);
            dfactory.setValidating(false);
            dfactory.setIgnoringComments(true);
            dfactory.setCoalescing(true);
            dfactory.setIgnoringElementContentWhitespace(true);
            Document serviceDoc = dfactory.newDocumentBuilder().parse(in);
            Element configElem = serviceDoc.getDocumentElement();
            return configElem;
        }
        catch (IOException ioe) {
            String message = "problem reading file " + configFile + "due to: " + ioe.getMessage();
            LOGGER.warning(message);
            throw new ConfigurationException(message, ioe);
        }
        catch (ParserConfigurationException pce) {
            String message = "trouble with parser to read org.vfny.geoserver.global.xml, make sure classpath is correct, reading file " + configFile;
            LOGGER.warning(message);
            throw new ConfigurationException(message, pce);
        }
        catch (SAXException saxe) {
            String message = "trouble parsing XML in " + configFile + ": " + saxe.getMessage();
            LOGGER.warning(message);
            throw new ConfigurationException(message, saxe);
        }
    }

    public static File checkFile(File file, boolean isDir) throws ConfigurationException {
        if (!file.exists()) {
            throw new ConfigurationException("File does not exist: " + file);
        }
        if (isDir && !file.isDirectory()) {
            throw new ConfigurationException("File is not a directory:" + file);
        }
        if (!isDir && !file.isFile()) {
            throw new ConfigurationException("File is not valid:" + file);
        }
        LOGGER.finer("File is valid: " + file);
        return file;
    }

    public static Element getChildElement(Element root, String name, boolean mandatory) throws ConfigurationException {
        Node child;
        for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        if (mandatory && child == null) {
            throw new ConfigurationException(root.getNodeName() + " does not contains a child element named " + name);
        }
        return null;
    }

    public static Element getChildElement(Element root, String name) {
        try {
            return ReaderUtils.getChildElement(root, name, false);
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    public static int getIntAttribute(Element elem, String attName, boolean mandatory, int defaultValue) throws ConfigurationException {
        String attValue = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (!mandatory && attValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attValue);
        }
        catch (Exception ex) {
            if (mandatory) {
                throw new ConfigurationException(attName + " attribute of element " + elem.getNodeName() + " must be an integer, but it's '" + attValue + "'");
            }
            return defaultValue;
        }
    }

    public static String getAttribute(Element elem, String attName, boolean mandatory) throws ConfigurationException {
        if (elem == null) {
            if (mandatory) {
                throw new NullPointerException();
            }
            return "";
        }
        Attr att = elem.getAttributeNode(attName);
        String value = null;
        if (att != null) {
            value = att.getValue();
        }
        if (mandatory) {
            if (att == null) {
                throw new ConfigurationException("element " + elem.getNodeName() + " does not contains an attribute named " + attName);
            }
            if ("".equals(value)) {
                throw new ConfigurationException("attribute " + attName + "in element " + elem.getNodeName() + " is empty");
            }
        }
        return value;
    }

    public static boolean getBooleanAttribute(Element elem, String attName, boolean mandatory, boolean defaultValue) throws ConfigurationException {
        String value = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (value == null || value == "") {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static String getChildText(Element root, String childName) {
        try {
            return ReaderUtils.getChildText(root, childName, false);
        }
        catch (ConfigurationException ex) {
            return null;
        }
    }

    public static String getChildText(Element root, String childName, boolean mandatory) throws ConfigurationException {
        Element elem = ReaderUtils.getChildElement(root, childName, mandatory);
        if (elem != null) {
            return ReaderUtils.getElementText(elem, mandatory);
        }
        if (mandatory) {
            String msg = "Mandatory child " + childName + "not found in " + " element: " + root;
            throw new ConfigurationException(msg);
        }
        return null;
    }

    public static String getElementText(Element elem) {
        try {
            return ReaderUtils.getElementText(elem, false);
        }
        catch (ConfigurationException ex) {
            return null;
        }
    }

    public static String getElementText(Element elem, boolean mandatory) throws ConfigurationException {
        String value = null;
        LOGGER.finer("getting element text for " + elem);
        if (elem != null) {
            NodeList childs = elem.getChildNodes();
            int nChilds = childs.getLength();
            for (int i = 0; i < nChilds; ++i) {
                Node child = childs.item(i);
                if (child.getNodeType() != 3) continue;
                value = child.getNodeValue();
                if (!mandatory || !"".equals(value.trim())) break;
                throw new ConfigurationException(elem.getNodeName() + " text is empty");
            }
            if (mandatory && value == null) {
                throw new ConfigurationException(elem.getNodeName() + " element does not contains text");
            }
        } else {
            throw new ConfigurationException("Argument element can't be null");
        }
        return value;
    }

    public static String[] getKeyWords(Element keywordsElem) {
        NodeList klist = keywordsElem.getElementsByTagName("keyword");
        int kCount = klist.getLength();
        ArrayList<String> keywords = new ArrayList<String>(kCount);
        for (int i = 0; i < kCount; ++i) {
            Element kelem = (Element)klist.item(i);
            String kword = ReaderUtils.getElementText(kelem);
            if (kword == null) continue;
            keywords.add(kword);
        }
        Object[] s = keywords.toArray();
        if (s == null) {
            return new String[0];
        }
        String[] ss = new String[s.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = s[i].toString();
        }
        return ss;
    }

    public static Element getFirstChildElement(Element root) {
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static double getDoubleAttribute(Element elem, String attName, boolean mandatory) throws ConfigurationException {
        String value = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (value == null || value == "") {
            return 0.0;
        }
        double d = Double.NaN;
        if (value != null) {
            try {
                d = Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                throw new ConfigurationException("Illegal attribute value for " + attName + " in element " + elem.getNodeName() + ". Expected double, but was " + value);
            }
        }
        return d;
    }
}

