/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import java.nio.charset.Charset;
import java.util.logging.Level;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.DataTransferObject;

public final class GeoServerDTO
implements DataTransferObject {
    private int maxFeatures = 10000;
    private boolean verbose = true;
    private int numDecimals = 4;
    private Charset charSet = Defaults.Encoding;
    private String schemaBaseUrl;
    private Level loggingLevel = Defaults.LoggingLevel;
    private ContactDTO contact = null;
    private String adminUserName = "admin";
    private String adminPassword = "geoserver";
    private boolean verboseExceptions = false;
    private boolean loggingToFile = false;
    private String logLocation = Defaults.LogLocation;

    public GeoServerDTO() {
    }

    public GeoServerDTO(GeoServerDTO g) {
        if (g == null) {
            throw new NullPointerException();
        }
        this.maxFeatures = g.getMaxFeatures();
        this.verbose = g.isVerbose();
        this.numDecimals = g.getNumDecimals();
        this.charSet = g.getCharSet();
        this.schemaBaseUrl = g.getSchemaBaseUrl();
        this.loggingLevel = g.getLoggingLevel();
        this.verboseExceptions = g.isVerboseExceptions();
        this.loggingToFile = g.getLoggingToFile();
        this.logLocation = g.getLogLocation();
        this.contact = g.getContact() != null ? (ContactDTO)g.getContact().clone() : new ContactDTO();
    }

    public Object clone() {
        return new GeoServerDTO(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GeoServerDTO)) {
            return false;
        }
        GeoServerDTO g = (GeoServerDTO)obj;
        boolean r = true;
        r = r && this.maxFeatures == g.getMaxFeatures();
        r = r && this.verbose == g.isVerbose();
        boolean bl = r = r && this.numDecimals == g.getNumDecimals();
        if (this.charSet != null) {
            r = r && this.charSet.equals(g.getCharSet());
        } else if (g.getCharSet() != null) {
            return false;
        }
        boolean bl2 = r = r && this.schemaBaseUrl == g.getSchemaBaseUrl();
        if (this.contact != null) {
            r = r && this.contact.equals(g.getContact());
        } else if (g.getContact() != null) {
            return false;
        }
        boolean bl3 = r = r && this.loggingToFile == g.getLoggingToFile();
        if (this.logLocation != null) {
            r = r && this.logLocation.equals(g.getLogLocation());
        } else if (g.getLogLocation() != null) {
            return false;
        }
        return r;
    }

    public int hashCode() {
        int i = 1;
        if (this.maxFeatures != 0) {
            i *= this.maxFeatures;
        }
        if (this.numDecimals != 0) {
            i *= this.numDecimals;
        }
        if (this.schemaBaseUrl != null) {
            i *= this.schemaBaseUrl.hashCode();
        }
        return i;
    }

    public Charset getCharSet() {
        return this.charSet;
    }

    public ContactDTO getContact() {
        return this.contact;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public String getSchemaBaseUrl() {
        return this.schemaBaseUrl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setCharSet(Charset charset) {
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        this.charSet = charset;
    }

    public void setContact(ContactDTO contact) {
        if (contact == null) {
            contact = new ContactDTO();
        }
        this.contact = contact;
    }

    public void setMaxFeatures(int i) {
        this.maxFeatures = i;
    }

    public void setNumDecimals(int i) {
        this.numDecimals = i;
    }

    public void setSchemaBaseUrl(String url) {
        this.schemaBaseUrl = url;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(Level level) {
        this.loggingLevel = level;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public void setAdminUserName(String username) {
        this.adminUserName = username;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String password) {
        this.adminPassword = password;
    }

    public boolean isVerboseExceptions() {
        return this.verboseExceptions;
    }

    public void setVerboseExceptions(boolean showStackTraces) {
        this.verboseExceptions = showStackTraces;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    public boolean getLoggingToFile() {
        return this.loggingToFile;
    }

    public void setLoggingToFile(boolean loggingToFile) {
        this.loggingToFile = loggingToFile;
    }

    public String toString() {
        StringBuffer dto = new StringBuffer("[GeoServerDTO: \n");
        dto.append("   maxFeatures - " + this.maxFeatures);
        dto.append("\n   verbose - " + this.verbose);
        dto.append("\n   numDecimals - " + this.numDecimals);
        dto.append("\n   charSet - " + this.charSet);
        dto.append("\n   loggingLevel - " + this.loggingLevel);
        dto.append("\n   adminUserName - " + this.adminUserName);
        dto.append("\n   adminPassword - " + this.adminPassword);
        dto.append("\n   contact - " + this.contact);
        return dto.toString();
    }

    public static class Defaults {
        public static final int MaxFeatures = 10000;
        public static final Charset Encoding = Charset.forName("UTF-8");
        public static final boolean Verbose = true;
        public static final int NumDecimals = 4;
        public static final Level LoggingLevel = Level.INFO;
        public static final String AdminUserName = "admin";
        public static final String AdminPassword = "geoserver";
        public static final boolean VerboseExceptions = false;
        public static final boolean LoggingToFile = false;
        public static final String LogLocation = null;
    }
}

