/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.xml.NameSpaceElement;
import org.vfny.geoserver.global.xml.NameSpaceTranslator;
import org.vfny.geoserver.global.xml.NameSpaceTranslatorFactory;

public class DataTransferObjectFactory {
    public static Map schemaBaseMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    public static AttributeTypeInfoDTO create(String schemaBase, AttributeType attributeType) {
        AttributeTypeInfoDTO dto = new AttributeTypeInfoDTO();
        dto.setName(attributeType.getName());
        dto.setMinOccurs(DataTransferObjectFactory.isManditory(schemaBase, attributeType.getName()) ? 1 : 0);
        dto.setMaxOccurs(1);
        dto.setNillable(attributeType.isNillable());
        NameSpaceTranslator xs = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
        NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
        NameSpaceElement element = xs.getElement(attributeType.getType(), attributeType.getName());
        if (element == null) {
            element = gml.getElement(attributeType.getType(), attributeType.getName());
        }
        if (element == null) {
            element = xs.getElement("string");
        }
        dto.setComplex(false);
        dto.setType(element.getTypeRefName());
        return dto;
    }

    public static AttributeTypeInfoDTO create(String schemaBase, String attributeName) {
        AttributeTypeInfoDTO dto = new AttributeTypeInfoDTO();
        dto.setName(attributeName);
        dto.setMinOccurs(DataTransferObjectFactory.isManditory(schemaBase, attributeName) ? 1 : 0);
        dto.setMaxOccurs(1);
        dto.setNillable(true);
        NameSpaceTranslator xs = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
        NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
        NameSpaceElement element = xs.getElement(attributeName);
        if (element == null) {
            element = gml.getElement(attributeName);
        }
        if (element == null) {
            element = xs.getElement("string");
        }
        dto.setComplex(false);
        dto.setType(element.getTypeRefName());
        return dto;
    }

    public static FeatureTypeInfoDTO create(String dataStoreId, FeatureType schema) {
        FeatureTypeInfoDTO dto = new FeatureTypeInfoDTO();
        dto.setAbstract(null);
        dto.setDataStoreId(dataStoreId);
        dto.setDefaultStyle("styles/normal.sld");
        dto.setDefinitionQuery(null);
        dto.setDirName(dataStoreId + "_" + schema.getTypeName());
        dto.setKeywords(Collections.EMPTY_LIST);
        dto.setLatLongBBox(new Envelope());
        dto.setName(schema.getTypeName());
        dto.setNumDecimals(8);
        dto.setSchemaAttributes(DataTransferObjectFactory.generateAttributes(schema));
        NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
        String schemaBase = gml.getElement("AbstractFeatureType").getQualifiedTypeDefName();
        dto.setSchemaBase(schemaBase);
        dto.setSchemaName(dataStoreId.toUpperCase() + "_" + schema.getTypeName().toUpperCase() + "_TYPE");
        dto.setSRS(schema.getDefaultGeometry().getGeometryFactory().getSRID());
        dto.setTitle(schema.getNamespace() + " " + schema.getTypeName());
        return dto;
    }

    public static List generateAttributes(FeatureType schema) {
        AttributeType[] attributes = schema.getAttributeTypes();
        ArrayList<AttributeTypeInfoDTO> list = new ArrayList<AttributeTypeInfoDTO>(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            list.add(DataTransferObjectFactory.create("AbstractFeatureType", attributes[i]));
        }
        return list;
    }

    public static List generateRequiredAttributes(String schemaBase) {
        String[] attributeNames = DataTransferObjectFactory.getRequiredBaseAttributes(schemaBase);
        ArrayList<AttributeTypeInfoDTO> list = new ArrayList<AttributeTypeInfoDTO>(attributeNames.length);
        for (int i = 0; i < attributeNames.length; ++i) {
            list.add(DataTransferObjectFactory.create(schemaBase, attributeNames[i]));
        }
        return list;
    }

    public static boolean isManditory(String schemaBase, String attribute) {
        String[] required = DataTransferObjectFactory.getRequiredBaseAttributes(schemaBase);
        for (int i = 0; i < required.length; ++i) {
            if (!attribute.equals(required[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] getRequiredBaseAttributes(String schemaBase) {
        if (schemaBaseMap.containsKey(schemaBase)) {
            return (String[])schemaBaseMap.get(schemaBase);
        }
        return new String[0];
    }

    public static List getElements(String name, Class type) {
        NameSpaceElement element;
        NameSpaceTranslator xs = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
        NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
        LinkedList<NameSpaceElement> result = new LinkedList<NameSpaceElement>();
        if (name == null || name == "") {
            throw new NullPointerException("Element name must be defined.");
        }
        if (type == null) {
            throw new NullPointerException("Element type must be defined.");
        }
        Set s = xs.getAssociatedTypes(type);
        s.addAll(xs.getAssociatedTypes(name));
        s.addAll(gml.getAssociatedTypes(type));
        s.addAll(gml.getAssociatedTypes(name));
        Iterator i = s.iterator();
        while (i.hasNext()) {
            element = (NameSpaceElement)i.next();
            if (!name.equals(element.getTypeDefName())) continue;
            if (!result.contains(element)) {
                result.add(element);
                continue;
            }
            if (!name.equals(element.getTypeRefName())) continue;
            if (!result.contains(element)) {
                result.add(element);
                continue;
            }
            if (!name.equals(element.getQualifiedTypeDefName())) continue;
            if (!result.contains(element)) {
                result.add(element);
                continue;
            }
            if (!name.equals(element.getQualifiedTypeRefName()) || result.contains(element)) continue;
            result.add(element);
        }
        if (!(class$java$lang$Object == null ? (class$java$lang$Object = DataTransferObjectFactory.class$("java.lang.Object")) : class$java$lang$Object).equals(type)) {
            Class cls = type;
            while (!(class$java$lang$Object == null ? DataTransferObjectFactory.class$("java.lang.Object") : class$java$lang$Object).equals(cls)) {
                i = s.iterator();
                while (i.hasNext()) {
                    NameSpaceElement element2 = (NameSpaceElement)i.next();
                    if (!element2.getJavaClass().equals(cls) || result.contains(element2)) continue;
                    result.add(element2);
                }
                cls = cls.getSuperclass();
            }
        }
        i = s.iterator();
        while (i.hasNext()) {
            element = (NameSpaceElement)i.next();
            if (result.contains(element)) continue;
            result.add(element);
        }
        element = xs.getElement("string");
        if (!result.contains(element)) {
            result.add(element);
        }
        return result;
    }

    private static final NameSpaceElement getBestMatch(String name, Class type) {
        return (NameSpaceElement)DataTransferObjectFactory.getElements(name, type).get(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        schemaBaseMap.put("gml:AbstractFeatureType", new String[0]);
    }
}

