/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.dto.ServiceDTO;

public abstract class Service
extends GlobalLayerSupertype {
    private boolean enabled;
    private URL onlineResource;
    private String name;
    private String title;
    private String serverAbstract;
    private String[] keywords = new String[0];
    private String fees;
    private String accessConstraints;
    private String maintainer;
    private String strategy;
    private int partialBufferSize;
    private GeoServer gs;
    private Data dt;

    public Service(ServiceDTO dto) {
        if (dto == null) {
            throw new NullPointerException();
        }
        this.enabled = dto.isEnabled();
        this.name = dto.getName();
        this.title = dto.getTitle();
        this.serverAbstract = dto.getAbstract();
        this.keywords = dto.getKeywords();
        this.fees = dto.getFees();
        this.accessConstraints = dto.getAccessConstraints();
        this.maintainer = dto.getMaintainer();
        this.onlineResource = dto.getOnlineResource();
        this.strategy = dto.getStrategy();
        this.partialBufferSize = dto.getPartialBufferSize();
    }

    public void load(ServiceDTO dto) {
        if (dto == null) {
            throw new NullPointerException();
        }
        this.enabled = dto.isEnabled();
        this.name = dto.getName();
        this.title = dto.getTitle();
        this.serverAbstract = dto.getAbstract();
        this.keywords = dto.getKeywords();
        this.fees = dto.getFees();
        this.accessConstraints = dto.getAccessConstraints();
        this.maintainer = dto.getMaintainer();
        this.onlineResource = dto.getOnlineResource();
        this.strategy = dto.getStrategy();
        this.partialBufferSize = dto.getPartialBufferSize();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public URL getOnlineResource() {
        return this.onlineResource;
    }

    public String getAbstract() {
        return this.serverAbstract;
    }

    public String getAccessConstraints() {
        return this.accessConstraints;
    }

    public String getFees() {
        return this.fees;
    }

    public List getKeywords() {
        LinkedList<String> ll = new LinkedList<String>();
        String[] s = this.keywords;
        for (int i = 0; i < s.length; ++i) {
            ll.add(s[i]);
        }
        return ll;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public int getPartialBufferSize() {
        return this.partialBufferSize;
    }

    public void setPartialBufferSize(int partialBufferSize) {
        this.partialBufferSize = partialBufferSize;
    }

    Object toDTO() {
        ServiceDTO dto = new ServiceDTO();
        dto.setAccessConstraints(this.accessConstraints);
        dto.setEnabled(this.enabled);
        dto.setFees(this.fees);
        dto.setKeywords(this.keywords);
        dto.setMaintainer(this.maintainer);
        dto.setName(this.name);
        dto.setOnlineResource(this.onlineResource);
        dto.setAbstract(this.serverAbstract);
        dto.setTitle(this.title);
        dto.setStrategy(this.strategy);
        dto.setPartialBufferSize(this.partialBufferSize);
        return dto;
    }

    public Data getData() {
        return this.dt;
    }

    public void setData(Data dt) {
        this.dt = dt;
    }

    public GeoServer getGeoServer() {
        return this.gs;
    }

    void setGeoServer(GeoServer gs) {
        this.gs = gs;
    }
}

