/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.xml.ReaderUtils;

public class GeoserverDataDirectory {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");
    private static File dataDir;
    private static boolean isTrueDataDir;

    public static File getGeoserverDataDirectory(ServletContext servContext) {
        if (dataDir == null) {
            String prop = System.getProperty("GEOSERVER_DATA_DIR");
            if (prop != null && !prop.equals("")) {
                isTrueDataDir = true;
                dataDir = new File(prop);
                LOGGER.info("Data_dir: " + dataDir.getPath());
                return dataDir;
            }
            String loc = servContext.getInitParameter("GEOSERVER_DATA_DIR");
            if (loc != null) {
                isTrueDataDir = true;
                dataDir = new File(loc);
                LOGGER.info("Data_dir: " + dataDir.getPath());
                return dataDir;
            }
            isTrueDataDir = false;
            String rootDir = servContext.getRealPath("/");
            dataDir = new File(rootDir);
            LOGGER.info("Data_dir: " + dataDir.getPath());
        }
        return dataDir;
    }

    public static boolean isTrueDataDir() {
        return isTrueDataDir;
    }

    public static File findConfigDir(File root, String dirName) throws ConfigurationException {
        File configDir;
        try {
            configDir = ReaderUtils.checkFile(new File(root, dirName), true);
        }
        catch (ConfigurationException confE) {
            File dataDir = new File(root, "data/");
            configDir = ReaderUtils.checkFile(new File(dataDir, dirName), true);
        }
        return configDir;
    }

    static {
        isTrueDataDir = false;
    }
}

