/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.servlet.ServletContext;
import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.Log4JFormatter;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;

public class GeoServer
extends GlobalLayerSupertype {
    public static final String WEB_CONTAINER_KEY = "GeoServer";
    private String title;
    private int maxFeatures = Integer.MAX_VALUE;
    private boolean verbose = true;
    private int numDecimals = 4;
    private Charset charSet = Charset.forName("UTF-8");
    private String adminUserName = "admin";
    private String adminPassword;
    private String schemaBaseUrl;
    private String contactPerson;
    private String contactOrganization;
    private String contactPosition;
    private String addressType;
    private String address;
    private String addressCity;
    private String addressState;
    private String addressPostalCode;
    private String addressCountry;
    private String contactVoice;
    private String contactFacsimile;
    private String contactEmail;
    private boolean verboseExceptions = false;
    private Level loggingLevel = Logger.getLogger("org.vfny.geoserver").getLevel();
    private boolean logToFile = false;
    private boolean loggingToFile = false;
    private String logLocation = null;

    public GeoServer() {
    }

    public GeoServer(Config config) throws ConfigurationException {
        GlobalLayerSupertype.LOGGER.fine("Creating GeoServer");
        this.load(config.getXMLReader().getGeoServer());
    }

    public String getAddress() {
        return this.notNull(this.address);
    }

    public String getAddressCity() {
        return this.notNull(this.addressCity);
    }

    public String getAddressCountry() {
        return this.notNull(this.addressCountry);
    }

    public String getAddressPostalCode() {
        return this.notNull(this.addressPostalCode);
    }

    public String getAddressState() {
        return this.notNull(this.addressState);
    }

    public String getAddressType() {
        return this.notNull(this.addressType);
    }

    public Charset getCharSet() {
        if (this.charSet != null) {
            return this.charSet;
        }
        return Charset.forName("UTF-8");
    }

    public String getContactEmail() {
        return this.notNull(this.contactEmail);
    }

    public String getContactFacsimile() {
        return this.notNull(this.contactFacsimile);
    }

    public String getContactOrganization() {
        return this.notNull(this.contactOrganization);
    }

    public String getContactPerson() {
        return this.notNull(this.contactPerson);
    }

    public String getContactPosition() {
        return this.notNull(this.contactPosition);
    }

    public String getContactVoice() {
        return this.notNull(this.contactVoice);
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public String getMimeType() {
        return "text/xml; charset=" + this.getCharSet().displayName();
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public String getSchemaBaseUrl() {
        return this.schemaBaseUrl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void load(GeoServerDTO dto) throws ConfigurationException {
        if (dto == null) {
            throw new ConfigurationException("load(GeoServerDTO) expected a non-null value");
        }
        this.address = dto.getContact().getAddress();
        this.addressCity = dto.getContact().getAddressCity();
        this.addressCountry = dto.getContact().getAddressCountry();
        this.addressPostalCode = dto.getContact().getAddressPostalCode();
        this.addressState = dto.getContact().getAddressState();
        this.addressType = dto.getContact().getAddressType();
        this.charSet = dto.getCharSet();
        this.contactEmail = dto.getContact().getContactEmail();
        this.contactFacsimile = dto.getContact().getContactFacsimile();
        this.contactOrganization = dto.getContact().getContactOrganization();
        this.contactPerson = dto.getContact().getContactPerson();
        this.contactPosition = dto.getContact().getContactPosition();
        this.contactVoice = dto.getContact().getContactVoice();
        this.loggingLevel = dto.getLoggingLevel();
        this.loggingToFile = dto.getLoggingToFile();
        this.logLocation = dto.getLogLocation();
        this.maxFeatures = dto.getMaxFeatures();
        this.numDecimals = dto.getNumDecimals();
        this.schemaBaseUrl = dto.getSchemaBaseUrl();
        this.verbose = dto.isVerbose();
        this.adminUserName = dto.getAdminUserName();
        this.adminPassword = dto.getAdminPassword();
        this.verboseExceptions = dto.isVerboseExceptions();
    }

    public final void load(GeoServerDTO dto, ServletContext context) throws ConfigurationException {
        this.load(dto);
    }

    public static File getLogLocation(String logLocation, ServletContext context) throws IOException {
        File f = new File(logLocation);
        if (f.exists()) {
            if (f.isDirectory()) {
                if (!logLocation.endsWith(File.separator)) {
                    logLocation = logLocation + File.separator;
                }
                logLocation = logLocation + "geoserver.log";
            }
        } else {
            if (!f.isAbsolute()) {
                File data = GeoserverDataDirectory.getGeoserverDataDirectory(context);
                f = new File(data, f.getPath());
            }
            if (f.getParentFile() != null && !f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
        }
        return f;
    }

    public static void initLogging(Level level, boolean logToFile, String location, ServletContext context) throws IOException {
        Log4JFormatter.init("org.geotools", level);
        Log4JFormatter.init("org.vfny.geoserver", level);
        Logger logger = Logger.getLogger("org.vfny.geoserver");
        Handler[] handlers = logger.getHandlers();
        if (logToFile && location != null) {
            File logFile = GeoServer.getLogLocation(location, context);
            StreamHandler handler = new StreamHandler(new BufferedOutputStream(new FileOutputStream(logFile, true)), new SimpleFormatter());
            handler.setLevel(level);
            logger.addHandler(handler);
            if (Logger.getLogger("org.geotools") != null) {
                Logger.getLogger("org.geotools").addHandler(handler);
            }
        }
    }

    public Object toDTO() {
        GeoServerDTO dto = new GeoServerDTO();
        dto.setCharSet(this.charSet);
        dto.setLoggingLevel(this.loggingLevel);
        dto.setMaxFeatures(this.maxFeatures);
        dto.setNumDecimals(this.numDecimals);
        dto.setSchemaBaseUrl(this.schemaBaseUrl);
        dto.setVerbose(this.verbose);
        dto.setAdminUserName(this.adminUserName);
        dto.setAdminPassword(this.adminPassword);
        dto.setVerboseExceptions(this.verboseExceptions);
        dto.setLoggingToFile(this.loggingToFile);
        dto.setLogLocation(this.logLocation);
        ContactDTO cdto = new ContactDTO();
        dto.setContact(cdto);
        cdto.setAddress(this.address);
        cdto.setAddressCity(this.addressCity);
        cdto.setAddressCountry(this.addressCountry);
        cdto.setAddressPostalCode(this.addressPostalCode);
        cdto.setAddressState(this.addressState);
        cdto.setAddressType(this.addressType);
        cdto.setContactEmail(this.contactEmail);
        cdto.setContactFacsimile(this.contactFacsimile);
        cdto.setContactOrganization(this.contactOrganization);
        cdto.setContactPerson(this.contactPerson);
        cdto.setContactPosition(this.contactPosition);
        cdto.setContactVoice(this.contactVoice);
        return dto;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContactParty() {
        if (this.getContactPerson() != null && this.getContactPerson().length() != 0) {
            return this.getContactPerson();
        }
        if (this.getContactPosition() != null && this.getContactPosition().length() != 0) {
            return this.getContactPosition();
        }
        if (this.getContactOrganization() != null && this.getContactOrganization().length() != 0) {
            return this.getContactOrganization();
        }
        return null;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String toString() {
        StringBuffer geoserver = new StringBuffer("[GeoServer: \n");
        geoserver.append("   maxFeatures - " + this.maxFeatures);
        geoserver.append("\n   verbose - " + this.verbose);
        geoserver.append("\n   numDecimals - " + this.numDecimals);
        geoserver.append("\n   charSet - " + this.charSet);
        geoserver.append("\n   loggingLevel - " + this.loggingLevel);
        geoserver.append("\n   adminUserName - " + this.adminUserName);
        geoserver.append("\n   adminPassword - " + this.adminPassword);
        return geoserver.toString();
    }

    public boolean isVerboseExceptions() {
        return this.verboseExceptions;
    }

    public void setVerboseExceptions(boolean showStackTraces) {
        this.verboseExceptions = showStackTraces;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    public boolean getLoggingToFile() {
        return this.loggingToFile;
    }

    public void setLoggingToFile(boolean loggingToFile) {
        this.loggingToFile = loggingToFile;
    }
}

