/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Transaction;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObjectFactory;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;
import org.vfny.geoserver.global.dto.StyleDTO;

public class Data
extends GlobalLayerSupertype {
    public static final String WEB_CONTAINER_KEY = "DATA";
    private static final String INFO_FILE = "info.xml";
    private static StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();
    private Map nameSpaces;
    private NameSpaceInfo defaultNameSpace;
    private Map dataStores;
    private Map styles;
    private Map stFiles;
    private Map featureTypes;
    private File baseDir;
    private GeoServer gs;
    private Map errors;

    public Data(DataDTO config, File dir, GeoServer g) throws ConfigurationException {
        this.baseDir = dir;
        this.load(config);
        this.gs = g;
    }

    public Data(File dir, GeoServer g) throws ConfigurationException {
        this.baseDir = dir;
        this.gs = g;
    }

    public Data(Config config, GeoServer g) throws ConfigurationException {
        this(config.getXMLReader().getData(), config.dataDirectory(), g);
    }

    GeoServer getGeoServer() {
        return this.gs;
    }

    public void setDataDirectory(File dataDirectory) {
        this.baseDir = dataDirectory;
    }

    public File getDataDirectory() {
        return this.baseDir;
    }

    public void load(DataDTO config) {
        if (config == null) {
            throw new NullPointerException("Non null DataDTO required for load");
        }
        this.dataStores = this.loadDataStores(config);
        this.nameSpaces = this.loadNamespaces(config);
        this.defaultNameSpace = (NameSpaceInfo)this.nameSpaces.get(config.getDefaultNameSpacePrefix());
        this.styles = this.loadStyles(config);
        this.featureTypes = this.loadFeatureTypes(config);
    }

    public Set getDataStores() {
        return new HashSet(this.dataStores.values());
    }

    private final Map loadDataStores(DataDTO dto) {
        if (dto == null || dto.getDataStores() == null) {
            throw new NullPointerException("Non null list of DataStores required");
        }
        HashMap<String, DataStoreInfo> map = new HashMap<String, DataStoreInfo>();
        Iterator i = dto.getDataStores().values().iterator();
        while (i.hasNext()) {
            DataStoreInfoDTO dataStoreDTO = (DataStoreInfoDTO)i.next();
            String id = dataStoreDTO.getId();
            DataStoreInfo dataStoreInfo = new DataStoreInfo(dataStoreDTO, this);
            map.put(id, dataStoreInfo);
            if (dataStoreDTO.isEnabled()) {
                GlobalLayerSupertype.LOGGER.finer("Register DataStore '" + id + "'");
                continue;
            }
            GlobalLayerSupertype.LOGGER.fine("Did not Register DataStore '" + id + "' as it was not enabled");
        }
        return map;
    }

    private final Map loadNamespaces(DataDTO dto) {
        if (dto == null || dto.getNameSpaces() == null) {
            throw new NullPointerException("Non null list of NameSpaces required");
        }
        HashMap<String, NameSpaceInfo> map = new HashMap<String, NameSpaceInfo>();
        Iterator i = dto.getNameSpaces().values().iterator();
        while (i.hasNext()) {
            NameSpaceInfoDTO namespaceDto = (NameSpaceInfoDTO)i.next();
            String prefix = namespaceDto.getPrefix();
            NameSpaceInfo namespaceInfo = new NameSpaceInfo(this, namespaceDto);
            map.put(prefix, namespaceInfo);
        }
        return map;
    }

    private final Map loadFeatureTypes(DataDTO dto) {
        this.errors = new HashMap();
        this.featureTypes = new HashMap();
        if (dto == null || dto.getFeaturesTypes() == null) {
            this.errors = null;
            throw new NullPointerException("Non null list of FeatureTypes required");
        }
        HashMap<String, FeatureTypeInfo> map = new HashMap<String, FeatureTypeInfo>();
        Iterator i = dto.getFeaturesTypes().values().iterator();
        while (i.hasNext()) {
            String typeName;
            DataStoreInfo dataStoreInfo;
            String key;
            FeatureTypeInfoDTO featureTypeDTO;
            block22: {
                featureTypeDTO = (FeatureTypeInfoDTO)i.next();
                if (featureTypeDTO == null) {
                    GlobalLayerSupertype.LOGGER.warning("Ignore null FeatureTypeInfo DTO!");
                    continue;
                }
                key = featureTypeDTO.getKey();
                GlobalLayerSupertype.LOGGER.finer("FeatureType " + key + ": loading feature type info dto:" + featureTypeDTO);
                String dataStoreId = featureTypeDTO.getDataStoreId();
                GlobalLayerSupertype.LOGGER.finest("FeatureType " + key + " looking up :" + dataStoreId);
                dataStoreInfo = (DataStoreInfo)this.dataStores.get(dataStoreId);
                if (dataStoreInfo == null) {
                    GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " could not be used - DataStore " + dataStoreId + " is not defined!");
                    DataStoreInfoDTO tmp = (DataStoreInfoDTO)dto.getDataStores().get(dataStoreId);
                    if (tmp != null && !tmp.isEnabled()) {
                        this.errors.put(featureTypeDTO, Boolean.FALSE);
                        continue;
                    }
                    this.errors.put(featureTypeDTO, new ConfigurationException("FeatureTypeInfo " + key + " could not be used - DataStore " + dataStoreId + " is not defined!"));
                    continue;
                }
                GlobalLayerSupertype.LOGGER.finest(key + " datastore found :" + dataStoreInfo);
                Style s = this.getStyle(featureTypeDTO.getDefaultStyle());
                if (s == null) {
                    GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " ignored - Style '" + featureTypeDTO.getDefaultStyle() + "' not found!");
                    this.errors.put(featureTypeDTO, new ConfigurationException("FeatureTypeInfo " + key + " ignored - Style '" + featureTypeDTO.getDefaultStyle() + "' not found!"));
                    continue;
                }
                typeName = featureTypeDTO.getName();
                try {
                    boolean createAttrDTO;
                    DataStore dataStore = dataStoreInfo.getDataStore();
                    FeatureType featureType = dataStore.getSchema(typeName);
                    HashSet<String> attributeNames = new HashSet<String>();
                    HashSet<String> ATTRIBUTENames = new HashSet<String>();
                    GlobalLayerSupertype.LOGGER.fine("loading datastore " + typeName);
                    if (featureTypeDTO.getSchemaAttributes() == null) {
                        createAttrDTO = true;
                    } else {
                        boolean bl = createAttrDTO = featureTypeDTO.getSchemaAttributes().size() == 0;
                    }
                    if (createAttrDTO) {
                        List attributeDTOs = this.createAttrDTOsFromSchema(featureType);
                        featureTypeDTO.setSchemaAttributes(attributeDTOs);
                        GlobalLayerSupertype.LOGGER.finer("No schema found, setting featureTypeDTO with " + attributeDTOs);
                        break block22;
                    }
                    for (int index = 0; index < featureType.getAttributeCount(); ++index) {
                        AttributeType attrib = featureType.getAttributeType(index);
                        attributeNames.add(attrib.getName());
                        ATTRIBUTENames.add(attrib.getName().toUpperCase());
                    }
                    if (featureTypeDTO.getSchemaAttributes() == null) break block22;
                    Iterator a = featureTypeDTO.getSchemaAttributes().iterator();
                    while (a.hasNext()) {
                        AttributeTypeInfoDTO attribDTO = (AttributeTypeInfoDTO)a.next();
                        String attributeName = attribDTO.getName();
                        if (attributeNames.contains(attributeName)) continue;
                        if (ATTRIBUTENames.contains(attributeName.toUpperCase())) {
                            GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " ignored - attribute '" + attributeName + "' not found - please check captialization");
                        } else {
                            GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " ignored - attribute '" + attributeName + "' not found!");
                            String names = "";
                            Iterator x = attributeNames.iterator();
                            if (x.hasNext()) {
                                names = x.next().toString();
                            }
                            while (x.hasNext()) {
                                names = ":::" + x.next().toString();
                            }
                            GlobalLayerSupertype.LOGGER.severe("Valid attribute names include :::" + names);
                        }
                        this.errors.put(featureTypeDTO, new ConfigurationException("FeatureTypeInfo " + key + " could not be used - DataStore " + dataStoreId + " is not defined!"));
                    }
                    break block22;
                }
                catch (IllegalStateException illegalState) {
                    GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " ignored - as DataStore " + dataStoreId + " is disabled!");
                    this.errors.put(featureTypeDTO, Boolean.FALSE);
                }
                catch (IOException ioException) {
                    GlobalLayerSupertype.LOGGER.log(Level.SEVERE, "FeatureTypeInfo " + key + " ignored - as DataStore " + dataStoreId + " is unavailable:" + ioException);
                    GlobalLayerSupertype.LOGGER.log(Level.FINEST, key + " unavailable", ioException);
                    this.errors.put(featureTypeDTO, ioException);
                }
                catch (Throwable unExpected) {
                    GlobalLayerSupertype.LOGGER.log(Level.SEVERE, "FeatureTypeInfo " + key + " ignored - as DataStore " + dataStoreId + " is broken:" + unExpected);
                    unExpected.printStackTrace();
                    GlobalLayerSupertype.LOGGER.log(Level.FINEST, key + " unavailable", unExpected);
                    this.errors.put(featureTypeDTO, unExpected);
                }
                continue;
            }
            String prefix = dataStoreInfo.getNamesSpacePrefix();
            GlobalLayerSupertype.LOGGER.finest("FeatureType " + key + " creating FeatureTypeInfo for " + prefix + ":" + typeName);
            FeatureTypeInfo featureTypeInfo = null;
            try {
                featureTypeInfo = new FeatureTypeInfo(featureTypeDTO, this);
            }
            catch (ConfigurationException configException) {
                GlobalLayerSupertype.LOGGER.log(Level.SEVERE, "FeatureTypeInfo " + key + " ignored - configuration problem:" + configException);
                GlobalLayerSupertype.LOGGER.log(Level.FINEST, key + " unavailable", configException);
                this.errors.put(featureTypeDTO, configException);
                continue;
            }
            String key2 = prefix + ":" + typeName;
            if (map.containsKey(key2)) {
                GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo '" + key2 + "' already defined - you must have duplicate defined?");
                this.errors.put(featureTypeDTO, new ConfigurationException("FeatureTypeInfo '" + key2 + "' already defined - you must have duplicate defined?"));
                continue;
            }
            GlobalLayerSupertype.LOGGER.finest("FeatureTypeInfo " + key2 + " has been created...");
            map.put(key2, featureTypeInfo);
            GlobalLayerSupertype.LOGGER.finest("FeatureTypeInfo '" + key2 + "' is registered:" + dataStoreInfo);
            this.errors.put(featureTypeDTO, Boolean.TRUE);
        }
        return map;
    }

    private List createAttrDTOsFromSchema(FeatureType featureType) {
        List attrList = DataTransferObjectFactory.generateAttributes(featureType);
        return attrList;
    }

    private final Map loadStyles(DataDTO dto) {
        HashMap<String, Style> map = new HashMap<String, Style>();
        this.stFiles = new HashMap();
        if (dto == null || dto.getStyles() == null) {
            throw new NullPointerException("List of styles is required");
        }
        Iterator i = dto.getStyles().values().iterator();
        while (i.hasNext()) {
            Style style;
            StyleDTO styleDTO = (StyleDTO)i.next();
            String id = styleDTO.getId();
            try {
                style = this.loadStyle(styleDTO.getFilename());
                style.setName(id);
            }
            catch (Exception ioException) {
                GlobalLayerSupertype.LOGGER.log(Level.SEVERE, "Could not load style " + id, ioException);
                continue;
            }
            this.stFiles.put(id, styleDTO.getFilename());
            map.put(id, style);
        }
        GlobalLayerSupertype.LOGGER.finer("returning styles " + map + "\n and set map " + this.stFiles);
        return map;
    }

    static final void outputStatus(String title, Map status) {
        GlobalLayerSupertype.LOGGER.info(title);
        Iterator i = status.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == Boolean.TRUE) {
                GlobalLayerSupertype.LOGGER.fine(key + ": ready");
                continue;
            }
            if (value instanceof Throwable) {
                Throwable t = (Throwable)value;
                GlobalLayerSupertype.LOGGER.log(Level.SEVERE, key + " not ready", t);
                continue;
            }
            GlobalLayerSupertype.LOGGER.warning(key + ": '" + value + "'");
        }
    }

    public Map statusDataStores() {
        HashMap m = new HashMap();
        Iterator i = this.errors.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            FeatureTypeInfoDTO ftdto = (FeatureTypeInfoDTO)e.getKey();
            m.put(ftdto.getDataStoreId() + ":" + ftdto.getName(), e.getValue());
        }
        return m;
    }

    public Map statusNamespaces() {
        HashMap m = new HashMap();
        Iterator i = this.errors.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            FeatureTypeInfoDTO ftdto = (FeatureTypeInfoDTO)e.getKey();
            DataStoreInfo dsdto = (DataStoreInfo)this.dataStores.get(ftdto.getDataStoreId());
            if (dsdto == null) continue;
            m.put(dsdto.getNamesSpacePrefix() + ":" + ftdto.getName(), e.getValue());
        }
        return m;
    }

    public Object toDTO() {
        DataDTO dto = new DataDTO();
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        Iterator i = this.nameSpaces.keySet().iterator();
        while (i.hasNext()) {
            NameSpaceInfo nsi = (NameSpaceInfo)this.nameSpaces.get(i.next());
            tmp.put(nsi.getPrefix(), nsi.toDTO());
        }
        dto.setNameSpaces(tmp);
        if (this.defaultNameSpace != null) {
            dto.setDefaultNameSpacePrefix(this.defaultNameSpace.getPrefix());
        }
        tmp = new HashMap();
        i = this.styles.keySet().iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            Style st = (Style)this.styles.get(id);
            StyleDTO sdto = new StyleDTO();
            sdto.setDefault(st.isDefault());
            sdto.setFilename((File)this.stFiles.get(id));
            sdto.setId(id);
            tmp.put(id, sdto);
        }
        GlobalLayerSupertype.LOGGER.finer("setting styles to: " + tmp);
        dto.setStyles(tmp);
        tmp = new HashMap();
        i = this.dataStores.keySet().iterator();
        while (i.hasNext()) {
            DataStoreInfo dsi = (DataStoreInfo)this.dataStores.get(i.next());
            tmp.put(dsi.getId(), dsi.toDTO());
        }
        dto.setDataStores(tmp);
        tmp = new HashMap();
        i = this.errors.keySet().iterator();
        while (i.hasNext()) {
            FeatureTypeInfoDTO fti = (FeatureTypeInfoDTO)i.next();
            tmp.put(fti.getKey(), fti.clone());
        }
        dto.setFeaturesTypes(tmp);
        return dto;
    }

    public DataStoreInfo getDataStoreInfo(String id) {
        DataStoreInfo dsi = (DataStoreInfo)this.dataStores.get(id);
        if (dsi != null && dsi.isEnabled()) {
            return dsi;
        }
        return null;
    }

    public NameSpaceInfo[] getNameSpaces() {
        NameSpaceInfo[] ns = new NameSpaceInfo[this.nameSpaces.values().size()];
        return new ArrayList(this.nameSpaces.values()).toArray(ns);
    }

    public NameSpaceInfo getNameSpace(String prefix) {
        NameSpaceInfo retNS = (NameSpaceInfo)this.nameSpaces.get(prefix);
        return retNS;
    }

    public NameSpaceInfo getDefaultNameSpace() {
        return this.defaultNameSpace;
    }

    public Map getStyles() {
        return this.styles;
    }

    public Style getStyle(String id) {
        return (Style)this.styles.get(id);
    }

    public FeatureTypeInfo getFeatureTypeInfo(String name) throws NoSuchElementException {
        GlobalLayerSupertype.LOGGER.fine("getting type " + name);
        FeatureTypeInfo found = null;
        found = (FeatureTypeInfo)this.featureTypes.get(name);
        if (found != null) {
            return found;
        }
        String defaultPrefix = this.defaultNameSpace.getPrefix();
        found = (FeatureTypeInfo)this.featureTypes.get(defaultPrefix + ":" + name);
        if (found != null) {
            return found;
        }
        Iterator i = this.featureTypes.values().iterator();
        while (i.hasNext()) {
            FeatureTypeInfo fto = (FeatureTypeInfo)i.next();
            if (name == null || !name.equals(fto.getName())) continue;
            found = fto;
        }
        if (found != null) {
            return found;
        }
        throw new NoSuchElementException("Could not locate FeatureTypeConfig '" + name + "'");
    }

    public FeatureTypeInfo getFeatureTypeInfo(String typename, String uri) {
        Iterator it = this.featureTypes.values().iterator();
        while (it.hasNext()) {
            FeatureTypeInfo fType = (FeatureTypeInfo)it.next();
            if (!fType.isEnabled()) continue;
            String typeId = fType.getNameSpace().getPrefix() + ":" + typename;
            boolean t1 = fType.getName().equals(typeId);
            boolean t2 = fType.getNameSpace().getUri().equals(uri);
            if (!t1) continue;
            return fType;
        }
        return null;
    }

    public Map getFeatureTypeInfos() {
        return Collections.unmodifiableMap(this.featureTypes);
    }

    public Style loadStyle(String fileName, String base) throws IOException {
        return this.loadStyle(new File(base + fileName));
    }

    public Style loadStyle(File fileName) throws IOException {
        SLDParser stylereader = new SLDParser(styleFactory, fileName);
        return stylereader.readXML()[0];
    }

    private static boolean isInfoFile(File testFile) {
        String testName = testFile.getAbsolutePath();
        int start = testName.length() - INFO_FILE.length();
        int end = testName.length();
        return testName.substring(start, end).equals(INFO_FILE);
    }

    public int getConnectionCount() {
        int count = 0;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                DataStore dataStore = meta.getDataStore();
            }
            catch (Throwable notAvailable) {
                continue;
            }
            ++count;
        }
        return count;
    }

    public int getLockCount() {
        int count = 0;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            catch (Throwable huh) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager != null) continue;
        }
        return count;
    }

    public int lockReleaseAll() {
        int count = 0;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            catch (Throwable huh) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager != null) continue;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRelease(String lockID) {
        boolean refresh = false;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null) continue;
            DefaultTransaction t = new DefaultTransaction("Refresh " + meta.getNameSpace());
            try {
                t.addAuthorization(lockID);
                if (!lockingManager.release(lockID, (Transaction)t)) continue;
                refresh = true;
            }
            catch (IOException e) {
                GlobalLayerSupertype.LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                try {
                    t.close();
                }
                catch (IOException closeException) {
                    GlobalLayerSupertype.LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                }
            }
        }
        if (!refresh) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRefresh(String lockID) {
        boolean refresh = false;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null) continue;
            DefaultTransaction t = new DefaultTransaction("Refresh " + meta.getNameSpace());
            try {
                t.addAuthorization(lockID);
                if (!lockingManager.refresh(lockID, (Transaction)t)) continue;
                refresh = true;
            }
            catch (IOException e) {
                GlobalLayerSupertype.LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                try {
                    t.close();
                }
                catch (IOException closeException) {
                    GlobalLayerSupertype.LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                }
            }
        }
        if (!refresh) {
            // empty if block
        }
    }

    public boolean lockRefresh(String lockID, Transaction t) throws IOException {
        boolean refresh = false;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null || !lockingManager.refresh(lockID, t)) continue;
            refresh = true;
        }
        return refresh;
    }

    public boolean lockRelease(String lockID, Transaction t) throws IOException {
        boolean release = false;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null || !lockingManager.release(lockID, t)) continue;
            release = true;
        }
        return release;
    }

    public boolean lockExists(String lockID) {
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null || !lockingManager.exists(lockID)) continue;
            return true;
        }
        return false;
    }

    public Set getPrefixes() {
        return Collections.unmodifiableSet(this.nameSpaces.keySet());
    }

    public String getDefaultPrefix() {
        return this.defaultNameSpace.getPrefix();
    }

    public NameSpaceInfo getNamespaceMetaData(String prefix) {
        return this.getNameSpace(prefix);
    }

    public void registerDataStore(DataStore dataStore) throws IOException {
    }

    public FeatureSource getFeatureSource(String prefix, String typeName) throws IOException {
        if (prefix == null || prefix == "") {
            prefix = this.defaultNameSpace.getPrefix();
        }
        NameSpaceInfo namespace = this.getNamespaceMetaData(prefix);
        FeatureTypeInfo featureType = namespace.getFeatureTypeInfo(typeName);
        DataStoreInfo dataStore = featureType.getDataStoreMetaData();
        return dataStore.getDataStore().getFeatureSource(typeName);
    }

    public File getBaseDir() {
        return this.baseDir;
    }
}

