/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.nio.charset.Charset;
import java.util.logging.Level;
import org.vfny.geoserver.config.ContactConfig;
import org.vfny.geoserver.global.dto.GeoServerDTO;

public class GlobalConfig {
    public static final String CONFIG_KEY = "Config.Global";
    private int maxFeatures = 20000;
    private boolean verbose = true;
    private int numDecimals = 8;
    private Charset charSet;
    private String baseUrl;
    private String schemaBaseUrl;
    private Level loggingLevel = null;
    private String adminUserName;
    private String adminPassword;
    private boolean verboseExceptions;
    private ContactConfig contact = null;
    private boolean loggingToFile = false;
    private String logLocation = null;

    public GlobalConfig() {
        this.maxFeatures = 20000;
        this.verbose = true;
        this.numDecimals = 8;
        this.charSet = Charset.forName("UTF-8");
        this.baseUrl = null;
        this.schemaBaseUrl = null;
        this.contact = null;
        this.verboseExceptions = true;
        this.logLocation = null;
    }

    public GlobalConfig(GeoServerDTO g) {
        if (g == null) {
            throw new NullPointerException();
        }
        this.maxFeatures = g.getMaxFeatures();
        this.verbose = g.isVerbose();
        this.numDecimals = g.getNumDecimals();
        this.charSet = g.getCharSet();
        this.schemaBaseUrl = g.getSchemaBaseUrl();
        this.loggingLevel = g.getLoggingLevel();
        this.adminUserName = g.getAdminUserName();
        this.adminPassword = g.getAdminPassword();
        this.verboseExceptions = g.isVerboseExceptions();
        this.loggingToFile = g.getLoggingToFile();
        this.logLocation = g.getLogLocation();
        this.contact = g.getContact() != null ? new ContactConfig(g.getContact()) : new ContactConfig();
    }

    public void update(GeoServerDTO g) {
        if (g == null) {
            throw new NullPointerException("GeoServer Data Transfer Object required");
        }
        this.maxFeatures = g.getMaxFeatures();
        this.verbose = g.isVerbose();
        this.numDecimals = g.getNumDecimals();
        this.charSet = g.getCharSet();
        this.schemaBaseUrl = g.getSchemaBaseUrl();
        this.loggingLevel = g.getLoggingLevel();
        this.verboseExceptions = g.isVerboseExceptions();
        this.loggingToFile = g.getLoggingToFile();
        this.logLocation = g.getLogLocation();
        this.contact = g.getContact() != null ? new ContactConfig(g.getContact()) : new ContactConfig();
    }

    public GeoServerDTO toDTO() {
        GeoServerDTO g = new GeoServerDTO();
        g.setMaxFeatures(this.maxFeatures);
        g.setVerbose(this.verbose);
        g.setAdminPassword(this.adminPassword);
        g.setAdminUserName(this.adminUserName);
        g.setNumDecimals(this.numDecimals);
        g.setLoggingLevel(this.loggingLevel);
        g.setCharSet(this.charSet);
        g.setSchemaBaseUrl(this.schemaBaseUrl);
        g.setVerboseExceptions(this.verboseExceptions);
        g.setContact(this.contact.toDTO());
        g.setLoggingToFile(this.loggingToFile);
        g.setLogLocation(this.logLocation);
        return g;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Charset getCharSet() {
        return this.charSet;
    }

    public ContactConfig getContact() {
        return this.contact;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public String getSchemaBaseUrl() {
        return this.schemaBaseUrl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setBaseUrl(String url) {
        this.baseUrl = url;
    }

    public void setCharSet(Charset charset) {
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        this.charSet = charset;
    }

    public void setContact(ContactConfig contact) {
        if (contact == null) {
            contact = new ContactConfig();
        }
        this.contact = contact;
    }

    public void setMaxFeatures(int i) {
        this.maxFeatures = i;
    }

    public void setNumDecimals(int i) {
        this.numDecimals = i;
    }

    public void setSchemaBaseUrl(String url) {
        this.schemaBaseUrl = url;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(Level level) {
        this.loggingLevel = level;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminUserName(String username) {
        this.adminUserName = username;
    }

    public void setAdminPassword(String password) {
        this.adminPassword = password;
    }

    public boolean isVerboseExceptions() {
        return this.verboseExceptions;
    }

    public void setVerboseExceptions(boolean showStackTraces) {
        this.verboseExceptions = showStackTraces;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    public boolean getLoggingToFile() {
        return this.loggingToFile;
    }

    public void setLoggingToFile(boolean loggingToFile) {
        this.loggingToFile = loggingToFile;
    }
}

