/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultRepository;
import org.geotools.data.Repository;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.config.NameSpaceConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;
import org.vfny.geoserver.global.dto.StyleDTO;

public class DataConfig {
    public static final String CONFIG_KEY = "Config.Data";
    public static final String SEPARATOR = ":::";
    public static final String SELECTED_FEATURE_TYPE = "selectedFeatureType";
    public static final String SELECTED_ATTRIBUTE_TYPE = "selectedAttributeType";
    private Map dataStores;
    private Map nameSpaces;
    private Map featuresTypes;
    private Map styles;
    private NameSpaceConfig defaultNameSpace;

    public DataConfig() {
        this.dataStores = new HashMap();
        this.nameSpaces = new HashMap();
        this.styles = new HashMap();
        this.featuresTypes = new HashMap();
        this.defaultNameSpace = new NameSpaceConfig();
    }

    public DataConfig(DataDTO data) {
        this.update(data);
    }

    public DataConfig(Data data) {
        this((DataDTO)data.toDTO());
    }

    public void update(DataDTO data) {
        Object key;
        if (data == null) {
            throw new NullPointerException("Data Data Transfer Object required");
        }
        Iterator i = null;
        i = data.getDataStores().keySet().iterator();
        this.dataStores = new HashMap();
        while (i.hasNext()) {
            key = i.next();
            this.dataStores.put(key, new DataStoreConfig((DataStoreInfoDTO)data.getDataStores().get(key)));
        }
        i = data.getNameSpaces().keySet().iterator();
        this.nameSpaces = new HashMap();
        while (i.hasNext()) {
            key = i.next();
            this.nameSpaces.put(key, new NameSpaceConfig((NameSpaceInfoDTO)data.getNameSpaces().get(key)));
            if (!((NameSpaceConfig)this.nameSpaces.get(key)).isDefault()) continue;
            this.defaultNameSpace = (NameSpaceConfig)this.nameSpaces.get(key);
        }
        i = data.getFeaturesTypes().keySet().iterator();
        this.featuresTypes = new HashMap();
        while (i.hasNext()) {
            key = i.next();
            FeatureTypeInfoDTO f = (FeatureTypeInfoDTO)data.getFeaturesTypes().get(key);
            this.featuresTypes.put(f.getDataStoreId() + ":" + f.getName(), new FeatureTypeConfig(f));
        }
        i = data.getStyles().keySet().iterator();
        this.styles = new HashMap();
        while (i.hasNext()) {
            key = i.next();
            this.styles.put(key, new StyleConfig((StyleDTO)data.getStyles().get(key)));
        }
    }

    public DataDTO toDTO() {
        Object key;
        DataDTO dt = new DataDTO();
        HashMap tmp = null;
        Iterator i = null;
        tmp = new HashMap();
        dt.setDataStores(tmp);
        i = this.dataStores.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            tmp.put(key, ((DataStoreConfig)this.dataStores.get(key)).toDTO());
        }
        tmp = new HashMap();
        dt.setFeaturesTypes(tmp);
        i = this.featuresTypes.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            tmp.put(key, ((FeatureTypeConfig)this.featuresTypes.get(key)).toDTO());
        }
        tmp = new HashMap();
        dt.setStyles(tmp);
        i = this.styles.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            tmp.put(key, ((StyleConfig)this.styles.get(key)).toDTO());
        }
        tmp = new HashMap();
        dt.setNameSpaces(tmp);
        i = this.nameSpaces.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            tmp.put(key, ((NameSpaceConfig)this.nameSpaces.get(key)).toDTO());
            if (!((NameSpaceInfoDTO)tmp.get(key)).isDefault()) continue;
            dt.setDefaultNameSpacePrefix(((NameSpaceInfoDTO)tmp.get(key)).getPrefix());
        }
        return dt;
    }

    public List getFeatureTypeConfigKeys() {
        return new ArrayList(this.featuresTypes.keySet());
    }

    public FeatureTypeConfig lookupFeatureTypeConfig(String key) {
        if (this.featuresTypes.containsKey(key)) {
            return (FeatureTypeConfig)this.featuresTypes.get(key);
        }
        throw new NoSuchElementException("Could not find FeatureTypeConfig '" + key + "'.");
    }

    public Map getDataStores() {
        return this.dataStores;
    }

    public List listDataStoreIds() {
        return new ArrayList(this.dataStores.keySet());
    }

    public List getDataStoreIds() {
        return this.listDataStoreIds();
    }

    public DataStoreConfig getDataStore(String key) {
        return (DataStoreConfig)this.dataStores.get(key);
    }

    public NameSpaceConfig getDefaultNameSpace() {
        return this.defaultNameSpace;
    }

    public Map getFeaturesTypes() {
        return this.featuresTypes;
    }

    public FeatureTypeConfig getFeatureTypeConfig(String key) {
        return (FeatureTypeConfig)this.featuresTypes.get(key);
    }

    public Map getNameSpaces() {
        return this.nameSpaces;
    }

    public NameSpaceConfig getNameSpace(String key) {
        return (NameSpaceConfig)this.nameSpaces.get(key);
    }

    public Map getStyles() {
        return this.styles;
    }

    public StyleConfig getStyle(String key) {
        return (StyleConfig)this.styles.get(key);
    }

    public void setDataStores(Map map) {
        if (map != null) {
            this.dataStores = map;
        }
    }

    public void addDataStore(DataStoreConfig dataStoreConfig) {
        if (this.dataStores == null) {
            this.dataStores = new HashMap();
        }
        this.dataStores.put(dataStoreConfig.getId(), dataStoreConfig);
    }

    public DataStoreConfig removeDataStore(String key) {
        if (this.dataStores == null) {
            this.dataStores = new HashMap();
        }
        return (DataStoreConfig)this.dataStores.remove(key);
    }

    public void setDefaultNameSpace(NameSpaceConfig support) {
        if (support != null) {
            if (this.defaultNameSpace != null) {
                this.defaultNameSpace.setDefault(false);
            }
            this.defaultNameSpace = support;
            if (this.defaultNameSpace != null) {
                this.defaultNameSpace.setDefault(true);
            }
        }
    }

    public void setFeaturesTypes(Map map) {
        if (map != null) {
            this.featuresTypes = map;
        }
    }

    public void addFeatureType(String key, FeatureTypeConfig ft) {
        if (this.featuresTypes == null) {
            this.featuresTypes = new HashMap();
        }
        if (key != null && ft != null) {
            this.featuresTypes.put(key, ft);
        }
    }

    public FeatureTypeConfig removeFeatureType(String key) {
        if (this.featuresTypes == null) {
            this.featuresTypes = new HashMap();
        }
        return (FeatureTypeConfig)this.featuresTypes.remove(key);
    }

    public void setNameSpaces(Map map) {
        if (map != null) {
            this.nameSpaces = map;
        }
    }

    public void addNameSpace(String key, NameSpaceConfig ns) {
        if (this.nameSpaces == null) {
            this.nameSpaces = new HashMap();
        }
        if (key != null && ns != null) {
            this.nameSpaces.put(key, ns);
        }
    }

    public NameSpaceConfig removeNameSpace(String key) {
        if (this.nameSpaces == null) {
            this.nameSpaces = new HashMap();
        }
        return (NameSpaceConfig)this.nameSpaces.remove(key);
    }

    public void setStyles(Map map) {
        if (map != null) {
            this.styles = map;
        }
    }

    public void addStyle(String key, StyleConfig s) {
        if (this.styles == null) {
            this.styles = new HashMap();
        }
        if (key != null && s != null) {
            this.styles.put(key, s);
        }
    }

    public StyleConfig removeStyle(String key) {
        if (this.styles == null) {
            this.styles = new HashMap();
        }
        return (StyleConfig)this.styles.remove(key);
    }

    public SortedSet getFeatureTypeIdentifiers(ServletContext sc) {
        TreeSet<String> set = new TreeSet<String>();
        Iterator iter = this.dataStores.values().iterator();
        while (iter.hasNext()) {
            DataStoreConfig dataStoreConfig = (DataStoreConfig)iter.next();
            try {
                DataStore dataStore = dataStoreConfig.findDataStore(sc);
                String[] typeNames = dataStore.getTypeNames();
                for (int i = 0; i < typeNames.length; ++i) {
                    typeNames[i] = dataStoreConfig.getId() + SEPARATOR + typeNames[i];
                }
                List<String> typeNamesList = Arrays.asList(typeNames);
                set.addAll(typeNamesList);
            }
            catch (Throwable ignore) {
                System.out.println("Could not use " + dataStoreConfig.getId() + " datastore was unavailable!");
                ignore.printStackTrace();
            }
        }
        return Collections.unmodifiableSortedSet(set);
    }

    public Repository toRepository(ServletContext context) throws IOException {
        DefaultRepository repository = new DefaultRepository();
        Iterator i = this.dataStores.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String dataStoreId = (String)entry.getKey();
            DataStoreConfig dataStoreConfig = (DataStoreConfig)entry.getValue();
            repository.register(dataStoreId, dataStoreConfig.findDataStore(context));
        }
        return repository;
    }
}

