/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.util.ResponseUtils;

public class ServiceException
extends Exception {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses");
    protected String preMessage = new String();
    protected String locator = new String();
    protected String code = new String();

    public ServiceException() {
    }

    public ServiceException(String message) {
        super(message);
        LOGGER.fine(this.getMessage());
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public ServiceException(Throwable e) {
        super(e);
        LOGGER.fine(this.getMessage());
    }

    public ServiceException(String message, String locator) {
        super(message);
        this.locator = locator;
        LOGGER.fine("> [" + this.locator + "]:\n  " + this.getMessage());
    }

    public ServiceException(Throwable e, String preMessage, String locator) {
        super(e);
        this.preMessage = preMessage;
        this.locator = locator;
    }

    public void setCode(String code) {
        this.code = code;
    }

    protected boolean isEmpty(String testString) {
        return testString == null || testString.equals("");
    }

    public String getXmlMessage(boolean printStackTrace) {
        String indent = "   ";
        StringBuffer mesg = new StringBuffer();
        if (printStackTrace) {
            mesg.append(this.createStackTrace());
        } else {
            mesg.append(this.getMessage());
        }
        return ResponseUtils.encodeXML(mesg.toString());
    }

    private String createStackTrace() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        Throwable cause = this.getCause();
        if (cause == null) {
            this.printStackTrace(writer);
        } else {
            cause.printStackTrace(writer);
        }
        writer.flush();
        return baos.toString();
    }

    public String getXmlResponse(boolean printStackTrace, HttpServletRequest request) {
        LOGGER.warning("encountered error: " + this.getMessage() + "\nStackTrace: " + this.createStackTrace());
        String indent = "   ";
        StringBuffer returnXml = new StringBuffer("<?xml version=\"1.0\" ?>\n");
        returnXml.append("<ServiceExceptionReport\n");
        returnXml.append(indent + "version=\"1.2.0\"\n");
        returnXml.append(indent + "xmlns=\"http://www.opengis.net/ogc\"\n");
        returnXml.append(indent + "xmlns:xsi=\"http://www.w3.org/2001/" + "XMLSchema-instance\"\n");
        returnXml.append(indent);
        returnXml.append("xsi:schemaLocation=\"http://www.opengis.net/ogc ");
        returnXml.append(Requests.getSchemaBaseUrl(request) + "/wfs/1.0.0/OGC-exception.xsd\">\n");
        returnXml.append(indent + "<ServiceException");
        if (!this.isEmpty(this.code)) {
            returnXml.append(" code=\"" + this.code + "\"");
        }
        if (!this.isEmpty(this.locator)) {
            returnXml.append(" locator=\"" + this.locator + "\"");
        }
        returnXml.append(">\n" + indent + indent);
        returnXml.append(this.getXmlMessage(printStackTrace));
        returnXml.append(indent + "</ServiceException>\n");
        returnXml.append("</ServiceExceptionReport>");
        LOGGER.fine("return wfs exception is " + returnXml);
        return returnXml.toString();
    }

    public String getMimeType(GeoServer geoserver) {
        return geoserver.getMimeType();
    }
}

