/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.util.Random;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Position;
import org.geolatte.geom.Positions;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.generator.Generator;

public class PositionGenerator<P extends Position>
implements Generator<P> {
    private final Envelope<P> bbox;
    private final Random rnd;

    PositionGenerator(Envelope<P> bbox, Random rnd) {
        this.bbox = bbox;
        this.rnd = rnd;
    }

    public static <P extends Position> P positionWithin(Envelope<P> bbox, Random rnd) {
        P ll = bbox.lowerLeft();
        P ur = bbox.upperRight();
        CoordinateReferenceSystem<P> crs = bbox.getCoordinateReferenceSystem();
        double[] coords = new double[crs.getCoordinateDimension()];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = ((Position)ll).getCoordinate(i) + (((Position)ur).getCoordinate(i) - ((Position)ll).getCoordinate(i)) * rnd.nextDouble();
        }
        return Positions.mkPosition(crs, coords);
    }

    public static <P extends Position> P[] nPositionsWithin(int size, Envelope<P> bbox, Random rnd) {
        Position[] ret = new Position[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = PositionGenerator.positionWithin(bbox, rnd);
        }
        return ret;
    }

    public static <P extends Position> P[] nPositionsWithinAndClosed(int size, Envelope<P> bbox, Random rnd) {
        Position[] ps = PositionGenerator.nPositionsWithin((int)size, bbox, (Random)rnd);
        ps[ps.length - 1] = ps[0];
        return ps;
    }

    @Override
    public P generate() {
        return PositionGenerator.positionWithin(this.bbox, this.rnd);
    }
}

