/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.generator.CombinedGeometryGenerator;
import org.geolatte.geom.generator.DefaultGeometryCollectionGenerator;
import org.geolatte.geom.generator.DefaultLineStringGenerator;
import org.geolatte.geom.generator.DefaultMultiLineStringGenerator;
import org.geolatte.geom.generator.DefaultMultiPointGenerator;
import org.geolatte.geom.generator.DefaultMultiPolygonGenerator;
import org.geolatte.geom.generator.DefaultPointGenerator;
import org.geolatte.geom.generator.DefaultPolygonGenerator;
import org.geolatte.geom.generator.Generator;

public class GeometryGenerators {
    public static <P extends Position> Generator<Geometry<P>> combine(Random rnd, List<Generator<? extends Geometry<P>>> generators) {
        return new CombinedGeometryGenerator(rnd, generators);
    }

    public static <P extends Position> Generator<Geometry<P>> combine(List<Generator<? extends Geometry<P>>> generators) {
        return new CombinedGeometryGenerator(new Random(), generators);
    }

    public static <P extends Position> Generator<Point<P>> point(Envelope<P> bbox) {
        return new DefaultPointGenerator<P>(bbox, new Random());
    }

    public static <P extends Position> Generator<Point<P>> point(Envelope<P> bbox, Random rnd) {
        return new DefaultPointGenerator<P>(bbox, rnd);
    }

    public static <P extends Position> Generator<LineString<P>> lineString(int numPnts, Envelope<P> bbox, Random rnd) {
        return new DefaultLineStringGenerator<P>(numPnts, false, bbox, rnd);
    }

    public static <P extends Position> Generator<LineString<P>> lineString(int numPnts, Envelope<P> bbox) {
        return new DefaultLineStringGenerator<P>(numPnts, false, bbox, new Random());
    }

    public static <P extends Position> Generator<Polygon<P>> polygon(int numPnts, Envelope<P> bbox, Random rnd) {
        return new DefaultPolygonGenerator<P>(numPnts, bbox, rnd);
    }

    public static <P extends Position> Generator<Polygon<P>> polygon(int numPnts, Envelope<P> bbox) {
        return new DefaultPolygonGenerator<P>(numPnts, bbox, new Random());
    }

    public static <P extends Position> Generator<MultiPoint<P>> multiPoint(int numPnts, Envelope<P> bbox, Random rnd) {
        return new DefaultMultiPointGenerator<P>(numPnts, bbox, rnd);
    }

    public static <P extends Position> Generator<MultiPoint<P>> multiPoint(int numPnts, Envelope<P> bbox) {
        return new DefaultMultiPointGenerator<P>(numPnts, bbox, new Random());
    }

    public static <P extends Position> Generator<MultiLineString<P>> multiLineString(int numLines, int numPoints, Envelope<P> bbox, Random rnd) {
        return new DefaultMultiLineStringGenerator<P>(numLines, numPoints, bbox, rnd);
    }

    public static <P extends Position> Generator<MultiLineString<P>> multiLineString(int numLines, int numPoints, Envelope<P> bbox) {
        return new DefaultMultiLineStringGenerator<P>(numLines, numPoints, bbox, new Random());
    }

    public static <P extends Position> Generator<MultiPolygon<P>> multiPolygon(int numLines, int numPoints, Envelope<P> bbox, Random rnd) {
        return new DefaultMultiPolygonGenerator<P>(numLines, numPoints, bbox, rnd);
    }

    public static <P extends Position> Generator<MultiPolygon<P>> multiPolygon(int numLines, int numPoints, Envelope<P> bbox) {
        return new DefaultMultiPolygonGenerator<P>(numLines, numPoints, bbox, new Random());
    }

    @SafeVarargs
    public static <P extends Position> Generator<GeometryCollection<P>> geometryCollection(int numGeoms, Random rnd, Generator<? extends Geometry<P>> ... generators) {
        Generator<Geometry<P>> combine = GeometryGenerators.combine(Arrays.asList(generators));
        return new DefaultGeometryCollectionGenerator<P>(numGeoms, combine, rnd);
    }

    @SafeVarargs
    public static <P extends Position> Generator<GeometryCollection<P>> geometryCollection(int numGeoms, Generator<? extends Geometry<P>> ... generators) {
        return GeometryGenerators.geometryCollection(numGeoms, new Random(), generators);
    }
}

