/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.util.Random;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.builder.DSL;
import org.geolatte.geom.generator.AbstractGeometryGenerator;
import org.geolatte.geom.generator.DefaultPolygonGenerator;

class DefaultMultiPolygonGenerator<P extends Position>
extends AbstractGeometryGenerator<P, MultiPolygon<P>> {
    private final int numPolys;
    private final DefaultPolygonGenerator<P> polyGen;

    DefaultMultiPolygonGenerator(int numPolys, int numPoints, Envelope<P> bbox, Random rnd) {
        super(bbox, rnd);
        this.numPolys = numPolys;
        this.polyGen = new DefaultPolygonGenerator<P>(numPoints, bbox, rnd);
    }

    @Override
    public MultiPolygon<P> generate() {
        Polygon[] polys = new Polygon[this.numPolys - 1];
        this.polyGen.generateArray(polys);
        return DSL.multipolygon(this.polyGen.generate(), polys);
    }
}

