/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.util.Random;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.Point;
import org.geolatte.geom.Position;
import org.geolatte.geom.builder.DSL;
import org.geolatte.geom.generator.AbstractGeometryGenerator;
import org.geolatte.geom.generator.DefaultPointGenerator;
import org.geolatte.geom.generator.Generator;

class DefaultMultiPointGenerator<P extends Position>
extends AbstractGeometryGenerator<P, MultiPoint<P>> {
    private final Generator<Point<P>> pntGen;
    private final int numPnts;

    DefaultMultiPointGenerator(int numPnts, Envelope<P> bbox, Random rnd) {
        super(bbox, rnd);
        this.numPnts = numPnts;
        this.pntGen = new DefaultPointGenerator<P>(bbox, rnd);
    }

    @Override
    public MultiPoint<P> generate() {
        Point[] points = new Point[this.numPnts - 1];
        this.pntGen.generateArray(points);
        return DSL.multipoint(this.pntGen.generate(), points);
    }
}

