/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.util.Random;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.Position;
import org.geolatte.geom.builder.DSL;
import org.geolatte.geom.generator.AbstractGeometryGenerator;
import org.geolatte.geom.generator.DefaultLineStringGenerator;

class DefaultMultiLineStringGenerator<P extends Position>
extends AbstractGeometryGenerator<P, MultiLineString<P>> {
    private final int numLineString;
    private final DefaultLineStringGenerator<P> lineStrGen;

    DefaultMultiLineStringGenerator(int numLineString, int numPoints, Envelope<P> bbox, Random rnd) {
        super(bbox, rnd);
        this.numLineString = numLineString;
        this.lineStrGen = new DefaultLineStringGenerator<P>(numPoints, false, bbox, rnd);
    }

    @Override
    public MultiLineString<P> generate() {
        LineString[] linestrings = new LineString[this.numLineString - 1];
        this.lineStrGen.generateArray(linestrings);
        return DSL.multilinestring(this.lineStrGen.generate(), linestrings);
    }
}

