/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.util.Random;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.LineString;
import org.geolatte.geom.Position;
import org.geolatte.geom.builder.DSL;
import org.geolatte.geom.generator.AbstractGeometryGenerator;
import org.geolatte.geom.generator.PositionGenerator;

class DefaultLineStringGenerator<P extends Position>
extends AbstractGeometryGenerator<P, LineString<P>> {
    private final int size;
    private final boolean closed;

    DefaultLineStringGenerator(int size, boolean closed, Envelope<P> bbox, Random rnd) {
        super(bbox, rnd);
        this.size = size;
        this.closed = false;
    }

    @Override
    public LineString<P> generate() {
        Position[] ps = PositionGenerator.nPositionsWithin((int)this.size, (Envelope)this.bbox, (Random)this.rnd);
        if (this.closed) {
            ps[ps.length - 1] = ps[0];
        }
        return DSL.linestring(this.crs(), (Position[])ps);
    }
}

