/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.Point;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDOEncoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;

public class SdoMultiPointEncoder
extends AbstractSDOEncoder {
    @Override
    public <P extends Position> boolean accepts(Geometry<P> geom) {
        return GeometryType.MULTIPOINT.equals((Object)geom.getGeometryType());
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SDOGeometry encode(G geom) {
        int dim = geom.getCoordinateDimension();
        int lrsDim = this.getLRSDim(geom);
        boolean isLrs = lrsDim != 0;
        MultiPoint multiPoint = (MultiPoint)geom;
        ElemInfo info = new ElemInfo(multiPoint.getNumGeometries());
        int oordinatesOffset = 1;
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
            info.setElement(i, oordinatesOffset, ElementType.POINT, 0);
            ordinates = this.addOrdinates(ordinates, this.pointToOrdinates(multiPoint, i));
            oordinatesOffset = ordinates.length + 1;
        }
        return new SDOGeometry(new SDOGType(dim, lrsDim, TypeGeometry.MULTIPOINT), geom.getSRID(), null, info, new Ordinates(ordinates));
    }

    private Double[] pointToOrdinates(MultiPoint<?> multiPoint, int i) {
        Double[] pointOrdinates = new Double[multiPoint.getCoordinateDimension()];
        int idx = 0;
        double[] dArray = ((Position)((Point)multiPoint.getGeometryN(i)).getPosition()).toArray(null);
        int n = dArray.length;
        for (int j = 0; j < n; ++j) {
            Double d = dArray[j];
            pointOrdinates[idx++] = d;
        }
        return pointOrdinates;
    }
}

