/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import org.geolatte.geom.codec.db.oracle.CompoundIElemInfoTriplet;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.ElemInfoTriplet;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOPoint;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;

public class SDOGeometry {
    private static final String SQL_TYPE_NAME = "MDSYS.SDO_GEOMETRY";
    private static final String SQL_POINT_TYPE_NAME = "MDSYS.SDO_POINT_TYPE";
    private final SDOGType gtype;
    private final int srid;
    private final SDOPoint point;
    private final ElemInfo info;
    private final Ordinates ordinates;

    public SDOGeometry(SDOGType gtype, int srid, SDOPoint point, ElemInfo info, Ordinates ordinates) {
        this.gtype = gtype;
        this.srid = srid;
        this.point = point;
        this.info = info;
        this.ordinates = ordinates;
    }

    public static String getTypeName() {
        return SQL_TYPE_NAME;
    }

    public static String getPointTypeName() {
        return SQL_POINT_TYPE_NAME;
    }

    static String arrayToString(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return "()";
        }
        int length = Array.getLength(array);
        StringBuilder stb = new StringBuilder();
        stb.append("(").append(Array.get(array, 0));
        for (int i = 1; i < length; ++i) {
            stb.append(",").append(Array.get(array, i));
        }
        stb.append(")");
        return stb.toString();
    }

    static void shiftOrdinateOffset(ElemInfo elemInfo, int offset) {
        for (int i = 0; i < elemInfo.getSize(); ++i) {
            int newOffset = elemInfo.getOrdinatesOffset(i) + offset;
            elemInfo.setOrdinatesOffset(i, newOffset);
        }
    }

    public static SDOGeometry load(Struct struct) {
        Object[] data;
        try {
            data = struct.getAttributes();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new SDOGeometry(SDOGType.parse(data[0]), SDOGeometry.parseSRID(data[1]), data[2] == null ? null : new SDOPoint((Struct)data[2]), new ElemInfo((java.sql.Array)data[3]), new Ordinates((java.sql.Array)data[4]));
    }

    public ElemInfo getInfo() {
        return this.info;
    }

    public SDOGType getGType() {
        return this.gtype;
    }

    public Ordinates getOrdinates() {
        return this.ordinates;
    }

    public SDOPoint getPoint() {
        return this.point;
    }

    public int getSRID() {
        return this.srid;
    }

    private static int parseSRID(Object datum) {
        if (datum == null) {
            return 0;
        }
        try {
            return ((Number)datum).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLRSGeometry() {
        return this.gtype.isLRSGeometry();
    }

    public int getDimension() {
        return this.gtype.getDimension();
    }

    public int getLRSDimension() {
        return this.gtype.getLRSDimension();
    }

    public int getZDimension() {
        return this.gtype.getZDimension();
    }

    public int getNumElements() {
        int cnt = 0;
        int i = 0;
        while (i < this.info.getSize()) {
            if (this.info.getElementType(i).isCompound()) {
                int numCompounds = this.info.getNumCompounds(i);
                i += 1 + numCompounds;
            } else {
                ++i;
            }
            ++cnt;
        }
        return cnt;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        stb.append("(").append(this.gtype).append(",").append(this.srid).append(",").append(this.point).append(",").append(this.info).append(",").append(this.ordinates).append(")");
        return stb.toString();
    }

    public SDOGeometry[] getElementGeometries() {
        if (this.getGType().getTypeGeometry() == TypeGeometry.COLLECTION) {
            ArrayList<SDOGeometry> elements = new ArrayList<SDOGeometry>();
            int i = 0;
            ElemInfoTriplet[] elemInfos = this.info.interpret();
            while (i < this.getNumElements()) {
                ElemInfoTriplet elemInfo = elemInfos[i];
                ElementType et = elemInfo.getElementType();
                int next = this.findNextGeometryElemInfo(i, elemInfos, elemInfo, et);
                SDOGType elemGtype = SDOGType.derive(et, this);
                ElemInfo outElemInfo = this.buildElemInfo(elemInfos, i, next);
                Ordinates elemOrdinates = this.buildOrdinates(elemInfos, i, next);
                SDOGeometry elemGeom = new SDOGeometry(elemGtype, this.getSRID(), null, outElemInfo, elemOrdinates);
                elements.add(elemGeom);
                i = next;
            }
            return elements.toArray(new SDOGeometry[elements.size()]);
        }
        return new SDOGeometry[]{this};
    }

    private Ordinates buildOrdinates(ElemInfoTriplet[] elemInfos, int start, int next) {
        Double[] ordinateArray = this.ordinates.getOrdinateArray();
        int srcPos = elemInfos[start].getStartingOffset();
        int length = next < elemInfos.length ? elemInfos[next].getStartingOffset() - srcPos : ordinateArray.length + 1 - srcPos;
        Double[] out = new Double[length];
        System.arraycopy(ordinateArray, srcPos - 1, out, 0, length);
        return new Ordinates(out);
    }

    private ElemInfo buildElemInfo(ElemInfoTriplet[] elemInfos, int start, int next) {
        ArrayList<BigDecimal> out = new ArrayList<BigDecimal>(3 * (next - start));
        int startingOffset = elemInfos[start].getStartingOffset();
        for (int idx = start; idx < next; ++idx) {
            ElemInfoTriplet adjusted = elemInfos[idx].shiftStartingOffset(-startingOffset + 1);
            adjusted.addTo(out);
        }
        return new ElemInfo(out.toArray(new BigDecimal[0]));
    }

    private int findNextGeometryElemInfo(int i, ElemInfoTriplet[] elemInfos, ElemInfoTriplet elemInfo, ElementType et) {
        int next;
        if (et.isExteriorRing()) {
            for (next = i + 1; next < elemInfos.length && elemInfos[next].getElementType().isInteriorRing(); ++next) {
            }
        } else if (elemInfo.isCompound()) {
            next = i + ((CompoundIElemInfoTriplet)elemInfo).numParts() + 1;
        }
        return next;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SDOGeometry that = (SDOGeometry)o;
        if (this.srid != that.srid) {
            return false;
        }
        if (this.gtype != null ? !this.gtype.equals(that.gtype) : that.gtype != null) {
            return false;
        }
        if (this.info != null ? !this.info.equals(that.info) : that.info != null) {
            return false;
        }
        if (this.ordinates != null ? !this.ordinates.equals(that.ordinates) : that.ordinates != null) {
            return false;
        }
        return !(this.point != null ? !this.point.equals(that.point) : that.point != null);
    }

    public int hashCode() {
        int result = this.gtype != null ? this.gtype.hashCode() : 0;
        result = 31 * result + this.srid;
        result = 31 * result + (this.point != null ? this.point.hashCode() : 0);
        result = 31 * result + (this.info != null ? this.info.hashCode() : 0);
        result = 31 * result + (this.ordinates != null ? this.ordinates.hashCode() : 0);
        return result;
    }
}

