/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import org.geolatte.geom.codec.db.oracle.ConnectionFinder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SDOPoint;
import org.geolatte.geom.codec.db.oracle.SQLTypeFactory;

public class OracleJDBCTypeFactory
implements SQLTypeFactory {
    private final Class<?> datumClass;
    private final Method structDescriptorCreator;
    private final Method arrayDescriptorCreator;
    private final Constructor<?> numberConstructor;
    private final Constructor<?> doubleConstructor;
    private final Constructor<?> arrayConstructor;
    private final Constructor<?> structConstructor;
    private final ConnectionFinder connectionFinder;

    public OracleJDBCTypeFactory(ConnectionFinder connectionFinder) {
        this.connectionFinder = connectionFinder;
        Object[] obj = this.findDescriptorCreator("oracle.sql.StructDescriptor");
        Class structDescriptorClass = (Class)obj[0];
        this.structDescriptorCreator = (Method)obj[1];
        obj = this.findDescriptorCreator("oracle.sql.ArrayDescriptor");
        Class arrayDescriptorClass = (Class)obj[0];
        this.arrayDescriptorCreator = (Method)obj[1];
        this.datumClass = this.findClass("oracle.sql.Datum");
        Class<?> numberClass = this.findClass("oracle.sql.NUMBER");
        Class<?> arrayClass = this.findClass("oracle.sql.ARRAY");
        Class<?> structClass = this.findClass("oracle.sql.STRUCT");
        this.numberConstructor = this.findConstructor(numberClass, Integer.TYPE);
        this.doubleConstructor = this.findConstructor(numberClass, Double.TYPE);
        this.arrayConstructor = this.findConstructor(arrayClass, arrayDescriptorClass, Connection.class, Object.class);
        this.structConstructor = this.findConstructor(structClass, structDescriptorClass, Connection.class, Object[].class);
    }

    private Class<?> findClass(String name) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(name);
            }
        }
        catch (Throwable classLoader) {
            // empty catch block
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't load class " + name);
        }
    }

    private Constructor<?> findConstructor(Class clazz, Class<?> ... arguments) {
        try {
            return clazz.getConstructor(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error finding constructor for oracle.sql type.", e);
        }
    }

    private Object[] findDescriptorCreator(String className) {
        try {
            Class<?> clazz = this.findClass(className);
            Method m = clazz.getMethod("createDescriptor", String.class, Connection.class);
            return new Object[]{clazz, m};
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class 'StructDescriptor' has no method 'createDescriptor(String,Connection)'");
        }
    }

    @Override
    public Struct createStruct(SDOGeometry geom, Connection conn) throws SQLException {
        Connection oracleConnection = this.connectionFinder.find(conn);
        Object structDescriptor = this.createStructDescriptor(SDOGeometry.getTypeName(), oracleConnection);
        Object[] attributes = this.createDatumArray(5);
        attributes[0] = this.createInteger(geom.getGType().intValue());
        attributes[1] = geom.getSRID() > 0 ? this.createInteger(geom.getSRID()) : null;
        if (geom.getPoint() != null) {
            Object pointStructDescriptor = this.createStructDescriptor(SDOGeometry.getPointTypeName(), oracleConnection);
            Object[] pointAttributes = this.createDatumArray(3);
            SDOPoint sdoPnt = geom.getPoint();
            pointAttributes[0] = this.createDouble(sdoPnt.x);
            pointAttributes[1] = this.createDouble(sdoPnt.y);
            pointAttributes[2] = this.createDouble(sdoPnt.z);
            attributes[2] = this.createStruct(pointStructDescriptor, oracleConnection, pointAttributes);
        } else {
            attributes[3] = this.createElemInfoArray(geom.getInfo(), oracleConnection);
            attributes[4] = this.createOrdinatesArray(geom.getOrdinates(), oracleConnection);
        }
        return this.createStruct(structDescriptor, oracleConnection, attributes);
    }

    @Override
    public java.sql.Array createElemInfoArray(ElemInfo elemInfo, Connection conn) {
        Object arrayDescriptor = this.createArrayDescriptor("MDSYS.SDO_ELEM_INFO_ARRAY", conn);
        return this.createArray(arrayDescriptor, conn, elemInfo.getElements());
    }

    @Override
    public java.sql.Array createOrdinatesArray(Ordinates ordinates, Connection conn) throws SQLException {
        Object arrayDescriptor = this.createArrayDescriptor("MDSYS.SDO_ORDINATE_ARRAY", conn);
        return this.createArray(arrayDescriptor, conn, ordinates.getOrdinateArray());
    }

    private java.sql.Array createArray(Object descriptor, Connection conn, Object[] data) {
        try {
            return (java.sql.Array)this.arrayConstructor.newInstance(descriptor, conn, data);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Problem creating ARRAY.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Problem creating ARRAY.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Problem creating ARRAY.", e);
        }
    }

    private Struct createStruct(Object descriptor, Connection conn, Object[] attributes) {
        try {
            return (Struct)this.structConstructor.newInstance(descriptor, conn, attributes);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Problem creating STRUCT.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Problem creating STRUCT.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Problem creating STRUCT.", e);
        }
    }

    private Object createStructDescriptor(String sqlType, Connection conn) {
        try {
            return this.structDescriptorCreator.invoke(null, sqlType, conn);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error creating oracle STRUCT", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error creating oracle STRUCT", e);
        }
    }

    private Object createArrayDescriptor(String name, Connection conn) {
        try {
            return this.arrayDescriptorCreator.invoke(null, name, conn);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error creating oracle ARRAY", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error creating oracle ARRAY", e);
        }
    }

    private Object[] createDatumArray(int size) {
        return (Object[])Array.newInstance(this.datumClass, size);
    }

    private Object createInteger(int obj) {
        try {
            return this.numberConstructor.newInstance(obj);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error creating oracle NUMBER", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error creating oracle NUMBER", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error creating oracle NUMBER", e);
        }
    }

    private Object createDouble(Double obj) {
        try {
            return obj == null ? null : this.doubleConstructor.newInstance(obj);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error creating oracle NUMBER", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error creating oracle NUMBER", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error creating oracle NUMBER", e);
        }
    }
}

