/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

enum ElementType {
    UNSUPPORTED(0, true),
    POINT(1, 1),
    ORIENTATION(1, 0),
    POINT_CLUSTER(1, false),
    LINE_STRAITH_SEGMENTS(2, 1),
    LINE_ARC_SEGMENTS(2, 2),
    INTERIOR_RING_STRAIGHT_SEGMENTS(2003, 1),
    PLAIN_OLD_EXTERIOR_RING_STRAIGHT_SEGMENTS(3, 1),
    PLAIN_OLD_COMPOUND_EXTERIOR_RING(5, true),
    EXTERIOR_RING_STRAIGHT_SEGMENTS(1003, 1),
    INTERIOR_RING_ARC_SEGMENTS(2003, 2),
    EXTERIOR_RING_ARC_SEGMENTS(1003, 2),
    INTERIOR_RING_RECT(2003, 3),
    EXTERIOR_RING_RECT(1003, 3),
    INTERIOR_RING_CIRCLE(2003, 4),
    EXTERIOR_RING_CIRCLE(1003, 4),
    COMPOUND_LINE(4, true),
    COMPOUND_EXTERIOR_RING(1005, true),
    COMPOUND_INTERIOR_RING(2005, true);

    private int etype;
    private int interpretation = 2;
    private boolean compound;

    private ElementType(int etype, int interp) {
        this.etype = etype;
        this.interpretation = interp;
    }

    private ElementType(int etype, boolean compound) {
        this.etype = etype;
        this.compound = compound;
    }

    public int getEType() {
        return this.etype;
    }

    public int getInterpretation() {
        return this.interpretation;
    }

    public boolean isCompound() {
        return this.compound;
    }

    public boolean isLine() {
        return this.etype == 2 || this.etype == 4;
    }

    public boolean isInteriorRing() {
        return this.etype == 2003 || this.etype == 2005;
    }

    public boolean isExteriorRing() {
        return this.etype == 1003 || this.etype == 1005;
    }

    public boolean isStraightSegment() {
        return this.interpretation == 1;
    }

    public boolean isArcSegment() {
        return this.interpretation == 2;
    }

    public boolean isCircle() {
        return this.interpretation == 4;
    }

    public boolean isRect() {
        return this.interpretation == 3;
    }

    public static ElementType parseType(int etype, int interpretation) {
        for (ElementType t : ElementType.values()) {
            if (t.etype != etype || !t.isCompound() && t.getInterpretation() != interpretation) continue;
            return t;
        }
        throw new RuntimeException("Can't determine ElementType from etype:" + etype + " and interp.:" + interpretation);
    }
}

