/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.AbstractWkbDecoder;
import org.geolatte.geom.codec.WkbDecodeException;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CoordinateSystemExpander;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.crs.DefaultCoordinateSystemExpander;

class PostgisWkbDecoder
extends AbstractWkbDecoder {
    private CoordinateSystemExpander expander = new DefaultCoordinateSystemExpander();

    PostgisWkbDecoder() {
    }

    @Override
    protected void prepare(ByteBuffer byteBuffer) {
    }

    @Override
    protected <P extends Position> CoordinateReferenceSystem<P> readCrs(ByteBuffer byteBuffer, int typeCode, CoordinateReferenceSystem<P> crs) {
        CoordinateReferenceSystem crsDeclared;
        boolean hasZ;
        boolean hasM = (typeCode & 0x40000000) == 0x40000000;
        boolean bl = hasZ = (typeCode & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (crs != null) {
            this.validateCrs(crs, hasM, hasZ);
            return crs;
        }
        if (this.hasSrid(typeCode)) {
            int srid = byteBuffer.getInt();
            crsDeclared = CrsRegistry.getCoordinateReferenceSystemForEPSG(srid, CoordinateReferenceSystems.PROJECTED_2D_METER);
        } else {
            crsDeclared = CoordinateReferenceSystems.PROJECTED_2D_METER;
        }
        if (hasM) {
            crsDeclared = this.expander.expandM(crsDeclared);
        }
        if (hasZ) {
            crsDeclared = this.expander.expandZ(crsDeclared);
        }
        return crsDeclared;
    }

    private void validateCrs(CoordinateReferenceSystem<?> crs, boolean hasM, boolean hasZ) {
        if (hasM && !CoordinateReferenceSystems.hasMeasureAxis(crs) || hasZ && !CoordinateReferenceSystems.hasVerticalAxis(crs)) {
            throw new WkbDecodeException("WKB inconsistent with specified Coordinate Reference System");
        }
    }

    @Override
    protected boolean hasSrid(int typeCode) {
        return (typeCode & 0x20000000) == 0x20000000;
    }
}

