/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.HANAWktVariant;
import org.geolatte.geom.codec.PostgisWktEncoder;
import org.geolatte.geom.codec.PostgisWktVariant;
import org.geolatte.geom.crs.CrsId;

class HANAWktEncoder
extends PostgisWktEncoder {
    private static final HANAWktVariant WKT_WORDS = new HANAWktVariant();

    HANAWktEncoder() {
    }

    @Override
    public <P extends Position> String encode(Geometry<P> geometry) {
        String wkt = super.encode(geometry);
        if (wkt == null) {
            return null;
        }
        if (!wkt.startsWith("SRID=")) {
            StringBuilder sb = new StringBuilder(wkt.length() + 16);
            sb.append("SRID=");
            if (geometry.getSRID() == CrsId.UNDEFINED.getCode()) {
                sb.append(0);
            } else {
                sb.append(geometry.getSRID());
            }
            sb.append(";");
            sb.append(wkt);
            wkt = sb.toString();
        }
        return wkt;
    }

    @Override
    protected PostgisWktVariant getWktWords() {
        return WKT_WORDS;
    }
}

