/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.BufferAccessException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.codec.WkbDecodeException;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbGeometryType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

abstract class AbstractWkbDecoder
implements WkbDecoder {
    AbstractWkbDecoder() {
    }

    @Override
    public <P extends Position> Geometry<P> decode(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        byteBuffer.rewind();
        try {
            this.prepare(byteBuffer);
            Geometry<P> geom = this.decodeGeometry(byteBuffer, crs);
            byteBuffer.rewind();
            return geom;
        }
        catch (BufferAccessException e) {
            throw new WkbDecodeException(e);
        }
    }

    @Override
    public Geometry<?> decode(ByteBuffer byteBuffer) {
        return this.decode(byteBuffer, null);
    }

    private <P extends Position> Geometry<P> decodeGeometry(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        this.alignByteOrder(byteBuffer);
        int typeCode = this.readTypeCode(byteBuffer);
        WkbGeometryType wkbType = WkbGeometryType.parse((byte)typeCode);
        crs = this.readCrs(byteBuffer, typeCode, crs);
        switch (wkbType) {
            case POINT: {
                return this.decodePoint(byteBuffer, crs);
            }
            case LINE_STRING: {
                return this.decodeLineString(byteBuffer, crs);
            }
            case POLYGON: {
                return this.decodePolygon(byteBuffer, crs);
            }
            case GEOMETRY_COLLECTION: {
                return this.decodeGeometryCollection(byteBuffer, crs);
            }
            case MULTI_POINT: {
                return this.decodeMultiPoint(byteBuffer, crs);
            }
            case MULTI_POLYGON: {
                return this.decodeMultiPolygon(byteBuffer, crs);
            }
            case MULTI_LINE_STRING: {
                return this.decodeMultiLineString(byteBuffer, crs);
            }
        }
        throw new WkbDecodeException(String.format("WKBType %s is not supported.", new Object[]{wkbType}));
    }

    private <P extends Position> MultiLineString<P> decodeMultiLineString(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        int numGeometries = byteBuffer.getInt();
        if (numGeometries == 0) {
            return new MultiLineString<P>(crs);
        }
        ArrayList geometries = new ArrayList(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            geometries.add((LineString)this.decodeGeometry(byteBuffer, crs));
        }
        return Geometries.mkMultiLineString(geometries);
    }

    private <P extends Position> MultiPoint<P> decodeMultiPoint(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        int numGeometries = byteBuffer.getInt();
        if (numGeometries == 0) {
            return new MultiPoint<P>(crs);
        }
        ArrayList geometries = new ArrayList(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            geometries.add((Point)this.decodeGeometry(byteBuffer, crs));
        }
        return Geometries.mkMultiPoint(geometries);
    }

    private <P extends Position> MultiPolygon<P> decodeMultiPolygon(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        int numGeometries = byteBuffer.getInt();
        if (numGeometries == 0) {
            return new MultiPolygon<P>(crs);
        }
        ArrayList geometries = new ArrayList(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            geometries.add((Polygon)this.decodeGeometry(byteBuffer, crs));
        }
        return Geometries.mkMultiPolygon(geometries);
    }

    private <P extends Position> AbstractGeometryCollection<P, Geometry<P>> decodeGeometryCollection(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        int numGeometries = byteBuffer.getInt();
        if (numGeometries == 0) {
            return new GeometryCollection<P>(crs);
        }
        ArrayList geometries = new ArrayList(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            geometries.add(this.decodeGeometry(byteBuffer, crs));
        }
        return Geometries.mkGeometryCollection(geometries);
    }

    private <P extends Position> Polygon<P> decodePolygon(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        int numRings = byteBuffer.getInt();
        List<LinearRing<P>> rings = this.readPolygonRings(numRings, byteBuffer, crs);
        return Geometries.mkPolygon(rings);
    }

    private <P extends Position> LineString<P> decodeLineString(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        int numPoints = byteBuffer.getInt();
        PositionSequence<P> points = this.readPositions(numPoints, byteBuffer, crs);
        return new LineString<P>(points, crs);
    }

    private <P extends Position> Point<P> decodePoint(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        PositionSequence<P> points = this.readPositions(1, byteBuffer, crs);
        return new Point<PositionSequence<P>>(points, crs);
    }

    private <P extends Position> PositionSequence<P> readPositions(int numPos, ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        PositionSequenceBuilder<double[]> psBuilder = PositionSequenceBuilders.fixedSized(numPos, crs.getPositionClass());
        double[] coordinates = new double[crs.getCoordinateDimension()];
        for (int i = 0; i < numPos; ++i) {
            this.readPosition(byteBuffer, coordinates, crs);
            psBuilder.add(coordinates);
        }
        return psBuilder.toPositionSequence();
    }

    private <P extends Position> void readPosition(ByteBuffer byteBuffer, double[] coordinates, CoordinateReferenceSystem<P> crs) {
        for (int ci = 0; ci < crs.getCoordinateDimension(); ++ci) {
            coordinates[ci] = byteBuffer.getDouble();
        }
    }

    private <P extends Position> List<LinearRing<P>> readPolygonRings(int numRings, ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        ArrayList<LinearRing<P>> rings = new ArrayList<LinearRing<P>>(numRings);
        for (int i = 0; i < numRings; ++i) {
            rings.add(this.readRing(byteBuffer, crs));
        }
        return rings;
    }

    private <P extends Position> LinearRing<P> readRing(ByteBuffer byteBuffer, CoordinateReferenceSystem<P> crs) {
        int numPoints = byteBuffer.getInt();
        PositionSequence<P> ps = this.readPositions(numPoints, byteBuffer, crs);
        try {
            return new LinearRing<P>(ps, crs);
        }
        catch (IllegalArgumentException e) {
            throw new WkbDecodeException(e);
        }
    }

    protected abstract void prepare(ByteBuffer var1);

    protected abstract <P extends Position> CoordinateReferenceSystem<P> readCrs(ByteBuffer var1, int var2, CoordinateReferenceSystem<P> var3);

    protected abstract boolean hasSrid(int var1);

    protected int readTypeCode(ByteBuffer byteBuffer) {
        return (int)byteBuffer.getUInt();
    }

    private void alignByteOrder(ByteBuffer byteBuffer) {
        byte orderByte = byteBuffer.get();
        ByteOrder byteOrder = ByteOrder.valueOf(orderByte);
        byteBuffer.setByteOrder(byteOrder);
    }
}

