/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import org.geolatte.geom.BufferAccessException;
import org.geolatte.geom.ByteOrder;

public class ByteBuffer {
    public static final int UINT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;
    public static final long UINT_MAX_VALUE = 0xFFFFFFFFL;
    private final java.nio.ByteBuffer buffer;

    private ByteBuffer(java.nio.ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public static ByteBuffer from(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException("Cannot create ByteBuffer from null input String.");
        }
        int size = hexString.length() / 2;
        java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(size);
        for (int i = 0; i < size * 2; i += 2) {
            byte secondDigit;
            byte firstDigit;
            char firstLetterOrNumber = hexString.charAt(i);
            char secondLetterOrNumber = hexString.charAt(i + 1);
            if (firstLetterOrNumber == '+') {
                firstDigit = 0;
                secondDigit = ByteBuffer.charToHex(secondLetterOrNumber);
            } else if (firstLetterOrNumber == '-') {
                firstDigit = 0;
                secondDigit = -ByteBuffer.charToHex(secondLetterOrNumber);
            } else {
                firstDigit = ByteBuffer.charToHex(firstLetterOrNumber);
                secondDigit = ByteBuffer.charToHex(secondLetterOrNumber);
            }
            byte b = (byte)(firstDigit << 4 | secondDigit);
            buffer.put(b);
        }
        buffer.rewind();
        return new ByteBuffer(buffer);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int savedPosition = this.buffer.position();
        this.rewind();
        for (int i = 0; i < this.limit(); ++i) {
            int hexValue = this.readByte();
            this.appendHexByteRepresentation(builder, hexValue);
        }
        this.buffer.position(savedPosition);
        return builder.toString();
    }

    private void appendHexByteRepresentation(StringBuilder builder, int hexValue) {
        String byteStr = Integer.toHexString(hexValue).toUpperCase();
        if (byteStr.length() == 1) {
            builder.append("0").append(byteStr);
        } else {
            builder.append(byteStr);
        }
    }

    private int readByte() {
        int hexValue = this.get();
        hexValue = hexValue << 24 >>> 24;
        return hexValue;
    }

    public static ByteBuffer from(byte[] bytes) {
        java.nio.ByteBuffer buffer = java.nio.ByteBuffer.wrap(bytes);
        return new ByteBuffer(buffer);
    }

    public static ByteBuffer allocate(int capacity) {
        return new ByteBuffer(java.nio.ByteBuffer.allocate(capacity));
    }

    public byte get() {
        try {
            return this.buffer.get();
        }
        catch (BufferOverflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public void put(byte value) {
        try {
            this.buffer.put(value);
        }
        catch (BufferOverflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int limit() {
        return this.buffer.limit();
    }

    public void rewind() {
        this.buffer.rewind();
    }

    public boolean isEmpty() {
        return this.buffer.limit() == 0;
    }

    public void setByteOrder(ByteOrder wbo) {
        this.buffer.order(wbo.getByteOrder());
    }

    public int getInt() {
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public void putInt(int value) {
        try {
            this.buffer.putInt(value);
        }
        catch (BufferOverflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public long getLong() {
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public void putLong(long value) {
        try {
            this.buffer.putLong(value);
        }
        catch (BufferOverflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public float getFloat() {
        try {
            return this.buffer.getFloat();
        }
        catch (BufferUnderflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public void putFloat(float value) {
        try {
            this.buffer.putFloat(value);
        }
        catch (BufferOverflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public double getDouble() {
        try {
            return this.buffer.getDouble();
        }
        catch (BufferUnderflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public void putDouble(Double value) {
        try {
            this.buffer.putDouble(value);
        }
        catch (BufferOverflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public long getUInt() {
        try {
            int signedInt = this.buffer.getInt();
            return (long)signedInt & 0xFFFFFFFFL;
        }
        catch (BufferUnderflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public void putUInt(long value) {
        if (value > 0xFFFFFFFFL) {
            throw new RuntimeException("Value received doesn't fit in unsigned integer");
        }
        try {
            this.buffer.putInt((int)value);
        }
        catch (BufferOverflowException e) {
            throw new BufferAccessException(e.getMessage());
        }
    }

    public ByteOrder getByteOrder() {
        java.nio.ByteOrder order = this.buffer.order();
        return ByteOrder.valueOf(order);
    }

    public byte[] toByteArray() {
        return this.buffer.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteBuffer that = (ByteBuffer)o;
        return !(this.buffer != null ? !this.buffer.equals(that.buffer) : that.buffer != null);
    }

    public int hashCode() {
        return this.buffer != null ? this.buffer.hashCode() : 0;
    }

    public boolean hasSameContent(ByteBuffer other) {
        if (other == null) {
            return false;
        }
        if (this.limit() != other.limit()) {
            return false;
        }
        int thisSavedPosition = this.buffer.position();
        int otherSavedPosition = other.buffer.position();
        this.rewind();
        other.rewind();
        for (int i = 0; i < this.limit(); ++i) {
            if (this.get() == other.get()) continue;
            return false;
        }
        this.buffer.position(thisSavedPosition);
        other.buffer.position(otherSavedPosition);
        return true;
    }

    private static byte charToHex(int letterOrNumber) {
        if (letterOrNumber <= 57) {
            int number = letterOrNumber - 48;
            if (number < 0) {
                throw ByteBuffer.numberFormatException(letterOrNumber);
            }
            return (byte)number;
        }
        int letterCaseInsensitive = letterOrNumber & 0xFFFFFFDF;
        if (letterCaseInsensitive <= 70) {
            int number = letterCaseInsensitive - 65 + 10;
            if (number < 10) {
                throw ByteBuffer.numberFormatException(letterOrNumber);
            }
            return (byte)number;
        }
        throw ByteBuffer.numberFormatException(letterOrNumber);
    }

    private static NumberFormatException numberFormatException(int letterOrNumber) {
        return new NumberFormatException((char)letterOrNumber + " is not a hex digit");
    }
}

