/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.EmptyPointSequence;
import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineString;
import org.geolatte.geom.PointSequence;

public class LinearRing
extends LineString {
    static final LinearRing EMPTY = new LinearRing(EmptyPointSequence.INSTANCE, null);

    public static LinearRing createEmpty() {
        return EMPTY;
    }

    protected LinearRing(LineString lineString) {
        super(lineString);
        this.checkIsClosed();
    }

    public LinearRing(PointSequence points, GeometryOperations geometryOperations) {
        super(points, geometryOperations);
        this.checkIsClosed();
    }

    public LinearRing(PointSequence points) {
        this(points, null);
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.LINEAR_RING;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    private void checkIsClosed() {
        if (this.isEmpty() || this.isClosed() && this.getNumPoints() > 3) {
            return;
        }
        throw new IllegalArgumentException("Cannot create a LinearRing. PointSequence is not closed or contains < 4 points.");
    }
}

