/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.io.Serializable;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.EmptyPointSequence;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.GeometryEquality;
import org.geolatte.geom.GeometryOperation;
import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.GeometryPointEquality;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.JTSGeometryOperations;
import org.geolatte.geom.NestedPointCollection;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.Points;
import org.geolatte.geom.crs.CrsId;

public abstract class Geometry
implements Serializable {
    private static final GeometryEquality geomEq = new GeometryPointEquality();
    private static final GeometryOperations defaultGeometryOperations = new JTSGeometryOperations();
    private final GeometryOperations geometryOperations;

    protected static PointCollection collectPointSets(Geometry[] geometries) {
        if (geometries == null || geometries.length == 0) {
            return EmptyPointSequence.INSTANCE;
        }
        PointCollection[] collections = new PointCollection[geometries.length];
        for (int i = 0; i < collections.length; ++i) {
            assert (geometries[i] != null);
            collections[i] = geometries[i].getPoints();
        }
        return new NestedPointCollection(collections);
    }

    protected Geometry(GeometryOperations geometryOperations) {
        this.geometryOperations = geometryOperations == null ? defaultGeometryOperations : geometryOperations;
    }

    public int getCoordinateDimension() {
        return this.getPoints().getCoordinateDimension();
    }

    public CrsId getCrsId() {
        return this.getPoints().getCrsId();
    }

    public int getSRID() {
        return this.getPoints().getCrsId().getCode();
    }

    public boolean is3D() {
        return this.getPoints().is3D();
    }

    public DimensionalFlag getDimensionalFlag() {
        return this.getPoints().getDimensionalFlag();
    }

    public boolean isMeasured() {
        return this.getPoints().isMeasured();
    }

    public boolean isEmpty() {
        return this.getPoints().isEmpty();
    }

    public int getNumPoints() {
        return this.getPoints().size();
    }

    public Point getPointN(int index) {
        if (index >= this.getPoints().size()) {
            throw new IndexOutOfBoundsException();
        }
        double[] coords = new double[this.getCoordinateDimension()];
        this.getPoints().getCoordinates(coords, index);
        return Points.create(coords, DimensionalFlag.valueOf(this.is3D(), this.isMeasured()), this.getCrsId());
    }

    protected static CrsId getCrsId(Geometry[] geometries) {
        if (geometries == null || geometries.length == 0 || geometries[0] == null) {
            return CrsId.UNDEFINED;
        }
        return geometries[0].getCrsId();
    }

    protected static GeometryOperations getGeometryOperations(Geometry[] geometries) {
        if (geometries == null || geometries.length == 0) {
            return null;
        }
        return geometries[0].getGeometryOperations();
    }

    public abstract PointCollection getPoints();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Geometry.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        Geometry otherGeometry = (Geometry)o;
        return geomEq.equals(this, otherGeometry);
    }

    public int hashCode() {
        int result = this.getGeometryType().hashCode();
        result = 31 * result + this.getPoints().hashCode();
        return result;
    }

    public abstract GeometryType getGeometryType();

    public boolean isSimple() {
        GeometryOperation<Boolean> op = this.getGeometryOperations().createIsSimpleOp(this);
        return op.execute();
    }

    public Geometry getBoundary() {
        GeometryOperation<Geometry> operation = this.getGeometryOperations().createBoundaryOp(this);
        return operation.execute();
    }

    public Envelope getEnvelope() {
        GeometryOperation<Envelope> operation = this.getGeometryOperations().createEnvelopeOp(this);
        return operation.execute();
    }

    public boolean disjoint(Geometry other) {
        return !this.intersects(other);
    }

    public boolean intersects(Geometry other) {
        GeometryOperation<Boolean> operation = this.getGeometryOperations().createIntersectsOp(this, other);
        return operation.execute();
    }

    public boolean touches(Geometry other) {
        GeometryOperation<Boolean> operation = this.getGeometryOperations().createTouchesOp(this, other);
        return operation.execute();
    }

    public boolean crosses(Geometry other) {
        GeometryOperation<Boolean> operation = this.getGeometryOperations().createCrossesOp(this, other);
        return operation.execute();
    }

    public boolean within(Geometry other) {
        return other.contains(this);
    }

    public boolean contains(Geometry other) {
        GeometryOperation<Boolean> operation = this.getGeometryOperations().createContainsOp(this, other);
        return operation.execute();
    }

    public boolean overlaps(Geometry other) {
        GeometryOperation<Boolean> operation = this.getGeometryOperations().createOverlapsOp(this, other);
        return operation.execute();
    }

    public boolean relate(Geometry other, String matrix) {
        GeometryOperation<Boolean> operation = this.getGeometryOperations().createRelateOp(this, other, matrix);
        return operation.execute();
    }

    public Geometry locateAlong(double mValue) {
        GeometryOperation<Geometry> operation = this.getGeometryOperations().createLocateAlongOp(this, mValue);
        return operation.execute();
    }

    public Geometry locateBetween(double mStart, double mEnd) {
        GeometryOperation<Geometry> operation = this.getGeometryOperations().createLocateBetweenOp(this, mStart, mEnd);
        return operation.execute();
    }

    public double distance(Geometry other) {
        GeometryOperation<Double> operation = this.getGeometryOperations().createDistanceOp(this, other);
        return operation.execute();
    }

    public Geometry buffer(double distance) {
        GeometryOperation<Geometry> operation = this.getGeometryOperations().createBufferOp(this, distance);
        return operation.execute();
    }

    public Geometry convexHull() {
        GeometryOperation<Geometry> operation = this.getGeometryOperations().createConvexHullOp(this);
        return operation.execute();
    }

    public Geometry intersection(Geometry other) {
        GeometryOperation<Geometry> operation = this.getGeometryOperations().createIntersectionOp(this, other);
        return operation.execute();
    }

    public Geometry union(Geometry other) {
        GeometryOperation<Geometry> operation = this.getGeometryOperations().createUnionOp(this, other);
        return operation.execute();
    }

    public Geometry difference(Geometry other) {
        GeometryOperation<Geometry> operation = this.getGeometryOperations().createDifferenceOp(this, other);
        return operation.execute();
    }

    public Geometry symDifference(Geometry other) {
        GeometryOperation<Geometry> operation = this.getGeometryOperations().createSymDifferenceOp(this, other);
        return operation.execute();
    }

    public String asText() {
        GeometryOperation<String> operation = this.getGeometryOperations().createToWktOp(this);
        return operation.execute();
    }

    public byte[] asBinary() {
        GeometryOperation<ByteBuffer> operation = this.getGeometryOperations().createToWkbOp(this);
        return operation.execute().toByteArray();
    }

    public String toString() {
        return this.asText();
    }

    public abstract int getDimension();

    public abstract void accept(GeometryVisitor var1);

    public GeometryOperations getGeometryOperations() {
        return this.geometryOperations;
    }
}

