/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import org.geolatte.geom.CoordinateComponent;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointVisitor;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.jts.DimensionalCoordinate;

abstract class AbstractPointCollection
implements PointCollection,
CoordinateSequence {
    private final DimensionalFlag dimensionalFlag;
    private final CrsId crsId;

    public AbstractPointCollection(DimensionalFlag dimensionalFlag, CrsId crsId) {
        this.dimensionalFlag = dimensionalFlag;
        this.crsId = crsId;
    }

    private static Coordinate[] toCoordinateArray(AbstractPointCollection set) {
        Coordinate[] coordinates = new Coordinate[set.size()];
        for (int i = 0; i < set.size(); ++i) {
            coordinates[i] = new DimensionalCoordinate(set.getDimensionalFlag());
            set.getCoordinate(i, coordinates[i]);
        }
        return coordinates;
    }

    @Override
    public DimensionalFlag getDimensionalFlag() {
        return this.dimensionalFlag;
    }

    @Override
    public CrsId getCrsId() {
        return this.crsId;
    }

    @Override
    public boolean is3D() {
        return this.dimensionalFlag.is3D();
    }

    @Override
    public boolean isMeasured() {
        return this.dimensionalFlag.isMeasured();
    }

    public int getDimension() {
        return this.getCoordinateDimension();
    }

    @Override
    public int getCoordinateDimension() {
        return this.dimensionalFlag.getCoordinateDimension();
    }

    public abstract PointCollection clone();

    @Override
    public void getCoordinates(double[] coordinates, int i) {
        if (coordinates.length < this.dimensionalFlag.getCoordinateDimension()) {
            throw new IllegalArgumentException(String.format("Coordinate array must be at least of getLength %d", this.dimensionalFlag.getCoordinateDimension()));
        }
        coordinates[this.dimensionalFlag.X] = this.getX(i);
        coordinates[this.dimensionalFlag.Y] = this.getY(i);
        if (this.is3D()) {
            coordinates[this.dimensionalFlag.Z] = this.getZ(i);
        }
        if (this.isMeasured()) {
            coordinates[this.dimensionalFlag.M] = this.getM(i);
        }
    }

    @Override
    public double getX(int position) {
        return this.getCoordinate(position, CoordinateComponent.X);
    }

    @Override
    public double getY(int position) {
        return this.getCoordinate(position, CoordinateComponent.Y);
    }

    @Override
    public double getZ(int position) {
        return this.getCoordinate(position, CoordinateComponent.Z);
    }

    @Override
    public double getM(int position) {
        return this.getCoordinate(position, CoordinateComponent.M);
    }

    public Coordinate getCoordinate(int i) {
        DimensionalCoordinate co = new DimensionalCoordinate(this.getDimensionalFlag());
        co.x = this.getX(i);
        co.y = this.getY(i);
        if (this.is3D()) {
            co.z = this.getZ(i);
        }
        if (this.isMeasured()) {
            co.m = this.getM(i);
        }
        return co;
    }

    public Coordinate getCoordinateCopy(int i) {
        return this.getCoordinate(i);
    }

    public void getCoordinate(int i, Coordinate coordinate) {
        coordinate.x = this.getX(i);
        coordinate.y = this.getY(i);
        coordinate.z = this.getZ(i);
        if (coordinate instanceof DimensionalCoordinate && ((DimensionalCoordinate)coordinate).isMeasured()) {
            ((DimensionalCoordinate)coordinate).m = this.getM(i);
        }
    }

    public double getOrdinate(int i, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.getCoordinate(i, CoordinateComponent.X);
            }
            case 1: {
                return this.getCoordinate(i, CoordinateComponent.Y);
            }
            case 2: {
                return this.getCoordinate(i, CoordinateComponent.Z);
            }
            case 3: {
                return this.getCoordinate(i, CoordinateComponent.M);
            }
        }
        throw new IllegalArgumentException("Ordinate index " + ordinateIndex + " is not supported.");
    }

    @Override
    public abstract double getCoordinate(int var1, CoordinateComponent var2);

    public void setOrdinate(int i, int ordinateIndex, double value) {
        throw new UnsupportedOperationException();
    }

    public Coordinate[] toCoordinateArray() {
        return AbstractPointCollection.toCoordinateArray(this);
    }

    public Envelope expandEnvelope(Envelope envelope) {
        EnvelopeExpander expander = new EnvelopeExpander(envelope);
        this.accept(expander);
        return expander.result();
    }

    @Override
    public void accept(PointVisitor visitor) {
        double[] coordinates = new double[this.getCoordinateDimension()];
        for (int i = 0; i < this.size(); ++i) {
            this.getCoordinates(coordinates, i);
            visitor.visit(coordinates);
        }
    }

    private static class EnvelopeExpander
    implements PointVisitor {
        private final Envelope env;

        EnvelopeExpander(Envelope env) {
            this.env = env;
        }

        @Override
        public void visit(double[] coordinates) {
            this.env.expandToInclude(coordinates[0], coordinates[1]);
        }

        public Envelope result() {
            return this.env;
        }
    }
}

