/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.geolatte.geom.codec.CrsWktDecoder;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrsRegistry.class);
    private static final Map<Integer, CoordinateReferenceSystem> crsMap = new HashMap<Integer, CoordinateReferenceSystem>(4000);
    private static final String DELIM = "\\|";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCRS() throws IOException {
        BufferedReader reader = CrsRegistry.createReader();
        try {
            String line = reader.readLine();
            CrsWktDecoder decoder = new CrsWktDecoder();
            while (line != null) {
                CrsRegistry.addDefinition(line, decoder);
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
    }

    private static BufferedReader createReader() {
        InputStream in = CrsRegistry.class.getClassLoader().getResourceAsStream("spatial_ref_sys.txt");
        if (in == null) {
            throw new IllegalStateException("Can't find spatial_ref_sys definitions.");
        }
        return new BufferedReader(new InputStreamReader(in));
    }

    private static void addDefinition(String line, CrsWktDecoder decoder) {
        String[] tokens = line.split(DELIM);
        if (!"EPSG".equals(tokens[0])) {
            return;
        }
        Integer srid = Integer.valueOf(tokens[1]);
        try {
            CoordinateReferenceSystem crs = decoder.decode(tokens[2]);
            crsMap.put(srid, crs);
        }
        catch (WktDecodeException e) {
            LOGGER.warn(String.format("Can't parse srid %d (%s). \n%s", srid, tokens[2], e.getMessage()));
        }
    }

    public static CoordinateReferenceSystem getEPSG(int epsgCode) {
        return crsMap.get(epsgCode);
    }

    static {
        try {
            CrsRegistry.loadCRS();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read spatial ref system definitions.");
        }
    }
}

