/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

public class CrsId {
    public static final String DEFAULT_AUTHORITY = "EPSG";
    public static final CrsId UNDEFINED = new CrsId("EPSG", -1);
    private final String authority;
    private final int code;

    public static CrsId parse(String srsString) {
        if (srsString == null || srsString.isEmpty()) {
            throw new IllegalArgumentException("Require input of form '<authority>:<code>");
        }
        String[] tokens = srsString.split(":");
        String codeStr = tokens[tokens.length - 1];
        int code = CrsId.toNumericIdentifier(codeStr);
        String authority = DEFAULT_AUTHORITY;
        if (tokens.length == 2) {
            authority = tokens[0];
        }
        return new CrsId(authority, code);
    }

    private static int toNumericIdentifier(String codeStr) {
        codeStr = codeStr.trim();
        try {
            return Integer.valueOf(codeStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Can't parse value %s into an integer.", codeStr));
        }
    }

    public static CrsId valueOf(String authority, int code) {
        return new CrsId(authority, code);
    }

    public static CrsId valueOf(int code) {
        return new CrsId(DEFAULT_AUTHORITY, code);
    }

    public CrsId(String authority, int code) {
        this.authority = authority;
        this.code = code;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return String.format("%S:%d", this.authority, this.code);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrsId crsId = (CrsId)o;
        if (this.code != crsId.code) {
            return false;
        }
        return !(this.authority != null ? !this.authority.equals(crsId.authority) : crsId.authority != null);
    }

    public int hashCode() {
        int result = this.authority != null ? this.authority.hashCode() : 0;
        result = 31 * result + this.code;
        return result;
    }
}

