/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktDimensionMarkerToken;
import org.geolatte.geom.codec.WktGeometryToken;
import org.geolatte.geom.codec.WktKeywordToken;
import org.geolatte.geom.codec.WktNumberToken;
import org.geolatte.geom.codec.WktPointSequenceToken;
import org.geolatte.geom.codec.WktTextToken;
import org.geolatte.geom.codec.WktToken;
import org.geolatte.geom.codec.WktVariant;

class WktTokenizer {
    private final CharSequence wkt;
    private final WktVariant variant;
    private int currentPos = 0;
    private boolean isMeasured = false;
    private final boolean pointListAsSingleToken;

    protected WktTokenizer(CharSequence wkt, WktVariant variant) {
        this(wkt, variant, true);
    }

    protected WktTokenizer(CharSequence wkt, WktVariant variant, boolean pointListAsSingleNumber) {
        if (wkt == null || variant == null) {
            throw new IllegalArgumentException("Input WKT and variant must not be null");
        }
        this.wkt = wkt;
        this.variant = variant;
        this.pointListAsSingleToken = pointListAsSingleNumber;
    }

    public boolean moreTokens() {
        this.skipWhitespace();
        return this.currentPos < this.wkt.length();
    }

    public WktToken nextToken() {
        if (!this.moreTokens()) {
            return this.variant.end();
        }
        if (this.wkt.charAt(this.currentPos) == this.variant.getOpenListChar()) {
            ++this.currentPos;
            return this.variant.getOpenList();
        }
        if (this.wkt.charAt(this.currentPos) == this.variant.getCloseListChar()) {
            ++this.currentPos;
            return this.variant.getCloseList();
        }
        if (this.wkt.charAt(this.currentPos) == '\"') {
            return this.readText();
        }
        if (Character.isLetter(this.wkt.charAt(this.currentPos))) {
            return this.readToken();
        }
        if (Character.isDigit(this.wkt.charAt(this.currentPos)) || this.wkt.charAt(this.currentPos) == '.' || this.wkt.charAt(this.currentPos) == '-') {
            if (this.pointListAsSingleToken) {
                return this.readPointList();
            }
            return this.readNumberToken();
        }
        if (this.wkt.charAt(this.currentPos) == this.variant.getElemSepChar()) {
            ++this.currentPos;
            return this.variant.getElementSeparator();
        }
        throw new WktDecodeException(String.format("Illegal Character at pos %d in Wkt text: %s", this.currentPos, this.wkt));
    }

    private WktToken readPointList() {
        DimensionalFlag dimensionalFlag = this.countDimension();
        int numPoints = this.countPoints();
        double[] coords = new double[dimensionalFlag.getCoordinateDimension()];
        PointSequenceBuilder psBuilder = PointSequenceBuilders.fixedSized(numPoints, dimensionalFlag);
        for (int i = 0; i < numPoints; ++i) {
            this.readPoint(coords);
            psBuilder.add(coords);
            this.skipPointDelimiter();
        }
        return new WktPointSequenceToken(psBuilder.toPointSequence());
    }

    private void readPoint(double[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = this.fastReadNumber();
        }
    }

    protected double fastReadNumber() {
        this.skipWhitespace();
        double d = 0.0;
        char c = this.wkt.charAt(this.currentPos);
        double sign = 1.0;
        if (c == '-') {
            sign = -1.0;
            c = this.wkt.charAt(++this.currentPos);
        }
        while (Character.isDigit(c)) {
            d = 10.0 * d + (double)(c - 48);
            c = this.wkt.charAt(++this.currentPos);
        }
        if (c == '.') {
            c = this.wkt.charAt(++this.currentPos);
            double divisor = 10.0;
            while (Character.isDigit(c)) {
                double f = c - 48;
                d += f / divisor;
                divisor *= 10.0;
                c = this.wkt.charAt(++this.currentPos);
            }
            return sign * d;
        }
        return sign * d;
    }

    protected double readNumber() {
        this.skipWhitespace();
        StringBuilder stb = new StringBuilder();
        char c = this.wkt.charAt(this.currentPos);
        if (c == '-') {
            stb.append(c);
            c = this.wkt.charAt(++this.currentPos);
        }
        if ((c = this.readDigits(stb, c)) == '.') {
            stb.append(c);
            c = this.wkt.charAt(++this.currentPos);
            this.readDigits(stb, c);
        }
        return Double.parseDouble(stb.toString());
    }

    private char readDigits(StringBuilder stb, char c) {
        while (Character.isDigit(c)) {
            stb.append(c);
            c = this.wkt.charAt(++this.currentPos);
        }
        return c;
    }

    protected WktToken readNumberToken() {
        double d = this.readNumber();
        return new WktNumberToken(d);
    }

    protected WktToken readText() {
        StringBuilder builder = new StringBuilder();
        char c = this.wkt.charAt(++this.currentPos);
        while (c != '\"') {
            builder.append(c);
            c = this.wkt.charAt(++this.currentPos);
        }
        ++this.currentPos;
        return new WktTextToken(builder.toString());
    }

    private int countPoints() {
        int pos = this.currentPos + 1;
        char c = this.wkt.charAt(pos);
        int num = 1;
        while (c != ')') {
            if (c == ',') {
                ++num;
            }
            c = this.wkt.charAt(++pos);
        }
        return num;
    }

    private DimensionalFlag countDimension() {
        int pos = this.currentPos;
        int num = 1;
        boolean inNumber = true;
        char c = this.wkt.charAt(pos);
        while (c != ',' && c != this.variant.getCloseListChar()) {
            if (!Character.isDigit(c) && c != '.' && c != '-') {
                inNumber = false;
            } else if (!inNumber) {
                ++num;
                inNumber = true;
            }
            if (pos == this.wkt.length() - 1) {
                throw new WktDecodeException("");
            }
            c = this.wkt.charAt(++pos);
        }
        if (num == 4) {
            return DimensionalFlag.XYZM;
        }
        if (num == 3 && this.isMeasured) {
            return DimensionalFlag.XYM;
        }
        if (num == 3 && !this.isMeasured) {
            return DimensionalFlag.XYZ;
        }
        if (num == 2) {
            return DimensionalFlag.XY;
        }
        throw new WktDecodeException("Point with less than 2 coordinates at position " + this.currentPos);
    }

    private void skipWhitespace() {
        while (this.currentPos < this.wkt.length() && Character.isWhitespace(this.wkt.charAt(this.currentPos))) {
            ++this.currentPos;
        }
    }

    private void skipPointDelimiter() {
        this.skipWhitespace();
        if (this.wkt.charAt(this.currentPos) == ',') {
            ++this.currentPos;
        }
    }

    private WktToken readToken() {
        int endPos;
        for (endPos = this.currentPos; endPos < this.wkt.length() && this.isWordChar(this.wkt.charAt(endPos)); ++endPos) {
        }
        WktToken nextToken = this.matchKeyword(this.currentPos, endPos);
        this.currentPos = endPos;
        return nextToken;
    }

    protected boolean isWordChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    private WktToken matchKeyword(int currentPos, int endPos) {
        WktKeywordToken token = this.variant.matchKeyword(this.wkt, currentPos, endPos);
        if (token instanceof WktGeometryToken) {
            this.isMeasured = ((WktGeometryToken)token).isMeasured();
        }
        if (token instanceof WktDimensionMarkerToken) {
            this.isMeasured = ((WktDimensionMarkerToken)token).isMeasured();
        }
        return token;
    }

    public int position() {
        return this.currentPos;
    }
}

