/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.codec.WkbGeometryType;
import org.geolatte.geom.crs.CrsId;

class PostgisWkbDecoder {
    private CrsId crsId;

    PostgisWkbDecoder() {
    }

    public Geometry decode(ByteBuffer byteBuffer) {
        this.crsId = CrsId.UNDEFINED;
        byteBuffer.rewind();
        return this.decodeGeometry(byteBuffer);
    }

    private Geometry decodeGeometry(ByteBuffer byteBuffer) {
        this.alignByteOrder(byteBuffer);
        int typeCode = this.readTypeCode(byteBuffer);
        WkbGeometryType wkbType = WkbGeometryType.parse((byte)typeCode);
        this.readSridIfPresent(byteBuffer, typeCode);
        DimensionalFlag flag = this.getCoordinateDimension(typeCode);
        switch (wkbType) {
            case POINT: {
                return this.decodePoint(byteBuffer, flag);
            }
            case LINE_STRING: {
                return this.decodeLineString(byteBuffer, flag);
            }
            case POLYGON: {
                return this.decodePolygon(byteBuffer, flag);
            }
            case GEOMETRY_COLLECTION: {
                return this.decodeGeometryCollection(byteBuffer);
            }
            case MULTI_POINT: {
                return this.decodeMultiPoint(byteBuffer);
            }
            case MULTI_POLYGON: {
                return this.decodeMultiPolygon(byteBuffer);
            }
            case MULTI_LINE_STRING: {
                return this.decodeMultiLineString(byteBuffer);
            }
        }
        throw new IllegalStateException(String.format("WKBType %s is not supported.", new Object[]{wkbType}));
    }

    private MultiLineString decodeMultiLineString(ByteBuffer byteBuffer) {
        int numGeometries = byteBuffer.getInt();
        LineString[] geometries = new LineString[numGeometries];
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = (LineString)this.decodeGeometry(byteBuffer);
        }
        return new MultiLineString(geometries);
    }

    private MultiPoint decodeMultiPoint(ByteBuffer byteBuffer) {
        int numGeometries = byteBuffer.getInt();
        Point[] geometries = new Point[numGeometries];
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = (Point)this.decodeGeometry(byteBuffer);
        }
        return new MultiPoint(geometries);
    }

    private MultiPolygon decodeMultiPolygon(ByteBuffer byteBuffer) {
        int numGeometries = byteBuffer.getInt();
        Polygon[] geometries = new Polygon[numGeometries];
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = (Polygon)this.decodeGeometry(byteBuffer);
        }
        return new MultiPolygon(geometries);
    }

    private GeometryCollection decodeGeometryCollection(ByteBuffer byteBuffer) {
        int numGeometries = byteBuffer.getInt();
        Geometry[] geometries = new Geometry[numGeometries];
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = this.decodeGeometry(byteBuffer);
        }
        return new GeometryCollection(geometries);
    }

    private Polygon decodePolygon(ByteBuffer byteBuffer, DimensionalFlag flag) {
        int numRings = byteBuffer.getInt();
        LinearRing[] rings = this.readPolygonRings(numRings, byteBuffer, flag, this.crsId);
        return new Polygon(rings);
    }

    private LineString decodeLineString(ByteBuffer byteBuffer, DimensionalFlag flag) {
        int numPoints = byteBuffer.getInt();
        PointSequence points = this.readPoints(numPoints, byteBuffer, flag);
        return new LineString(points, this.crsId);
    }

    private Point decodePoint(ByteBuffer byteBuffer, DimensionalFlag flag) {
        PointSequence points = this.readPoints(1, byteBuffer, flag);
        return new Point(points, this.crsId);
    }

    private PointSequence readPoints(int numPoints, ByteBuffer byteBuffer, DimensionalFlag dimensionalFlag) {
        PointSequenceBuilder psBuilder = PointSequenceBuilders.fixedSized(numPoints, dimensionalFlag);
        double[] coordinates = new double[dimensionalFlag.getCoordinateDimension()];
        for (int i = 0; i < numPoints; ++i) {
            this.readPoint(byteBuffer, dimensionalFlag, coordinates);
            psBuilder.add(coordinates);
        }
        return psBuilder.toPointSequence();
    }

    private void readPoint(ByteBuffer byteBuffer, DimensionalFlag dimensionalFlag, double[] coordinates) {
        for (int ci = 0; ci < dimensionalFlag.getCoordinateDimension(); ++ci) {
            coordinates[ci] = byteBuffer.getDouble();
        }
    }

    private LinearRing[] readPolygonRings(int numRings, ByteBuffer byteBuffer, DimensionalFlag dimensionalFlag, CrsId crsId) {
        LinearRing[] rings = new LinearRing[numRings];
        for (int i = 0; i < numRings; ++i) {
            rings[i] = this.readRing(byteBuffer, dimensionalFlag, crsId);
        }
        return rings;
    }

    private LinearRing readRing(ByteBuffer byteBuffer, DimensionalFlag dimensionalFlag, CrsId crsId) {
        int numPoints = byteBuffer.getInt();
        PointSequence ps = this.readPoints(numPoints, byteBuffer, dimensionalFlag);
        return new LinearRing(ps, crsId);
    }

    private DimensionalFlag getCoordinateDimension(int typeCode) {
        boolean hasM = (typeCode & 0x40000000) == 0x40000000;
        boolean hasZ = (typeCode & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        return DimensionalFlag.valueOf(hasZ, hasM);
    }

    private void readSridIfPresent(ByteBuffer byteBuffer, int typeCode) {
        if (this.hasSrid(typeCode)) {
            this.crsId = CrsId.valueOf(byteBuffer.getInt());
        }
    }

    private boolean hasSrid(int typeCode) {
        return (typeCode & 0x20000000) == 0x20000000;
    }

    private int readTypeCode(ByteBuffer byteBuffer) {
        return (int)byteBuffer.getUInt();
    }

    private void alignByteOrder(ByteBuffer byteBuffer) {
        byte orderByte = byteBuffer.get();
        ByteOrder byteOrder = ByteOrder.valueOf(orderByte);
        byteBuffer.setWKBByteOrder(byteOrder);
    }
}

