/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Point;
import org.geolatte.geom.Points;

public class Vector {
    public static double[] pointToSegment2D(Point p0, Point p1, Point y) {
        Point d = Vector.substract(p1, p0);
        Point ymp0 = Vector.substract(y, p0);
        double t = Vector.dot(d, ymp0, true);
        double dd = Vector.dot(d, d);
        if (t <= 0.0) {
            return new double[]{Vector.dot(ymp0, ymp0), t / dd};
        }
        if (t >= dd) {
            Point ymp1 = Vector.substract(y, p1);
            return new double[]{Vector.dot(ymp1, ymp1), t / dd};
        }
        return new double[]{Vector.dot(ymp0, ymp0) - t * t / dd, t / dd};
    }

    public static double dot(Point p0, Point p1) {
        return Vector.dot(p0, p1, false);
    }

    public static double dot(Point p0, Point p1, boolean limit2D) {
        if (limit2D || !p0.is3D() || !p1.is3D()) {
            return p0.getX() * p1.getX() + p0.getY() * p1.getY();
        }
        return p0.getX() * p1.getX() + p0.getY() * p1.getY() + p0.getZ() * p1.getZ();
    }

    public static Point add(Point p0, Point p1) {
        if (p0.is3D() && p1.is3D()) {
            return Points.create3D(p0.getX() + p1.getX(), p0.getY() + p1.getY(), p0.getZ() + p1.getZ());
        }
        return Points.create(p0.getX() + p1.getX(), p0.getY() + p1.getY());
    }

    public static Point substract(Point p0, Point p1) {
        if (p0.is3D() && p1.is3D()) {
            return Points.create3D(p0.getX() - p1.getX(), p0.getY() - p1.getY(), p0.getZ() - p1.getZ());
        }
        return Points.create(p0.getX() - p1.getX(), p0.getY() - p1.getY());
    }
}

